/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32.gdi;

import com.jniwrapper.DataBufferFactory;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.MemoryBuffer;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import teamdev.jxdesktop.win32.Handle;
import teamdev.jxdesktop.win32.LastErrorException;
import teamdev.jxdesktop.win32.gdi.Bitmap;
import teamdev.jxdesktop.win32.gdi.BitmapInfo;
import teamdev.jxdesktop.win32.gdi.BitmapInfoHeader;
import teamdev.jxdesktop.win32.gdi.BitmapStructure;
import teamdev.jxdesktop.win32.gdi.DC;
import teamdev.jxdesktop.win32.gdi.DIBitmap;
import teamdev.jxdesktop.win32.gdi.Gdi32;
import teamdev.jxdesktop.win32.gdi.GdiObject;
import teamdev.jxdesktop.win32.gdi.WindowDC;
import teamdev.jxdesktop.win32.gdi.bitmap.BitmapBuilder;
import teamdev.jxdesktop.win32.system.LocalMemoryBlock;
import teamdev.jxdesktop.win32.system.MemoryAllocationAttributes;
import teamdev.jxdesktop.win32.ui.User32;

public class DDBitmap
extends Bitmap {
    public static Function CREATE_COMPATIBLE_BITMAP = Gdi32.getInstance().getFunction("CreateCompatibleBitmap");
    private DC e;
    static Class d;

    public DDBitmap() {
        this.e = new WindowDC(null);
        this.setSize(0, 0);
    }

    public DDBitmap(long l2) {
        super(l2);
        this.e = new WindowDC(null);
        this.setSize(0, 0);
    }

    public DDBitmap(int n2, int n3) {
        this(new WindowDC(null), n2, n3);
    }

    public DDBitmap(DC dC, int n2, int n3) {
        this.e = dC;
        this.setSize(n2, n3);
        CREATE_COMPATIBLE_BITMAP.invoke((Parameter)this, (Parameter)this.e, (Parameter)new Int((long)n2), (Parameter)new Int((long)n3));
    }

    public DDBitmap(DIBitmap dIBitmap) {
        this((DC)new WindowDC(null), dIBitmap);
    }

    public DDBitmap(DC dC, DIBitmap dIBitmap) {
        this(dC, dIBitmap.getWidth(), dIBitmap.getHeight());
        PrimitiveArray primitiveArray = dIBitmap.getDIBytes();
        Function function = Gdi32.getInstance().getFunction("CreateDIBitmap");
        function.invoke((Parameter)this, new Parameter[]{dC, new Pointer((Parameter)dIBitmap.getDIBSection().getBitmapInfoHeader()), new UInt32(4L), new Pointer((Parameter)primitiveArray), new Pointer((Parameter)dIBitmap.getBitmapInfo()), new UInt(0L)});
    }

    public DDBitmap(String string) {
        this((DC)new WindowDC(null), string);
    }

    public DDBitmap(DC dC, String string) {
        this.e = dC;
        this.loadFromFile(string);
    }

    public DDBitmap(Image image) {
        this((DC)new WindowDC(null), image);
    }

    public DDBitmap(DC dC, Image image) {
        this(dC, image.getWidth(null), image.getHeight(null));
        BufferedImage bufferedImage = ImageUtils.createBufferedImage((Image)image);
        this.a(bufferedImage);
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        this.setSize((int)bitmapInfo.getBitmapInfoHeader().getWidth(), (int)bitmapInfo.getBitmapInfoHeader().getHeight());
    }

    public DDBitmap(Bitmap.PredefinedBitmap predefinedBitmap) {
        this((DC)new WindowDC(null), predefinedBitmap);
    }

    public DDBitmap(DC dC, Bitmap.PredefinedBitmap predefinedBitmap) {
        this.e = dC;
        this.loadPredefinedBitmap(predefinedBitmap);
    }

    public void loadFromFile(String string) {
        Function function = User32.getInstance().getFunction(User32.FUNCTION_LOAD_IMAGE.toString());
        Handle handle = new Handle();
        long l2 = function.invoke((Parameter)handle, new Parameter[]{new Pointer(null, true), new Str(string), new UInt((long)GdiObject.ImageType.BITMAP.getValue()), new Int(0L), new Int(0L), new UInt(32848L)});
        if (handle.isNull()) {
            throw new LastErrorException(l2, "Failed to load resource.", true);
        }
        this.setValue(handle.getValue());
        this.setSize((int)this.getBitmapStructure().getBitmapWidth(), (int)this.getBitmapStructure().getBitmapHeight());
    }

    public void loadPredefinedBitmap(Bitmap.PredefinedBitmap predefinedBitmap) {
        Function function = User32.getInstance().getFunction(User32.FUNCTION_LOAD_IMAGE.toString());
        Handle handle = new Handle();
        long l2 = function.invoke((Parameter)handle, new Parameter[]{new Pointer(null, true), new UInt32((long)predefinedBitmap.getValue()), new UInt((long)GdiObject.ImageType.BITMAP.getValue()), new Int(0L), new Int(0L), new UInt(32832L)});
        if (handle.isNull()) {
            throw new LastErrorException(l2, "Failed to load resource.", true);
        }
        this.setValue(handle.getValue());
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        this.setSize((int)bitmapInfo.getBitmapInfoHeader().getWidth(), (int)bitmapInfo.getBitmapInfoHeader().getHeight());
    }

    private void a(BufferedImage bufferedImage) {
        BitmapBuilder bitmapBuilder = _builderFactory.createBuilder(bufferedImage);
        BitmapInfo bitmapInfo = bitmapBuilder.getBitmapInfo();
        DIBitmap dIBitmap = new DIBitmap();
        this.createDIBSection(dIBitmap, new Pointer((Parameter)new Pointer((Parameter)bitmapBuilder.getBitmapData())), bitmapInfo);
        bitmapBuilder.setBitmapColors();
        PrimitiveArray primitiveArray = bitmapBuilder.getBitmapData();
        dIBitmap.getDIBits(this.e, 0, this.getHeight(), new Pointer((Parameter)primitiveArray), bitmapInfo, 0);
        this.setDIBits(this.e, 0, this.getHeight(), new Pointer((Parameter)primitiveArray), bitmapInfo, 0);
        Image image = bitmapBuilder.getTransparentMask();
        if (image != null) {
            this.setTransparentMask(image);
        }
    }

    public BitmapInfo getBitmapInfo() {
        BitmapInfo bitmapInfo = new BitmapInfo();
        this.getDIBits(this.e, 0, 0, new Pointer(null, true), bitmapInfo, 0);
        bitmapInfo.getBitmapInfoHeader().setCompression(Bitmap.Compression.RGB);
        return bitmapInfo;
    }

    public BitmapStructure getBitmapStructure() {
        BitmapStructure bitmapStructure = new BitmapStructure();
        this.getObject(this, (Parameter)bitmapStructure);
        return bitmapStructure;
    }

    public BitmapInfoHeader getBitmapInfoHeader() {
        return this.getBitmapInfo().getBitmapInfoHeader();
    }

    public DIBitmap toDIBitmap() {
        BitmapInfoHeader bitmapInfoHeader = this.getBitmapInfoHeader();
        int n2 = (int)bitmapInfoHeader.getHeight();
        int n3 = (int)bitmapInfoHeader.getWidth();
        int n4 = (int)bitmapInfoHeader.getSizeImage();
        PrimitiveArray primitiveArray = new PrimitiveArray(d == null ? (d = DDBitmap.a("com.jniwrapper.UInt8")) : d, n4);
        Pointer pointer = new Pointer((Parameter)primitiveArray);
        DIBitmap dIBitmap = new DIBitmap(n3, n2);
        this.createDIBSection(dIBitmap, this.e, this.getBitmapInfo(), 0, new Pointer((Parameter)pointer), new Handle(), 0);
        this.getDIBits(this.e, 0, n2, pointer, this.getBitmapInfo(), 0);
        return dIBitmap;
    }

    public PrimitiveArray getDIBytes() {
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        int n4 = this.getBitCount();
        Pointer pointer = new Pointer(null, true);
        this.getDIBits(this.e, 0, n2, pointer, bitmapInfo, 0);
        int n5 = n2 * n3 * n4 / 8;
        byte[] byArray = new byte[n5];
        PrimitiveArray primitiveArray = new PrimitiveArray(byArray);
        this.getDIBits(this.e, 0, n2, new Pointer((Parameter)primitiveArray), bitmapInfo, 0);
        return primitiveArray;
    }

    public byte[] getBytes() {
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        int n4 = this.getBitCount();
        Pointer pointer = new Pointer(null, true);
        this.getDIBits(this.e, 0, n2, pointer, bitmapInfo, 0);
        int n5 = n2 * n3 * n4 / 8;
        LocalMemoryBlock localMemoryBlock = new LocalMemoryBlock(n5, MemoryAllocationAttributes.FIXED);
        this.getDIBits(this.e, 0, n2, localMemoryBlock, bitmapInfo, 0);
        MemoryBuffer memoryBuffer = DataBufferFactory.getInstance().createExternMemoryBuffer(localMemoryBlock.getValue(), n5);
        byte[] byArray = memoryBuffer.readByteArray(0, n5);
        localMemoryBlock.free();
        return byArray;
    }

    public void setDIBytes(PrimitiveArray primitiveArray) {
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        this.setDIBits(this.e, 0, this.getHeight(), new Pointer((Parameter)primitiveArray), bitmapInfo, 0);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

