/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32.gdi;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int8;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt16;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.FlagSet;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import teamdev.jxdesktop.win32.Handle;
import teamdev.jxdesktop.win32.Size;
import teamdev.jxdesktop.win32.gdi.BitmapFileHeader;
import teamdev.jxdesktop.win32.gdi.BitmapInfo;
import teamdev.jxdesktop.win32.gdi.BitmapInfoHeader;
import teamdev.jxdesktop.win32.gdi.DC;
import teamdev.jxdesktop.win32.gdi.DIBitmap;
import teamdev.jxdesktop.win32.gdi.Gdi32;
import teamdev.jxdesktop.win32.gdi.GdiObject;
import teamdev.jxdesktop.win32.gdi.RGBQuad;
import teamdev.jxdesktop.win32.gdi.bitmap.BitmapBuilderFactory;
import teamdev.jxdesktop.win32.gdi.bitmap.BitmapBuilderFactoryImpl;

public abstract class Bitmap
extends GdiObject {
    protected static BitmapBuilderFactory _builderFactory = new BitmapBuilderFactoryImpl();
    public static Function FUNCTION_GET_DIBITS = Gdi32.getInstance().getFunction("GetDIBits");
    protected static final String FUNCTION_SET_DIBITS = "SetDIBits";
    protected static final String FUNCTION_CREATEDIBITMAP = "CreateDIBitmap";
    protected static final int DIB_RGB_COLORS = 0;
    protected static final int DIB_PAL_COLORS = 1;
    protected static final int CBM_INIT = 4;
    private Dimension c;
    private DIBitmap b;

    public Bitmap() {
    }

    public Bitmap(long l2) {
        super(l2);
    }

    public long setDIBits(DC dC, int n2, int n3, Pointer pointer, BitmapInfo bitmapInfo, int n4) {
        Int intVal = new Int();
        Function function = Gdi32.get(FUNCTION_SET_DIBITS);
        function.invoke((Parameter)intVal, new Parameter[]{dC, this, new UInt((long)n2), new UInt((long)n3), pointer, new Pointer((Parameter)bitmapInfo), new UInt((long)n4)});
        return intVal.getValue();
    }

    public long getDIBits(DC dC, int n2, int n3, Pointer pointer, BitmapInfo bitmapInfo, int n4) {
        Int intVal = new Int();
        FUNCTION_GET_DIBITS.invoke((Parameter)intVal, new Parameter[]{dC, this, new UInt((long)n2), new UInt((long)n3), pointer, new Pointer((Parameter)bitmapInfo), new UInt((long)n4)});
        return intVal.getValue();
    }

    public long getDIBits(DC dC, int n2, int n3, Pointer.Void void_, BitmapInfo bitmapInfo, int n4) {
        Int intVal = new Int();
        FUNCTION_GET_DIBITS.invoke((Parameter)intVal, new Parameter[]{dC, this, new UInt((long)n2), new UInt((long)n3), void_, new Pointer((Parameter)bitmapInfo), new UInt((long)n4)});
        return intVal.getValue();
    }

    protected void setSize(int n2, int n3) {
        this.c = new Dimension(n2, n3);
    }

    public Size getSize() {
        return new Size(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        return (int)this.c.getWidth();
    }

    public int getHeight() {
        return (int)this.c.getHeight();
    }

    private int a(PrimitiveArray primitiveArray, int n2) {
        return (int)((Int8)primitiveArray.getElement(n2)).getValue();
    }

    public void createDIBSection(DIBitmap dIBitmap, Pointer pointer, BitmapInfo bitmapInfo) {
        this.createDIBSection(dIBitmap, new DC(), bitmapInfo, 0, pointer, new Handle(), 0);
    }

    public void createDIBSection(DIBitmap dIBitmap, DC dC, BitmapInfo bitmapInfo, int n2, Pointer pointer, Handle handle, int n3) {
        Function function = Gdi32.get("CreateDIBSection");
        function.invoke((Parameter)dIBitmap, new Parameter[]{dC, new Pointer((Parameter)bitmapInfo), new UInt16(n2), pointer, handle, new UInt((long)n3)});
    }

    public int getBitCount() {
        return (int)this.getBitmapInfoHeader().getBitCount();
    }

    protected void setTransparentMask(Image image) {
        this.b = new DIBitmap(image);
    }

    public Bitmap getTransparentMask() {
        return this.b;
    }

    public boolean isTransparent() {
        return this.getBitCount() == 32 || this.b != null;
    }

    public void deleteObject() {
        super.deleteObject();
        if (this.b != null) {
            this.b.deleteObject();
        }
    }

    public BufferedImage toImage() {
        int n2 = this.getBitCount();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        return n2 >= 4 ? this.a(this.getBitmapInfo().getColors(), n3, n4, n2, this.getBytes()) : this.a(n3, n4, n2, this.getDIBytes());
    }

    private BufferedImage a(int n2, int n3, int n4, PrimitiveArray primitiveArray) {
        int n5 = -16777216;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        int n6 = 0;
        int n7 = 0;
        int n8 = (n2 * n4 + 31) / 32 * 4;
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                n7 = (n3 - 1 - i2) * n8 + i3 * n4 / 8;
                n6 = i3 * n4 % 8;
                int n9 = this.a(primitiveArray, n7);
                FlagSet flagSet = new FlagSet((long)n9);
                boolean bl = flagSet.getBit(7 - n6);
                int n10 = !bl ? n5 : 0;
                bufferedImage.setRGB(i3, i2, n10);
            }
        }
        return bufferedImage;
    }

    private BufferedImage a(PrimitiveArray primitiveArray, int n2, int n3, int n4, byte[] byArray) {
        int n5 = byArray.length / (n4 == 4 ? n4 * 2 : n4 / 8);
        int[] nArray = new int[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i2 = n5 - 1 - n2; i2 >= 0; i2 -= n2) {
            block7: for (int i3 = 0; i3 < n2; ++i3) {
                switch (n4) {
                    case 4: {
                        n6 = n7 / 8;
                        int n9 = byArray[n6];
                        n9 = n7 % 8 != 0 ? (n9 &= 0xF) : (n9 >>= 4);
                        RGBQuad rGBQuad = (RGBQuad)primitiveArray.getElement(n9);
                        n7 += 4;
                        nArray[i2 + i3] = rGBQuad.getRGB();
                        continue block7;
                    }
                    case 8: {
                        int n9 = byArray[n8++];
                        RGBQuad rGBQuad = (RGBQuad)primitiveArray.getElement(n9);
                        nArray[i2 + i3] = rGBQuad.getRGB();
                        continue block7;
                    }
                    case 16: {
                        int n9 = byArray[n8++];
                        short s2 = byArray[n8++];
                        int n10 = s2 << 8 | n9;
                        int n11 = (n10 & 0x1F) << 3;
                        int n12 = (n10 & 0x3E0) << 6;
                        int n13 = (n10 & 0x7C00) << 9;
                        nArray[i2 + i3] = n11 | n12 | n13;
                        continue block7;
                    }
                    case 24: 
                    case 32: {
                        int n9 = (short)byArray[n8++] & 0xFF;
                        int n14 = (short)byArray[n8++] & 0xFF;
                        int n10 = (short)byArray[n8++] & 0xFF;
                        int n11 = (short)byArray[n8++] & 0xFF;
                        if (n11 == 0) {
                            n11 = 255;
                        }
                        nArray[i2 + i3] = n9 | n14 << 8 | n10 << 16 | n11 << 24;
                    }
                }
            }
            if (n4 != 4) {
                n6 += (int)(4.0 * (Math.ceil((double)(n2 * n4) / 32.0) - (double)(n2 * n4) / 32.0));
                continue;
            }
            double d2 = 4.0 * (Math.ceil((double)(n2 * n4) / 32.0) - (double)(n2 * n4) / 32.0);
            n7 += (int)(d2 * 8.0);
        }
        DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        int[] nArray2 = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask()};
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, nArray.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n2, n3, n2, nArray2, null);
        return new BufferedImage(directColorModel, writableRaster, false, null);
    }

    public void saveToFile(String string) throws IOException {
        if (this.isNull()) {
            throw new RuntimeException("No bitmap was specified.");
        }
        File file = new File(string);
        if (!file.exists()) {
            file.createNewFile();
        }
        BitmapFileHeader bitmapFileHeader = new BitmapFileHeader();
        BitmapInfoHeader bitmapInfoHeader = this.getBitmapInfo().getBitmapInfoHeader();
        PrimitiveArray primitiveArray = this.getBitmapInfo().getColors();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (bitmapInfoHeader.getBitCount() == 1L) {
            primitiveArray = new PrimitiveArray(new Parameter[]{new RGBQuad(0, 0, 0), new RGBQuad(255, 255, 255)});
        }
        bitmapFileHeader.setOffBits(bitmapFileHeader.getLength() + bitmapInfoHeader.getLength() + primitiveArray.getLength());
        bitmapFileHeader.setSize(bitmapFileHeader.getLength() + bitmapInfoHeader.getLength() + primitiveArray.getLength() + this.getDIBytes().getLength());
        ((OutputStream)fileOutputStream).write(BitmapFileHeader.toByteArray((Parameter)bitmapFileHeader));
        ((OutputStream)fileOutputStream).write(BitmapFileHeader.toByteArray((Parameter)bitmapInfoHeader));
        ((OutputStream)fileOutputStream).write(BitmapFileHeader.toByteArray((Parameter)primitiveArray));
        ((OutputStream)fileOutputStream).write(BitmapFileHeader.toByteArray((Parameter)this.getDIBytes()));
        ((OutputStream)fileOutputStream).close();
    }

    public abstract BitmapInfoHeader getBitmapInfoHeader();

    public abstract BitmapInfo getBitmapInfo();

    public abstract void loadFromFile(String var1);

    public abstract PrimitiveArray getDIBytes();

    public abstract byte[] getBytes();

    public abstract void setDIBytes(PrimitiveArray var1);

    public static class PredefinedBitmap
    extends EnumItem {
        public static final PredefinedBitmap BTNCORNERS = new PredefinedBitmap(32758);
        public static final PredefinedBitmap BTSIZE = new PredefinedBitmap(32761);
        public static final PredefinedBitmap CHECK = new PredefinedBitmap(32760);
        public static final PredefinedBitmap CHECKBOXES = new PredefinedBitmap(32759);
        public static final PredefinedBitmap CLOSE = new PredefinedBitmap(32754);
        public static final PredefinedBitmap COMBO = new PredefinedBitmap(32738);
        public static final PredefinedBitmap DNARROW = new PredefinedBitmap(32752);
        public static final PredefinedBitmap DNARROWD = new PredefinedBitmap(32742);
        public static final PredefinedBitmap DNARROWI = new PredefinedBitmap(32736);
        public static final PredefinedBitmap LFARROW = new PredefinedBitmap(32750);
        public static final PredefinedBitmap LFARROWD = new PredefinedBitmap(32740);
        public static final PredefinedBitmap LFARROWI = new PredefinedBitmap(32734);
        public static final PredefinedBitmap MNARROW = new PredefinedBitmap(32739);
        public static final PredefinedBitmap REDUCE = new PredefinedBitmap(32749);
        public static final PredefinedBitmap REDUCED = new PredefinedBitmap(32746);
        public static final PredefinedBitmap RESTORE = new PredefinedBitmap(32747);
        public static final PredefinedBitmap RESTORED = new PredefinedBitmap(32744);
        public static final PredefinedBitmap RGARROW = new PredefinedBitmap(32751);
        public static final PredefinedBitmap RGARROWD = new PredefinedBitmap(32741);
        public static final PredefinedBitmap RGARROWI = new PredefinedBitmap(32735);
        public static final PredefinedBitmap SIZE = new PredefinedBitmap(32766);
        public static final PredefinedBitmap UPARROW = new PredefinedBitmap(32753);
        public static final PredefinedBitmap UPARROWD = new PredefinedBitmap(32743);
        public static final PredefinedBitmap UPARROWI = new PredefinedBitmap(32737);
        public static final PredefinedBitmap ZOOM = new PredefinedBitmap(32748);
        public static final PredefinedBitmap ZOOMD = new PredefinedBitmap(32745);

        private PredefinedBitmap(int n2) {
            super(n2);
        }
    }

    public static class Compression
    extends EnumItem {
        public static final Compression RGB = new Compression(0);
        public static final Compression RLE8 = new Compression(1);
        public static final Compression RLE4 = new Compression(2);
        public static final Compression BITFIELDS = new Compression(3);
        public static final Compression JPEG = new Compression(4);
        public static final Compression PNG = new Compression(5);

        protected Compression(int n2) {
            super(n2);
        }
    }
}

