/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxdesktop.win32;

import com.jniwrapper.LongInt;
import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import java.awt.Rectangle;
import teamdev.jxdesktop.win32.Size;

public class Rect
extends Structure {
    private LongInt a = new LongInt();
    private LongInt c = new LongInt();
    private LongInt b = new LongInt();
    private LongInt d = new LongInt();

    public Rect() {
        this.init(new Parameter[]{this.a, this.c, this.b, this.d});
    }

    public Rect(Rect rect) {
        this();
        this.initFrom(rect);
    }

    public Rect(long l2, long l3, long l4, long l5) {
        this();
        this.setLeft(l2);
        this.setTop(l3);
        this.setRight(l4);
        this.setBottom(l5);
    }

    public Rect(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void setLeft(long l2) {
        this.a.setValue(l2);
    }

    public long getLeft() {
        return this.a.getValue();
    }

    public void setTop(long l2) {
        this.c.setValue(l2);
    }

    public long getTop() {
        return this.c.getValue();
    }

    public void setRight(long l2) {
        this.b.setValue(l2);
    }

    public long getRight() {
        return this.b.getValue();
    }

    public void setBottom(long l2) {
        this.d.setValue(l2);
    }

    public long getBottom() {
        return this.d.getValue();
    }

    public void moveTo(long l2, long l3) {
        long l4 = this.getWidth();
        long l5 = this.getHeight();
        this.setLeft(l2);
        this.setTop(l3);
        this.setRight(l2 + l4);
        this.setBottom(l3 + l5);
    }

    public void moveBy(int n2, int n3) {
        this.setLeft(this.getTop() + (long)n2);
        this.setRight(this.getBottom() + (long)n2);
        this.setTop(this.getTop() + (long)n3);
        this.setBottom(this.getBottom() + (long)n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Rect: [").append(this.getLeft()).append(',').append(this.getTop()).append(',').append(this.getRight()).append(',').append(this.getBottom()).append(']');
        return stringBuffer.toString();
    }

    public Object clone() {
        return new Rect(this);
    }

    public void assign(Rect rect) {
        this.setTop(rect.getTop());
        this.setBottom(rect.getBottom());
        this.setLeft(rect.getLeft());
        this.setRight(rect.getRight());
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.setTop(n3);
        this.setBottom(n5);
        this.setLeft(n2);
        this.setRight(n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.setTop(rectangle.y);
        this.setBottom(rectangle.x + rectangle.width);
        this.setLeft(rectangle.x);
        this.setRight(rectangle.y + rectangle.height);
    }

    public int getWidth() {
        return (int)(this.b.getValue() - this.a.getValue());
    }

    public int getHeight() {
        return (int)(this.d.getValue() - this.c.getValue());
    }

    public int getLeftAsInt() {
        return (int)this.getLeft();
    }

    public int getTopAsInt() {
        return (int)this.getTop();
    }

    public int getBottomAsInt() {
        return (int)this.getBottom();
    }

    public int getRightAsInt() {
        return (int)this.getRight();
    }

    public Rect centerRect(Size size) {
        int n2 = (int)this.getLeft() + (this.getWidth() - size.getCx()) / 2;
        int n3 = (int)this.getTop() + (this.getHeight() - size.getCy()) / 2;
        return new Rect(n2, n3, n2 + size.getCx(), n3 + size.getCy());
    }
}

