/*
 * Decompiled with CFR 0.152.
 */
package teamdev.jxcapture.controllers;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import teamdev.jxcapture.events.CaptureListener;
import teamdev.jxcapture.painters.SelectionPainter;

public abstract class SelectionController {
    protected CaptureListener captureListener;

    protected SelectionController() {
    }

    public abstract boolean onKeyAction(KeyEvent var1);

    public abstract boolean onMouseAction(MouseEvent var1);

    public abstract SelectionPainter getSelectionPainter();

    public void activate(CaptureListener captureListener) {
        this.captureListener = captureListener;
        SelectionPainter selectionPainter = this.getSelectionPainter();
        if (selectionPainter != null) {
            selectionPainter.selectionStart();
        }
    }

    protected void fireCompleteAction() {
        SelectionPainter selectionPainter = this.getSelectionPainter();
        if (selectionPainter != null) {
            selectionPainter.selectionEnd();
            BufferedImage bufferedImage = selectionPainter.getSelectedArea();
            this.captureListener.complete(bufferedImage);
        }
    }

    protected void fireCancelAction() {
        SelectionPainter selectionPainter = this.getSelectionPainter();
        if (selectionPainter != null) {
            selectionPainter.selectionEnd();
        }
        if (this.captureListener != null) {
            this.captureListener.cancel();
        }
    }
}

