// Example2Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "Example2.h"
#include "Example2Dlg.h"
#include "Winnetwk.h"  //Need this for BROWSEINFO structure
#include "SHLOBJ.H"    //Need this for BROWSEINFO structure


#include "tszd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExample2Dlg dialog

CExample2Dlg::CExample2Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExample2Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CExample2Dlg)
	m_ZipFileName = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CExample2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExample2Dlg)
	DDX_Control(pDX, IDC_LIST, m_FileListCtrl);
	DDX_Text(pDX, IDC_FileName, m_ZipFileName);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CExample2Dlg, CDialog)
	//{{AFX_MSG_MAP(CExample2Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_UnzipAll, OnBUTTONUnzipAll)
	ON_BN_CLICKED(IDC_BUTTON_SelectFile, OnBUTTONSelectFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExample2Dlg message handlers

BOOL CExample2Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	m_FileListCtrl.InsertColumn(0, "File-Name", LVCFMT_LEFT, 90);
	m_FileListCtrl.InsertColumn(1, "Size", LVCFMT_LEFT, 60);
	m_FileListCtrl.InsertColumn(2, "Unpacked", LVCFMT_LEFT, 60);
	m_FileListCtrl.InsertColumn(3, "Path", LVCFMT_LEFT, 90);
	OnBUTTONSelectFile();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CExample2Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CExample2Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CExample2Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CExample2Dlg::OnBUTTONUnzipAll() 
{
	if (m_ZipFileName.IsEmpty())
	{
		MessageBox("Zip file name field can not be empty.", "Zip File Name Empty!", MB_ICONSTOP);
		return;
	}
	char zfn[200];
	strcpy(zfn, m_ZipFileName);
	if (zOpenZipFile((char *)&zfn))
	{
		CString ReturnError = zGetLastErrorAsText();
		MessageBox("Recieved the following error message:\r\n" + ReturnError,"Unzip Error", MB_ICONERROR);
		return;
	}
	char DownloadPath[256];
	char MyDialogTitle[] = "Select Destination Directory";
	BROWSEINFO MyBROWSEINFO;
	memset(&MyBROWSEINFO, 0, sizeof(MyBROWSEINFO));
	MyBROWSEINFO.pszDisplayName = DownloadPath;
	MyBROWSEINFO.lpszTitle = MyDialogTitle;
	MyBROWSEINFO.ulFlags = BIF_RETURNONLYFSDIRS;
	LPITEMIDLIST MyITEMIDLIST;
	MyITEMIDLIST = SHBrowseForFolder(&MyBROWSEINFO);
	SHGetPathFromIDList(MyITEMIDLIST, DownloadPath); 
	if (strlen(DownloadPath))
	{
		if (strlen(DownloadPath) > 3) strcat(DownloadPath, "\\");
		if (zExtractAll((char *)&DownloadPath, "", 0, 0, 0, NULL))
		{
			CString ReturnError = zGetLastErrorAsText();
			MessageBox("Recieved the following error while extracting file(s):\r\n" + ReturnError,"Extract Error", MB_ICONERROR);
			return;
		}
		MessageBox("Extracted files successfully","",MB_ICONINFORMATION);
	}
	zCloseZipFile();
}

void CExample2Dlg::OnBUTTONSelectFile() 
{
	static char BASED_CODE szFilter[] = 
		"Zip Files (*.zip)|*.zip|All Files (*.*)|*.*||";
	CFileDialog MyCFileDialog(TRUE, "zip", m_ZipFileName, OFN_FILEMUSTEXIST, szFilter, NULL);
	MyCFileDialog.DoModal();
	if (MyCFileDialog.GetPathName().GetLength())
	{
		m_ZipFileName = MyCFileDialog.GetPathName();
	}
	SetWindowText( "TSZD (" + m_ZipFileName + (CString) ")");
	UpdateList();
	UpdateData(FALSE);
}

void CExample2Dlg::UpdateList()
{
	char zfn[200];
	strcpy(zfn, m_ZipFileName);
	if (zOpenZipFile((char *)&zfn))
	{
		CString ReturnError = zGetLastErrorAsText();
		MessageBox("Recieved the following error message:\r\n" + ReturnError,"Unzip Error", MB_ICONERROR);
		return;
	}
	m_FileListCtrl.DeleteAllItems();
	for (int i=zGetTotalFiles()-1; i>-1; i--)
	{
		if (!strlen(zGetFileName(i))) continue;
		m_FileListCtrl.InsertItem(0,zGetFileName(i));
		m_FileListCtrl.SetItemText(0,1,itoa(zGetFileSize(i), zfn, 10));
		m_FileListCtrl.SetItemText(0,2,itoa(zGetCompressedFileSize(i), zfn, 10));
		m_FileListCtrl.SetItemText(0,3,zGetFilePath(i));
	}
}
