function dataIn() {
  switchInOut('data', 'seldata[]');
}

function dataOut() {
  switchInOut('seldata[]', 'data');
}

function dataUpDown(pOffset) {
  var Elem = formByName('import').elements['seldata[]'];
  var J = pOffset;
  var L = Elem.options.length;
  if (pOffset < 0) {
    J = 0;
    L += pOffset;
  }
  for (var I = J; I < L; I++) {
    var Opt1 = Elem.options[I];
    var Opt2 = Elem.options[I - pOffset];
    if (Opt1.selected) {
      Elem.options[I] = new Option(Opt2.text, Opt2.value, false, Opt2.selected);
      Elem.options[I - pOffset] = new Option(Opt1.text, Opt1.value, false, Opt1.selected);
      break;
    }
  }
}

function doConfirmActionRemovePerson(pMsg, pIndex, pSubIndex) {
  loadPageConfirm(pMsg, '&page=details_company&action=removeperson&index=' + pIndex + '&subindex=' + pSubIndex);
}

function doConfirmActionRemoveCompany(pMsg, pIndex, pSubIndex) {
  loadPageConfirm(pMsg, '&page=details_person&action=removecompany&index=' + pIndex + '&subindex=' + pSubIndex);
}

function doConfirmActionResetSettings(pMsg) {
  loadPageConfirm(pMsg, '&page=settings&action=reset');
}

function doConfirmAction(pTab, pAction, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&action=' + pAction + '&index=' + pIndex + '&tab=' + pTab);
}

function doPopupActionAddCompany(pIndex, pSubIndex) {
  goOpener('index.php?umi=org_contacts&page=details_person&action=addcompany&index=' + pIndex + '&subindex=' + pSubIndex);
  window.close();
}

function doPopupActionAddPerson(pIndex, pSubIndex) {
  goOpener('index.php?umi=org_contacts&page=details_company&action=addperson&index=' + pIndex + '&subindex=' + pSubIndex);
  window.close();
}

function doPopupActionPublish(pTab, pMsg, pIndex) {
  if (confirm(pMsg)) {
    goOpener('index.php?umi=org_contacts&action=publish&index=' + pIndex + '&owner=' + encodeURIComponent(getSelectSelValue(formByIndex(0).elements['selowner'])) + '&tab=' + pTab);
    window.close();
  }
}

function getDynCompany() {
  var Form = formByName('details').elements;
  Form['dyn_company'].value = '';
  var S = Form['company'].value;
  if (S == '')
    displayElemById('ok', 'inline');
  else {
    displayElemById('ok', 'none');
    doHttpRequest('plain.php?umi=org_contacts&page=company.dyn', 'showDynCompany', '', 'name=' + encodeURIComponent(S));
  }
}

function hideDynCompany() {
  window.setTimeout("displayElemById('dyn_company', 'none');", 300);
}

function popupAdb() {
  popupWindow('plain.php?umi=org_contacts&page=adb.pop', 300, 420);
}

function popupAddCompany(pIndex) {
  popupWindow('plain.php?umi=org_contacts&page=addcompany.pop&index=' + pIndex, 300, 420);
}

function popupAddPerson(pIndex) {
  popupWindow('plain.php?umi=org_contacts&page=addperson.pop&index=' + pIndex, 300, 420);
}

function popupHistoryCompany(pIndex) {
  popupWindow('plain.php?page=history.pop&entity=org_contacts_companies&index=' + pIndex, 240, 500);
}

function popupHistoryPerson(pIndex) {
  popupWindow('plain.php?page=history.pop&entity=org_contacts_people&index=' + pIndex, 240, 500);
}

function popupPublish(pType, pIndex) {
  popupWindow('plain.php?umi=org_contacts&page=publish.pop&index=' + pIndex + '&type=' + pType, 100, 220);
}

function selSort(pObj) {
  if (getSelectSelValue(pObj) == '')
    pObj.selectedIndex = 0;
  else
    submitFormIndicator('view');
}

function setDynCompany(pIndex, pName) {
  var Form = formByName('details').elements;
  Form['dyn_company'].value = pIndex;
  Form['company'].value = pName;
  displayElemById('ok', 'inline');
}

function showDynCompany(pValue, pParam) {
  setHTML(pValue, 'dyn_company');
  fadeElemById('dyn_company', pValue == '' ? 'none' : 'block');
}

function submitImport(pMsg) {
  if (confirm(pMsg)) {
    var Elem = formByName('import').elements['seldata[]'].options;
    for (var I in Elem)
      Elem[I].selected = true;
    showIndicator();
    return true;
  } else
    return false;
}

function switchInOut(pFrom, pTo) {
  var Form = formByName('import').elements;
  Form[pTo].selectedIndex = -1;
  for (var I in Form[pFrom].options) {
    var Elem = Form[pFrom].options[I];
    if (Elem.selected) {
      if (pTo != 'data' || Elem.value != '_')
        Form[pTo].options[Form[pTo].options.length] = new Option(Elem.text, Elem.value, false, true);
      if (pFrom != 'data' || Elem.value != '_')
        Form[pFrom].options[I] = null;
      else
        I++;
    } else
      I++;
  }
}

function testImport() {
  with (formByName('import')) {
    elements['test'].value = '1';
    var Elem = elements['seldata[]'].options;
    for (var I in Elem)
      Elem[I].selected = true;
  }
  submitFormIndicator('import');
}

function updatePerson() {
  with (formByName('details'))
    setHTML(htmlcode(elements['firstname'].value + ' ' + elements['lastname'].value), 'title');
}