/*
 * New editor name:  tde, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991
 *
 * This modification of Douglas Thomson's code is released into the
 * public domain, Frank Davis.  You may distribute it freely.
 *
 * This file contains all the prototypes for every function in tde.
 */

/*************************  function prototypes in block.c *************/
void mark_block( windows * );
void unmark_block( windows * );
void restore_marked_block( windows *, int );
int  prepare_block( windows *, text_ptr, int, int );
void pad_dest_line( windows *, file_infos *, text_ptr );
void move_copy_delete_overlay_block( windows * );
void load_buff( char *, text_ptr, int, int, int );
int  copy_buff_2file( windows *, char *, text_ptr, int, int, int );
void block_fill( char *, int, int );
void restore_start_end( file_infos *, file_infos *, long, long, int );
void restore_cursors( file_infos *, file_infos * );
void delete_box_block( windows *, text_ptr, int, int, int );
void check_block( void );
void find_begblock( file_infos * );
void find_endblock( file_infos * );
void block_write( windows * );
void block_print( windows * );
int  get_block_fill_char( windows *, int * );
void block_expand_tabs( windows * );
/************************************************************************/


/*************************  function prototypes in ed.c *****************/
void tab_key( windows * );
void insert_newline( windows * );
void insert_overwrite( windows * );
void join_line( windows * );
void dup_line( windows * );
void word_delete( windows * );
void back_space( windows * );
void line_kill( windows * );
void char_del_under( windows * );
void eol_kill( windows * );
void undo_line( windows * );
void undo( windows * );
void beg_next_line( windows *window );
void next_line( windows *window );
void goto_left( windows * );
void goto_right( windows * );
void goto_top( windows * );
void goto_bottom( windows * );
void set_tabstop( windows * );
void show_line_col( windows * );
void show_asterisk( int, int );
void toggle_overwrite( windows * );
void toggle_sdel( windows * );
void toggle_indent( windows * );
void toggle_search_case( windows * );
void editor( int, char *[] );
/************************************************************************/

/*************************  function prototypes in findrep.c ************/
int  get_replacement_flags( int );
int  ask_replace( windows *, int * );
void do_replace( windows *, text_ptr, int );
void find_string( windows * );
void build_boyer_array( void );
text_ptr  forward_boyer_moore_search( windows * );
text_ptr  backward_boyer_moore_search( windows * );
void find_adjust( windows *, text_ptr );
void replace_string( windows * );
int  replace_and_display( windows *, text_ptr, int *, int *, int );
void goto_top_file( windows * );
void goto_end_file( windows * );
text_ptr  scan_forward( text_ptr, char, char );
text_ptr  scan_backward( text_ptr, char, char );
void match_pair( windows * );
void goto_line( windows * );
/************************************************************************/

/*************************  function prototypes in main.c  **************/
void main( int, char *[] );
void error( int, int, char * );
#if defined( __MSC__ )
int  interrupt far harmless( void );
#else
static int harmless( void );
#endif
void terminate( void );
void hw_initialize( void );
#if defined (__MSC__)
   void video_config( struct vcfg *cfg );
#endif
void set_cursor_size( int );
void hw_move( text_ptr, text_ptr, long );
int  hw_fattrib( char * );
int  hw_unlink( char *, int );
int  write_file( char *, char *, text_ptr, text_ptr, int );
int  hw_save( char *, text_ptr, text_ptr, int );
int  hw_append( char *, text_ptr, text_ptr, int );
int  hw_load( char *, text_ptr, text_ptr, text_ptr *, int );
void get_help( windows * );
void show_credits( void );
int  getkey( void );
int  getfunc( int );
/************************************************************************/

/*************************  function prototypes in hwind.c **************/
void xygoto( int, int );
void save_screen_line( int, int, char * );
void restore_screen_line( int, int, char * );
void cls( void );
void initialize( void );
void show_end_mem( void );
void show_end_text( windows * );
void show_modes( void );
void show_window_count( int );
void show_file_count( int );
void show_avail_mem( void );
void show_indent_mode( void );
void show_insert_mode( void );
void show_search_case( void );
void show_sdelete_mode( void );
void window_scroll_up( int, int );
void window_scroll_down( int, int );
void window_scroll_up_eof( int, int );
void combine_strings( char *, char *, char *, char * );
/************************************************************************/

/*************************  function prototypes in utils.c **************/
int  myisalnum( int );
void check_virtual_col( windows *, int, int );
void copy_line( text_ptr, int );
void un_copy_line( text_ptr, windows *, int );
void load_undo_buffer( text_ptr );
int  load_file( char * );
void set_prompt( char *, int );
int  get_name( char *, int, char *, int );
int  get_yn( void );
int  get_oa( void );
void show_eof( int );
void display_current_window( windows * );
void redraw_screen( windows * );
void redraw_current_window( windows * );
void show_changed_line( windows * );
void dup_window_info( windows *, windows * );
void addorsub_all_cursors( windows *, long );
void adjust_windows_cursor( windows *, int );
void adjust_start_end( file_infos *, long );
int  first_non_blank( char far * );
void page_up( windows * );
void page_down( windows * );
void scroll_down( windows * );
void scroll_up( windows * );
void fixed_scroll_up( windows * );
void fixed_scroll_down( windows * );
void file_file( windows * );
void save_file( windows * );
void save_as_file( windows * );
void show_window_header( char *, windows * );
void show_size_name( windows * );
void show_size( windows * );
void quit( windows * );
void move_up( windows * );
void move_down( windows * );
void move_left( windows * );
void move_right( windows * );
void word_left( windows * );
void word_right( windows * );
void center_window( windows * );
void horizontal_screen_right( windows * );
void horizontal_screen_left( windows * );
/************************************************************************/

/*************************  function prototypes in window.c *************/
int  initialize_window( void );
void choose_window( char *, windows * );
void next_window( windows * );
void prev_window( windows * );
void split_screen( windows * );
void size_window( windows * );
void zoom_window( windows * );
void next_hidden_window( windows * );
void setup_window( windows * );
void finish( windows * );
int  create_window( windows **, int, int, file_infos * );
int  edit_file( char * );
void edit_another_file( windows * );
/************************************************************************/

/*************************  function prototypes in tdeasm.c *************/
text_ptr cpf( text_ptr );
text_ptr cpb( text_ptr );
unsigned long ptoul( text_ptr );
text_ptr nptop( text_ptr );
text_ptr addltop( long, text_ptr );
int  find_CONTROL_Z( text_ptr );
int  linelen( text_ptr );
text_ptr  find_next( text_ptr );
text_ptr  find_prev( text_ptr );
void update_line( windows * );
void update_char( windows *, int, int, int );
void c_output( int, int, int, int );
void s_output( char far *, int, int, int );
void s_output_far( char far *, int, int, int );
void eol_clear( int, int, int );
/*****************************************************/

/***********  function prototype for simul101.asm *************/
void far simulate_enh_kbd( int );
/*****************************************************/
