/*******************  start of original comments  ********************/
/*
 * Written by Douglas Thomson (1989/1990)
 *
 * This source code is released into the public domain.
 */
/*********************  end of original comments   ********************/

/*
 * New editor name:  tde, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991
 *
 * This modification of Douglas Thomson's code is released into the
 * public domain, Frank Davis.  You may distribute it freely.
 *
 * See "tdestr.h" for a description of these variables. (C requires global
 *  variables to be declared "extern" in all modules except one. This file
 *  is only included by the main "ed.c" module.)
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#ifdef __TURBOC__
   #include <stdlib.h>
#elif __MSC__
   #include <stdlib.h>
   #if defined( toupper )
       #undef toupper
   #endif
#endif

displays g_display;

status_infos g_status;

boyer_moore_type bm;

mode_infos mode = {
   0,           /* initial color scheme */
   TRUE,        /* insert mode */
   TRUE,        /* indent mode */
   8,           /* tab size */
   FALSE,       /* use backup files */
   FALSE,       /* stream delete with the delete key */
   FALSE,        /* enhanced keyboard flag */
   "<=======   End of File   ========>"        /* eof message */
};

/*
 * do_it is an array of pointers to functions that return void with an argument
 * that is a pointer to a window.  Is that right???
 */
void (* (do_it[77]))( windows * ) = {
   insert_overwrite,                /*   regular text keys       0   */
   get_help,                        /*   Help                    1   */
   insert_newline,                  /*   Rturn                   2   */
   next_line,                       /*   NextLine                3   */
   beg_next_line,                   /*   BegNextLine             4   */
   move_down,                       /*   LineDown                5   */
   move_up,                         /*   LineUp                  6   */
   move_right,                      /*   CharRight               7   */
   move_left,                       /*   CharLeft                8   */
   word_right,                      /*   WordRight               9   */
   word_left,                       /*   WordLeft                10  */
   page_down,                       /*   ScreenDown              11  */
   page_up,                         /*   ScreenUp                12  */
   goto_end_file,                   /*   EndOfFile               13  */
   goto_top_file,                   /*   TopOfFile               14  */
   goto_bottom,                     /*   BotOfScreen             15  */
   goto_top,                        /*   TopOfScreen             16  */
   goto_right,                      /*   EndOfLine               17  */
   goto_left,                       /*   BegOfLine               18  */
   goto_line,                       /*   JumpToLine              19  */
   center_window,                   /*   CenterWindow            20  */
   center_window,                   /*   CenterLine              21  */
   horizontal_screen_right,         /*   HorizontalScreenRight   22  */
   horizontal_screen_left,          /*   HorizontalScreenLeft    23  */
   scroll_down,                     /*   ScrollDnLine            24  */
   scroll_up,                       /*   ScrollUpLine            25  */
   fixed_scroll_up,                 /*   FixedScrollUp           26  */
   fixed_scroll_down,               /*   FixedScrollDn           27  */
   toggle_overwrite,                /*   ToggleOverWrite         28  */
   toggle_indent,                   /*   ToggleIndent            29  */
   toggle_sdel,                     /*   ToggleSdel              30  */
   set_tabstop,                     /*   SetTabs                 31  */
   tab_key,                         /*   Tab                     32  */
   match_pair,                      /*   ParenBalance            33  */
   back_space,                      /*   BackSpace               34  */
   char_del_under,                  /*   DeleteChar              35  */
   line_kill,                       /*   DeleteLine              36  */
   eol_kill,                        /*   DelEndOfLine            37  */
   word_delete,                     /*   WordDelete              38  */
   insert_newline,                  /*   AddLine                 39  */
   insert_newline,                  /*   SplitLine               40  */
   join_line,                       /*   JoinLine                41  */
   dup_line,                        /*   DuplicateLine           42  */
   undo_line,                       /*   AbortCommand            43  */
   undo_line,                       /*   UndoLine                44  */
   undo,                            /*   UndoDelete              45  */
   toggle_search_case,              /*   ToggleSearchCase        46  */
   find_string,                     /*   FindForward             47  */
   find_string,                     /*   FindBackward            48  */
   find_string,                     /*   RepeatFindForward       49  */
   find_string,                     /*   RepeatFindBackward      50  */
   replace_string,                  /*   ReplaceForward          51  */
   replace_string,                  /*   ReplaceBackward         52  */
   mark_block,                      /*   MarkBlock               53  */
   mark_block,                      /*   MarkLine                54  */
   unmark_block,                    /*   UnMarkBlock             55  */
   move_copy_delete_overlay_block,  /*   FillBlock               56  */
   move_copy_delete_overlay_block,  /*   CopyBlock               57  */
   move_copy_delete_overlay_block,  /*   KopyBlock               58  */
   move_copy_delete_overlay_block,  /*   MoveBlock               59  */
   move_copy_delete_overlay_block,  /*   OverlayBlock            60  */
   move_copy_delete_overlay_block,  /*   DeleteBlock             61  */
   block_write,                     /*   BlockToFile             62  */
   block_print,                     /*   PrintBlock              63  */
   block_expand_tabs,               /*   BlockExpandTabs         64  */
   file_file,                       /*   File                    65  */
   edit_another_file,               /*   EditFile                66  */
   save_file,                       /*   Save                    67  */
   save_as_file,                    /*   SaveAs                  68  */
   redraw_screen,                   /*   RedrawScreen            69  */
   size_window,                     /*   SizeWindow              70  */
   split_screen,                    /*   SplitScreen             71  */
   next_window,                     /*   NextWindow              72  */
   prev_window,                     /*   PreviousWindow          73  */
   zoom_window,                     /*   ZoomWindow              74  */
   next_hidden_window,              /*   NextHiddenWindow        75  */
   quit                             /*   Quit                    76  */
};
