/*
 * New editor name:  tde, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991
 *
 * This modification of Douglas Thomson's code is released into the
 * public domain, Frank Davis.  You may distribute it freely.
 *
 * Set up default dispatch table.
 *
 * If you want to change the default key assignments - it's really easy.  All
 * you have to do is set the appropriate array element to the desired function
 * and then recompile the source code.  The available functions are in the
 * define.h file.
 *
 * The key code return by pressing a function key is added to 256.  This is
 * done because it makes it easy to allow the ASCII and Extended ASCII
 * characters to get thru as normal characters and to trap the function keys
 * because they are greater than 256.  Once a function is detected, 256 is
 * subtracted from the key code which maps the function key codes to
 * 0-206 (MAX_KEYS).  See function getfunc( ) at the bottom of main.c.
 *
 * Look in the back of the MSC 6.0a manual or a MASM manual to find out what
 * the extended codes are for the various key combinations.  For example,
 * ALT+M = 50.  Add 50 to 256 which equals 306.
 *
 * If you change the default key assignments, you should also change the help
 * screen (in help.h) to show what function the new key is assigned to.
 *
 * The insert_overwrite function is assigned the index of 0.  If the key
 * code is less than 256 then a character is written to the file.  Since
 * all function codes are greater than 256, no function key is added to file.
 */

DISPATCH_TABLE key_func[MAX_KEYS] = {
   /* 256 */
    0,                          /* DO NOT assign this to any function */
    0,                          /* Alt + ESC  -  101 Keyboard */
    AbortCommand,               /* ESC    - manually map to 258 */
    0,                          /* Control + 2 */
   /* 260 */
    0,                          /* #ESC    - manually map to 260 */
    0,                          /* ^ESC    - mannuall map to 261 */
    Rturn,                      /*  Enter  - manually map to 262 */
    NextLine,                   /* #Enter  - manually map to 263 */
    BegNextLine,                /* ^Enter  - manually map to 264 */
    BackSpace,                  /*  BackSpace - manually map to 265 */
    BackSpace,                  /* #BackSpace - manually map to 266 */
    0,                          /* ^BackSpace - manually map to 267 */
    Tab,                        /*  Tab       - manually map to 268 */
    0,
   /* 270 */
    0,                          /* Alt + Backspace  - 101 keyboard */
    0,                          /* Shift + Tab    */
    0,                          /* Alt-Q  272 */
    BlockToFile,                /* Alt-W  273 */
    BlockExpandTabs,            /* Alt-E  274 */
    0,
    SetTabs,                    /* Alt-T  276 */
    UndoDelete,                 /* ALT-Y  277 */
    UnMarkBlock,                /* Alt-U  278 */
    ToggleIndent,               /* Alt-I  279 */
   /* 280 */
    OverlayBlock,               /* Alt-O  280 */
    PrintBlock,                 /* Alt-P  281 */
    0,                          /* Alt-[     - 101 keyboard */
    0,                          /* Alt-]     - 101 keyboard */
    0,                          /* Alt-Enter - 101 keyboard */
    0,
    AddLine,                    /* Alt-A  286 */
    SplitLine,                  /* Alt-S  287 */
    DeleteLine,                 /* Alt-D  288 */
    FillBlock,                  /* Alt-F  289 */
   /* 290 */
    DeleteBlock,                /* Alt-G  290 */
    Help,                       /* Alt-H  291 */
    JoinLine,                   /* Alt-J  292 */
    KopyBlock,                  /* Alt-K  293 */
    MarkLine,                   /* Alt-L  294 */
    0,                          /* Alt-;  - 101 keyboard */
    0,                          /* Alt-\  - 101 keyboard */
    0,                          /* Alt-~  - 101 keyboard */
    0,
    0,
   /* 300 */
    JumpToLine,                 /* Alt-Z  300 */
    0,
    CopyBlock,                  /* Alt-C  302 */
    0,
    MarkBlock,                  /* Alt-B  304 */
    0,
    MoveBlock,                  /* Alt-M  306 */
    0,                          /* Alt-<  - 101 keyboard */
    0,                          /* Alt->  - 101 keyboard */
    0,                          /* ALt-?  - 101 keyboard */
   /* 310 */
    0,  0,  0,  0,  0,
    Help,                       /* F1     315 */
    Save,                       /* F2     316 */
    Quit,                       /* F3     317 */
    File,                       /* F4     318 */
    RepeatFindForward,          /* F5     319 */
   /* 320 */
    RepeatFindBackward,         /* F6     320 */
    0,  0,
    SplitScreen,                /* F9     323 */
    NextWindow,                 /* F10    324 */
    0,  0,
    BegOfLine,                  /* Home   327 */
    LineUp,                     /* Up     328 */
    ScreenUp,                   /* PgUp   329 */
   /* 330 */
    0,
    CharLeft,                   /* Left   331 */
    CenterWindow,               /* Center 332 */
    CharRight,                  /* Right  333 */
    0,
    EndOfLine,                  /* End    335 */
    LineDown,                   /* Down   336 */
    ScreenDown,                 /* PgDn   337 */
    ToggleOverWrite,            /* Ins    338 */
    DeleteChar,                 /* Del    339 */
   /* 340 */
    0,
    SaveAs,                     /* Shift  F2 */
    0,
    EditFile,                   /* Shift F4  */
    FindForward,                /* Shift F5  */
    FindBackward,               /* Shift F6  */
    ReplaceForward,             /* Shift F7  */
    ReplaceBackward,            /* Shift F8  */
    SizeWindow,                 /* Shift F9  */
    PreviousWindow,             /* Shift F10 */
   /* 350 */
    0,  0,  0,  0,
    ToggleSearchCase,           /* Control F5 */
    0,  0,  0,
    ZoomWindow,                 /* Control F9 */
    NextHiddenWindow,           /* Control F10 */
   /* 360 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* Alt-F1 thru Alt-F10 */
   /* 370 */
    0,
    WordLeft,                   /* Control Left  371 */
    WordRight,                  /* Control Right 372 */
    BotOfScreen,                /* Control End   373 */
    EndOfFile,                  /* Control PgUp  374 */
    TopOfScreen,                /* Control Home  375 */
    0,                          /* Alt-! */
    0,                          /* Alt-@ */
    0,                          /* Alt-# */
    0,                          /* Alt-$ */
   /* 380 */
    0,                          /* Alt-% */
    0,                          /* Alt-^ */
    0,                          /* Alt-& */
    0,                          /* Alt-* */
    0,                          /* Alt-( */
    0,                          /* Alt-) */
    DelEndOfLine,               /* Alt '-'  386      */
    DuplicateLine,              /* Alt '='  387      */
    TopOfFile,                  /* Control Pgup  388 */
    0,                          /* F11          - 101 keyboard */
   /* 390 */
    0,                          /* F12          - 101 keyboard */
    0,                          /* Shift F11    - 101 keyboard */
    0,                          /* Shift F12    - 101 keyboard */
    0,                          /* Control F11  - 101 keyboard */
    0,                          /* Control F12  - 101 keyboard */
    0,                          /* Alt F11      - 101 keyboard */
    0,                          /* Alt F12      - 101 keyboard */
    ScrollUpLine,              /* Control Up */
    FixedScrollUp,             /* Control Grey - */
    CenterLine,                /* Control Center */
   /* 400 */               
    FixedScrollDn,             /* Control Grey + */
    ScrollDnLine,              /* Control Down  */
    0,                     
    ToggleSdel,                /* Control Del   */
    0,  0,  0,  0,         
    FixedScrollUp,             /* Alt + Grey Up */
    0,
   /* 410 */
    0,
    HorizontalScreenLeft,       /* Alt + Grey Left  */
    0,
    HorizontalScreenRight,      /* Alt + Grey Right */
    0,  0,
    FixedScrollDn,       /* Alt + Grey Down */
    0,  0,  0,
   /* 420 */
    0,  0,  0,
    ScrollUpLine,       /* Shift Grey - (Num Lock off) */
    ScrollDnLine,       /* Shift Grey + (Num Lock off) */
    Rturn,              /* Hard code Enter to 425 - DO NOT let users change */
    0,  0,  0,  0,      /* no keys are assigned here */

   /*
    * Add 430 to keycodes 0-31 if ALT key is not pressed.  This effectively
    * remaps the Control code sequence to 430-461.
    */

   /* 430 */
    0,
    WordLeft,           /* Control a */
    BackSpace,          /* Control b */
    ScreenDown,         /* Control c */
    CharRight,          /* Control d */
    LineUp,             /* Control e */
    WordRight,          /* Control f */
    DeleteChar,         /* Control g */
    BackSpace,          /* Control h */
    Tab,                /* Control i */
    Help,               /* Control j */
    0,                  /* Control k */
    0,                  /* Control l */
    Rturn,              /* Control m */
    AddLine,            /* Control n */
    0,                  /* Control o */
    0,                  /* Control p */
    0,                  /* Control q */
    ScreenUp,           /* Control r */
    CharLeft,           /* Control s */
    WordDelete,         /* Control t */
    UndoDelete,         /* Control u */
    ToggleOverWrite,    /* Control v */
    ScrollUpLine,       /* Control w */
    LineDown,           /* Control x */
    DeleteLine,         /* Control y */
    ScrollDnLine,       /* Control z */
    AbortCommand,       /* Control [ */
    RedrawScreen,       /* Control \ */
    ParenBalance,       /* Control ] */
   /* 460 */
    0,  0
};
