// BASE1.C -- Your Basic, boring Windows Program!

#define INMAIN       // Only define this for the file with WinMain in it!

#include "base1.h"

// Private function prototypes (this file scope only)

LONG WndProc_WM_COMMAND ( WINDOWS_PARAMS );
BOOL DlgProc_WM_COMMAND ( DIALOG_PARAMS  );

/**************************************************************
*                                                             *
*                      WinMain                                *
*                                                             *
**************************************************************/

int PASCAL WinMain (HANDLE hInstance,  HANDLE hPrevInstance, 
                    LPSTR lpszCmdLine, int    nCmdShow       )
{
  MSG         msg       ;
  WNDCLASS    wndclass  ;

  if (!hPrevInstance) 
    {

    // Register Parent Window Class

    wndclass.style         = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNCLIENT;
    wndclass.lpfnWndProc   = (WNDPROC)BASE1_WndProc ;
    wndclass.cbClsExtra    = 0 ;
    wndclass.cbWndExtra    = 0 ;
    wndclass.hInstance     = hInstance ;
    wndclass.hIcon         = LoadIcon ( hInstance, "BASE1");
    wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
    wndclass.hbrBackground = GetStockObject ( GRAY_BRUSH ) ;
    wndclass.lpszMenuName  = (LPSTR)"PlainMenu" ;
    wndclass.lpszClassName = szAppName ;

    if (!RegisterClass (&wndclass))
         return FALSE;
    }

  ghInst   = hInstance;

  ghWnd =        CreateWindow (szAppName, 
                               szCaption,
                               WS_OVERLAPPEDWINDOW,
                               CW_USEDEFAULT, 0,
                               CW_USEDEFAULT, 0,
                               (HWND)NULL, 
                               (HMENU)NULL, 
                               hInstance, 
                               (LPVOID)NULL) ;

  ShowWindow ( ghWnd, nCmdShow );
  UpdateWindow ( ghWnd );

  while (GetMessage((LPMSG)&msg, NULL, 0, 0))
    {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
    }
}

/*********************************************************************
*                                                                    *
*                  ModalDialog: Calls a Modal Dialog Box             *
*                                                                    *
*********************************************************************/

int BASE1_ModalDialog ( LPSTR TemplateName, FARPROC FunctionName, LONG dwParam )
{
  FARPROC  lpDialogProc;
  int      RetVal;

  lpDialogProc = MakeProcInstance ( FunctionName, ghInst );
  RetVal       = DialogBoxParam ( ghInst, TemplateName, ghWnd, 
                                  lpDialogProc, (DWORD)dwParam );
  FreeProcInstance ( lpDialogProc );
  return RetVal;
}

/*********************************************************************
*                                                                    *
*                       WndProc: Main Message Translator             *
*                                                                    *
*********************************************************************/

WINPROC BASE1_WndProc ( WINDOWS_PARAMS )
{
  switch ( msg )
    {
    case WM_DESTROY :

      PostQuitMessage (0) ;
      break ;

    case WM_COMMAND :

      return WndProc_WM_COMMAND ( hWnd, msg, wParam, lParam );
      break;

    default :

      return DefWindowProc ( hWnd, msg, wParam, lParam );

    }
  return 0L ;
}

/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/

LONG WndProc_WM_COMMAND ( WINDOWS_PARAMS )
{
  CRACKER_VARS
  CRACK_MESSAGEsc

  switch ( CRACKER_wID )
    {
    case IDM_MODAL :

       BASE1_ModalDialog ( "MODALDIALOG", BASE1_DlgProc, 0L );
       break;

    default:
 
       return DefWindowProc ( hWnd, msg, wParam, lParam ) ;
       break;
    }
}

/********************************************************************
*                                                                   *
*                  Vanilla Dialog Box Procedure                     *
*                                                                   *
********************************************************************/

DLGPROC BASE1_DlgProc ( DIALOG_PARAMS )
{
  switch (msg)
    {
    case WM_COMMAND:
      
      return DlgProc_WM_COMMAND ( hDlg, msg, wParam, lParam );

    default:

       return FALSE;
    }

  return TRUE;
}
/*********************************************************************
*                                                                    *
*                                                                    *
*                                                                    *
*********************************************************************/

BOOL DlgProc_WM_COMMAND ( DIALOG_PARAMS )
{
  CRACKER_VARS
  CRACK_MESSAGEsc

  switch ( CRACKER_wID )
    {
    case IDCANCEL:
    case IDOK:

       EndDialog ( hDlg, TRUE );          
       return TRUE;
     
    default:
       
       return FALSE;
    }
}
