/*******************************************************************

    wormproc.h

    This file contains the global procedure declarations for the
    Windows Sockets Wormhole project.

********************************************************************/


#ifndef _WORMPROC_H_
#define _WORMPROC_H_


//
//  Client-side child window functions.
//

LRESULT CALLBACK Client_WndProc( HWND   hwnd,
                                 UINT   nMessage,
                                 WPARAM wParam,
                                 LPARAM lParam );

HWND Client_CreateNew( LPCLIENT_DATA pClientData );


//
//  Dialog functions.
//

VOID AboutDialog( HWND hwndParent );

BOOL NewHostDialog( HWND      hwndParent,
                    LPSTR     pszHostName,
                    LPIN_ADDR paddr );


//
//  Frame window functions.
//

LRESULT CALLBACK Frame_WndProc( HWND   hwnd,
                                UINT   nMessage,
                                WPARAM wParam,
                                LPARAM lParam );


//
//  Initialization functions.
//

BOOL InitApplication( HINSTANCE hInstance );

BOOL InitInstance( HINSTANCE hInstance,
                   LPSTR     pszCmdLine,
                   INT       nCmdShow );


//
//  Server-side child window functions.
//

LRESULT CALLBACK Server_WndProc( HWND   hwnd,
                                 UINT   nMessage,
                                 WPARAM wParam,
                                 LPARAM lParam );

HWND Server_CreateNew( LPSERVER_DATA pServerData );


//
//  Utility functions.
//

INT MsgBox( HWND  hwndParent,
            UINT  fuType,
            LPSTR pszFormat,
            ... );

VOID WinPrintf( HDC   hdc,
                INT   row,
                INT   col,
                LPSTR pszFormat,
                ... );

LPSTR SockerrToString( SOCKERR serr );

SOCKERR ResetSocket( SOCKET sock );

SOCKERR CreateSocket( SOCKET FAR * psock,
                      INT          type,
                      ULONG        address,
                      PORT         port );


#endif  // _WORMPROC_H_

