/*******************************************************************

    wormcons.h

    This file contains the global constant definitions for the
    Windows Sockets Wormhole project.

********************************************************************/


#ifndef _WORMCONS_H_
#define _WORMCONS_H_


//
//  The well-known UDP port used by the server-side of the session.
//

#define WORMHOLE_COMMAND_PORT           789


//
//  Maximum length (in characters) of a host name.
//

#define MAX_HOST                        256


//
//  Buffer size used for file transfers.  This is kept intentionally
//  small to distribute the burden on the host systems.
//

#define BUFFER_SIZE                     2048


//
//  Packet types.
//

#define PACKET_TYPE_FILE                0x46494c45L     // "FILE"
#define PACKET_TYPE_PORT                0x504f5254L     // "PORT"
#define PACKET_TYPE_NACK                0x4e41434bL     // "NACK"


//
//  Get/SetWindowLong offsets.
//

#define GWL_CLIENT                      0               // Client-side data.
#define GWL_SERVER                      0               // Server-side data


//
//  Type fields for client/server window data structures.
//

#define WINDOW_TYPE_CLIENT              1
#define WINDOW_TYPE_SERVER              2


//
//  Various timeouts.  All values are in seconds.
//

#define TIMEOUT_SERVER                  60              // Waiting for connect.
#define TIMEOUT_CLIENT_INITIAL          5               // Waiting for response.
#define TIMEOUT_CLIENT_DELTA            5
#define TIMEOUT_CLIENT_MAX              15


//
//  Maximum printf-like output allowed by MsgBox.
//

#define MAX_PRINTF_OUTPUT               1024            // characters


//
//  Messages posted by the asynchronous socket APIs.
//

#define WM_SOCKET_SELECT                (WM_USER + 100)
#define WM_SOCKET_ASYNC                 (WM_USER + 101)

/* void Cls_OnSocketSelect(HWND hwnd, SOCKET sock, SOCKERR serr,
                           SOCKEVENT sevent) */
#define HANDLE_WM_SOCKET_SELECT(hwnd, wParam, lParam, fn) \
    ((fn)((hwnd), (SOCKET)(wParam), (SOCKERR)WSAGETSELECTERROR(lParam), \
    (SOCKEVENT)WSAGETSELECTEVENT(lParam)), 0L)
#define FORWARD_WM_SOCKET_SELECT(hwnd, socket, serr, sevent, fn) \
    (void)(fn)((hwnd), WM_SOCKET_SELECT, (WPARAM)(socket), \
    (LPARAM)WSAMAKESELECTREPLY(sevent, serr))

/* void Cls_OnSocketAsync(HWND hwnd, HANDLE hAsync, SOCKERR serr,
                          WORD cbBuffer) */
#define HANDLE_WM_SOCKET_ASYNC(hwnd, wParam, lParam, fn) \
    ((fn)((hwnd), (HANDLE)(wParam), (SOCKERR)WSAGETASYNCERROR(lParam), \
    (WORD)WSAGETASYNCBUFLEN(lParam)), 0L)
#define FORWARD_WM_GETXBYX(hwnd, hAsync, serr, cbBuffer, fn) \
    (void)(fn)((hwnd), WM_SOCKET_ASYNC, (WPARAM)(hAsync), \
    (LPARAM)WSAMAKEASYNCREPLY(cbBuffer, serr))


#ifdef WIN32

//
//  Fix the broken Win32 WM_CREATE message cracker.
//

#undef HANDLE_WM_CREATE
#define HANDLE_WM_CREATE(hwnd, wParam, lParam, fn) \
    ((fn)((hwnd), (LPCREATESTRUCT)(lParam)) ? 0L : (LRESULT)-1L)

#endif  // WIN32


//
//  Some useful constants missing from 16-bit Windows.
//

#ifndef WIN32
#define MAX_PATH                        260             // characters
#endif  // !WIN32


//
//  Make life with RC a little easier.
//

#ifdef RC_INVOKED
#define ID(x)           x
#else   // !RC_INVOKED
#define ID(x)           MAKEINTRESOURCE(x)
#endif  // RC_INVOKED


//
//  These are base resource values upon which the
//  various resource IDs are based.  All resources should
//  begin with one of the following prefixes:
//
//      IDI_    - Icons.
//      IDM_    - Menus.
//      IDD_    - Dialogs.
//      IDA_    - Accelerators.
//
//  Note the the resource compiler cannot do arithmetic on some
//  of these values.  It is up to the programmer to ensure they
//  don't conflict.
//

#define IDI_BASE                        1000
#define IDM_BASE                        2000
#define IDD_BASE                        3000
#define IDA_BASE                        4000


//
//  Icon resource IDs.
//

#define IDI_FRAME                       ID(1000)        // IDI_BASE + 0
#define IDI_CLIENT                      ID(1001)        // IDI_BASE + 1
#define IDI_SERVER                      ID(1002)        // IDI_BASE + 2


//
//  Menu resource IDs.
//

#define IDM_FRAME_BASE                  2000            // IDM_BASE + 0
#define IDM_FRAME                       ID(IDM_FRAME_BASE)
#define IDM_CONNECTION_BASE             (IDM_FRAME_BASE + 0)
#define IDM_CONNECTION_NEW              (IDM_CONNECTION_BASE + 0)
#define IDM_CONNECTION_EXIT             (IDM_CONNECTION_BASE + 3)

#define IDM_WINDOW_BASE                 (IDM_FRAME_BASE + 100)
#define IDM_WINDOW_CASCADE              (IDM_WINDOW_BASE + 0)
#define IDM_WINDOW_TILE_VERTICALLY      (IDM_WINDOW_BASE + 1)
#define IDM_WINDOW_TILE_HORIZONTALLY    (IDM_WINDOW_BASE + 2)
#define IDM_WINDOW_ARRANGE_ICONS        (IDM_WINDOW_BASE + 3)
#define IDM_WINDOW_FIRST_CHILD          (IDM_WINDOW_BASE + 4)

#define IDM_HELP_BASE                   (IDM_FRAME_BASE + 200)
#define IDM_HELP_ABOUT                  (IDM_HELP_BASE + 0)


//
//  Dialog resource IDs.
//

#define IDD_ABOUT                       ID(3000)        // IDD_BASE + 0

#define IDD_NEW                         ID(3100)        // IDD_BASE + 100
#define IDD_NEW_HOST                    3101
#define IDD_NEW_HOST_LABEL              3102


//
//  Accelerator table resource IDs.
//

#define IDA_FRAME                       ID(4000)        // IDA_BASE + 0


#endif  // _WORMCONS_H_

