/*******************************************************************

    init.c

    This file contains application & instance initialization routines.

********************************************************************/


#include "wormhole.h"


//
//  Public functions.
//

/*******************************************************************

    NAME:       InitApplication

    SYNOPSIS:   Performs application-wide initialization.

    ENTRY:      hInstance - The current instance handle.

    RETURNS:    BOOL - TRUE if everything initialized OK, FALSE
                    if something tragic happened.

********************************************************************/
BOOL InitApplication( HINSTANCE hInstance )
{
    WNDCLASS WndClass;

    //
    //  Save the instance handle.  We'll need it often.
    //

    hInst = hInstance;

    //
    //  Initialize some of the global strings.
    //

    pszAppName        = "Wormhole";
    pszFrameClass     = "WormholeFrameClass";
    pszMDIClientClass = "MDICLIENT";
    pszClientClass    = "WormholeClientClass";
    pszServerClass    = "WormholeServerClass";

    //
    //  Initialize & register the various window classes.
    //

    WndClass.style         = CS_HREDRAW | CS_VREDRAW;
    WndClass.lpfnWndProc   = (WNDPROC)Frame_WndProc;
    WndClass.cbClsExtra    = 0;
    WndClass.cbWndExtra    = 0;
    WndClass.hInstance     = hInstance;
    WndClass.hIcon         = LoadIcon( hInstance, IDI_FRAME );
    WndClass.hCursor       = LoadCursor( NULL, IDC_ARROW );
    WndClass.hbrBackground = GetStockObject( WHITE_BRUSH );
    WndClass.lpszMenuName  = IDM_FRAME;
    WndClass.lpszClassName = pszFrameClass;

    if( !RegisterClass( &WndClass ) )
    {
        return FALSE;
    }

    WndClass.lpfnWndProc   = (WNDPROC)Client_WndProc;
    WndClass.cbWndExtra    = sizeof(LPVOID);
    WndClass.hIcon         = LoadIcon( hInstance, IDI_CLIENT );
    WndClass.lpszMenuName  = NULL;
    WndClass.lpszClassName = pszClientClass;

    if( !RegisterClass( &WndClass ) )
    {
        return FALSE;
    }

    WndClass.lpfnWndProc   = (WNDPROC)Server_WndProc;
    WndClass.cbWndExtra    = sizeof(LPVOID);
    WndClass.hIcon         = LoadIcon( hInstance, IDI_SERVER );
    WndClass.lpszClassName = pszServerClass;

    if( !RegisterClass( &WndClass ) )
    {
        return FALSE;
    }

    //
    //  Success!
    //

    return TRUE;

}   // InitApplication


/*******************************************************************

    NAME:       InitInstance

    SYNOPSIS:   Performs instance-wide initialization.

    ENTRY:      hInstance - The current instance handle.

                pszCmdLine - Command line arguments.

                nCmdShow - ShowWindow parameter.

    RETURNS:    BOOL - TRUE if everything initialized OK, FALSE
                    if something tragic happened.

********************************************************************/
BOOL InitInstance( HINSTANCE hInstance,
                   LPSTR     pszCmdLine,
                   INT       nCmdShow )
{
    //
    //  Create the frame window.
    //

    hwndMDIFrame = CreateWindow( pszFrameClass,
                                 pszAppName,
                                 WS_OVERLAPPEDWINDOW,
                                 CW_USEDEFAULT, CW_USEDEFAULT,
                                 CW_USEDEFAULT, CW_USEDEFAULT,
                                 NULL,
                                 NULL,
                                 hInstance,
                                 NULL );

    if( hwndMDIFrame == NULL )
    {
        return FALSE;
    }

    //
    //  Load our accelerators.
    //

    hAccel = LoadAccelerators( hInst, IDA_FRAME );

    if( hAccel == NULL )
    {
        return FALSE;
    }

    //
    //  Display the main window.
    //

    ShowWindow( hwndMDIFrame, nCmdShow );
    UpdateWindow( hwndMDIFrame );

    //
    //  Success!
    //

    return TRUE;

}   // InitInstance

