/***************************************************************************
*   emstest.h                                                              *
*   HEADER FOR tester for EMSLIB                                           *
*   OS:      DOS                                                           *
*   VERSION: 1.0                                                           *
*   DATE:    09/23/91                                                      *
*                                                                          *
*   Copyright (c) 1991 James W. Birdsall. All Rights Reserved.             *
*                                                                          *
*   Compiles under Borland C++ 2.0 and MSC 6.00A.                          *
*                                                                          *
*   Header file for EMSTEST.                                               *
*                                                                          *
***************************************************************************/

#ifndef EMSLIB_H
    **** ERROR **** MUST INCLUDE EMSLIB.H BEFORE EMSTEST.H
#endif

#ifndef EMSTEST_H
#define EMSTEST_H

/*
** system includes <>
*/

/*
** custom includes ""
*/

/*
** local #defines
*/

/*
** define ASM to be the appropriate keyword for in-line assembly according
** to the compiler.
*/
#ifdef __TURBOC__
#define ASM              asm
#else
#define ASM              _asm
#endif

/* MSC does not have a MK_FP() macro. Define it if it doesn't exist. */
#ifndef MK_FP
#define MK_FP(seg,off)   (void far *)((((long)(seg)) << 16) | ((long)(off)))
#endif

/* at least 8 EMS pages must be free for all tests to be performed */
#define MINFREE          8L

/* header and trailer messages for each test */
#define TESTHEADER()     printf(">>>TEST #%d: %s\n", testno++, gblmsg)
#define TESTTAILER()     printf("Test passed.\n")

/*
** This macro is for return checking for functions which are expected
** to succeed. It makes function calls to check if
**      1) the function returned EMMOOPS
**      2) the function returned a value that isn't EMMOOPS or 0
**      3) the function set _EMMerror to an unexpected value
** The parameters are:
**      fu  - char *, name of the function
**      st  - status value returned by the function
**      ex  - expected value of _EMMerror
**      fr1 - conventional memory pointer to be freed on emergency exit
**      fr2 - EMS handle to be freed on emergency exit
**      fr3 - another EMS handle to be freed on emergency exit
*/
#define TRIPLECHECK(fu, st, ex, fr1, fr2, fr3) \
                         failcheck((fu), (st), (fr1), (fr2), (fr3)); \
                         weirdretchk((fu), (st), (fr1), (fr2), (fr3)); \
                         weirdcodechk((fu), (ex), (fr1), (fr2), (fr3))

/*
** Define FMEMCMP and FMEMSET according to whether library functions
** are present or not.
*/
#ifndef NO_FFUNC

#define FMEMCMP          _fmemcmp
#define FMEMSET          _fmemset

#else

#define FMEMCMP          Fmemcmp
#define FMEMSET          Fmemset

#endif


/*
** misc: copyright strings, version macros, etc.
*/

/*
** typedefs
*/

/*
** global variables
*/

/*
** static globals
*/

/*
** function prototypes
*/

extern void do_alloc_tests(unsigned long bytes);
extern void do_palloc_tests(int pages);
extern void do_frame_tests(void);
extern void do_name_tests(void);
extern void do_map_tests(void);
extern void do_sr_tests(void);
extern void do_shortcopy_tests(void);
extern void do_longcopy_tests(void);

extern unsigned long test_EMMcoreleft(void);
extern int test_EMMalloc(unsigned long bytes);
extern int test_EMMallocpages(int pages);
extern void test_EMMfree(int handle);
extern void test_EMMmappage(int frameno, int handle, int logpage);

extern void weirdretchk(char *function, int status, void *tofree1, int tofree2,
                                                                  int tofree3);
extern void weirdcodechk(char *function, int expected, void *tofree1,
                                                     int tofree2, int tofree3);
extern void failcheck(char *function, int status, void *tofree1, int tofree2,
                                                                  int tofree3);
extern void nofailcheck(char *function, int status, void *tofree1, int tofree2,
                                                                  int tofree3);

extern int farmemcheck(unsigned char far *buffer, unsigned int len,
                                                      unsigned char checkchar);
extern void farincwordfill(unsigned char far *buffer, unsigned int len);
extern int farincwordcheck(unsigned char far *buffer, unsigned int len);
extern void farinclongfill(unsigned char far *buffer, unsigned long len,
                                                          unsigned long start);
extern int farinclongcheck(unsigned char far *buffer, unsigned long len,
                                                          unsigned long start);
extern unsigned long get_tick(void);

#ifdef NO_FFUNC

extern int Fmemcmp(void far *buf1, void far *buf2, unsigned int n);
extern void Fmemset(void far *s, int c, unsigned int n);

#endif

#endif

