/***************************************************************************
*   EMSLIB.H                                                               *
*   HEADER FOR EMSLIB                                                      *
*   OS:        DOS                                                         *
*   VERSION:   2.21                                                        *
*   DATE:      10/10/91                                                    *
*                                                                          *
*   Copyright (c) 1991 James W. Birdsall. All Rights Reserved.             *
*                                                                          *
***************************************************************************/

#ifndef EMSLIB_H
#define EMSLIB_H

/*
** system includes <>
*/

/*
** custom includes ""
*/

/*
** local #defines
*/

/* fake an invalidate function */
#define _EMMinval()         if (_EMMframecache != 0) _EMMenc(); else _EMMdisc()

/*
** EMMicopyfrom() and EMMicopyto() used to be functions, these
** macros provided for compatibility.
*/
#define EMMicopyfrom(n,e,b,h,f,d)  _EMMicopyfrom((n),(e),(b),(h),(f),(d),(b))
#define EMMicopyto(n,e,b,s,h,f)    _EMMicopyto((n),(e),(b),(s),(h),(f),(b))

/* error returns */
#define EMMOOPS       -1
#define NOEMM         -2


/* EMM library errors */

#define EMM_BADVERS         0x40
#define EMM_BADOFFSET       0x41
#define EMM_NOFRAME         0x42
#define EMM_NOINIT          0x43
#define EMM_FEWFRAMES       0x44
#define EMM_NOSR            0x45
#define EMM_MEMNULL         0x46
#define EMM_ELTOOBIG        0x47
#define EMM_SKTOOBIG        0x48

/* EMM driver errors */

#define EMM_SOFTERROR       0x80
#define EMM_HARDERROR       0x81
#define EMM_BUSY            0x82
#define EMM_BADHANDLE       0x83
#define EMM_UNIMP           0x84
#define EMM_NOFREEHAN       0x85
#define EMM_CONTEXTERR      0x86
#define EMM_WAYTOOBIG       0x87
#define EMM_TOOBIG          0x88
#define EMM_TOOSMALL        0x89
#define EMM_BADLOGPAGE      0x8A
#define EMM_BADFRAMENO      0x8B
#define EMM_HSTATESAVFULL   0x8C
#define EMM_MSTATESAVFULL   0x8D
#define EMM_MSTATERESTERR   0x8E
#define EMM_UNIMPSUB        0x8F
#define EMM_BADATTRIB       0x90
#define EMM_NOFEATURE       0x91
#define EMM_SRCOVERWRITE    0x92
#define EMM_BADLENGTH       0x93
#define EMM_CONEMSOVERLAP   0x94
#define EMM_OFFPAGE         0x95
#define EMM_TOOLONG         0x96
#define EMM_EMSEMSOVERLAP   0x97
#define EMM_LOST            0x98
#define EMM_UNUSED          0x99
#define EMM_BADALTREG       0x9A
#define EMM_NOFREEALTREG    0x9B
#define EMM_NOALTREG        0x9C
#define EMM_BADALTREG2      0x9D
#define EMM_NODEDDMA        0x9E
#define EMM_BADDEDDMA       0x9F
#define EMM_UNKNAME         0xA0
#define EMM_NAMETAKEN       0xA1
#define EMM_ADDRWRAP        0xA2
#define EMM_BADPTR          0xA3
#define EMM_FORBIDDENFUNC   0xA4


/*
** misc: copyright strings, version macros, etc.
*/

/*
** typedefs
*/

typedef struct a {             /* return type from EMMgetframeaddr() */
   unsigned int segaddr;
   unsigned int frameno;
   } frameinfo;


/*
** global variables
*/

extern unsigned char const _EMMerror;       /* EMS error variable */
extern unsigned char const _EMMversion;     /* EMS version, BCD */
extern unsigned char const _EMMframecache;  /* caching flag for copy funcs */

extern char const emslib_vers_vers[];
extern char const emslib_vers_date[];
extern char const emslib_vers_time[];


/*
** function prototypes
*/

extern int EMMlibinit(void);
extern int EMMgetversion(void);

extern unsigned long EMMcoreleft(void);
extern int EMMalloc(unsigned long bytes);
extern int EMMfree(int handle);

extern int EMMgetnumframe(void);
extern unsigned int EMMgetsinfraddr(int frame);
extern int EMMgetframeaddr(frameinfo *buffer);
extern int EMMmappage(int frameno, int handle, int logpage);
extern int EMMallocpages(int pages);

extern int EMMcopyto(unsigned long copylen, unsigned char far *source,
                                            int handle, unsigned long foffset);
extern int EMMcopyfrom(unsigned long copylen, int handle,
                               unsigned long foffset, unsigned char far *dest);
extern int _EMMicopyto(unsigned long nelem, int elsize,
                   unsigned int srcskip, unsigned char far *source,
                   int handle, unsigned long foffset, unsigned int destskip);
extern int _EMMicopyfrom(unsigned long nelem, int elsize,
                   unsigned int srcskip, int handle, unsigned long foffset,
                   unsigned char far *dest, unsigned int destskip);

extern int EMMsrinit(void *(*mallocfunc)(size_t));
extern void *EMMsave(void);
extern int EMMrestore(void *saveblock);

extern int EMMsetname(int handle, char *name);
extern int EMMgetname(int handle, char *name);

extern void _EMMenc(void);
extern void _EMMdisc(void);

#endif

