/*++
/* NAME
/*	window 5
/* SUMMARY
/*	window manager definitions
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	mailsh
/* SYNOPSIS
/*	#include "window.h"
/* DESCRIPTION
/*	The macros and variables defined here are used for window
/*	manipulation.
/* .nf

/* /* window selection macros */

#define	TOP	0		/* top window */
#define	MID	1		/* middle window */
#define	BOT	2		/* bottom window */

extern int wsize[BOT+1];	/* nbr of lines in windows */
extern int CO,LI;		/* size of whole screen */

/* /* function-key codes */

extern char *KU,*KD,*KL,*KR,*PU,*PD;

/* /* codes to turn on/off keypad, if you have one */

extern char *KS,*KE;

/* /* functions that write to windows */

extern void wininit();		/* init the window manager */
extern int printcl();		/* erase line, then print */
extern int printat();		/* print line */
extern int putw();		/* print character on window */
extern int printw();		/* formatted print on window */
extern void clrtoeol();		/* erase to end of line */
extern void clrtobot();		/* clear to screen bottom */
extern void beep();		/* ring the bell */
#ifdef unix
extern int fputchar();		/* put a character on stdout */
#endif
/* SEE ALSO
/*	window(3)	window manager
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Apr  1 21:14:53 GMT+1:00 1987
/* LAST MODIFICATION
/*	Mon Apr  4 23:51:44 MET 1988
/* VERSION/RELEASE
/*	1.3
/*--*/
