/*++
/* NAME
/*	tgetflag 3
/* SUMMARY
/*	check for existence of capability
/* PROJECT
/*	ms-dos/unix compatibility
/* PACKAGE
/*	termcap
/* SYNOPSIS
/*	tgetflag(name)
/*	char *name;
/* DESCRIPTION
/*	tgetflag is a predicate function that evaluates to "true" when
/*	the capablity in "name" is present in the terminal info extracted 
/*	earlier with tgetent(3).
/* SEE ALSO
/*	tgetent(3), extracts terminal info from database.
/*	termcap(3), Berkeley extensions to UNIX.
/* FILES
/*	ANSI.SYS, ibm pc console driver.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Jan  1 19:01:13 GMT+1:00 1986
/* LAST MODIFICATION
/*	Wed Jan  1 19:01:13 GMT+1:00 1986
/* VERSION/RELEASE
/*	1.0
/*--*/

#include "termcap.h"

tgetflag(id)
register char *id;
{
    register Cap *p;

    for (p = _console; *p->name; p++) 
        if (strcmp(id,p->name) == 0)
            return 1;
    return 0;
}
