/*++
/* NAME
/*      scanwork 3
/* SUMMARY
/*      search spool directory for outbound messages
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      cico
/* SYNOPSIS
/*	#include "work.h"
/*
/*      work *scanwork()
/* DESCRIPTION
/*      scanwork() searches the spool directory for files to be sent to 
/*	the remote system. If a file is found, scanwork() attempts to 
/*	open that file. A null pointer is returned if no work was found.
/*
/*	The result is normally used by sendwork().
/* FUNCTIONS AND MACROS
/*      scandir(), newseqno(), fspool()
/* SEE ALSO
/*      sendwork()      send spool file to remote host
/*      getwork()       receive remote spool file
/*      rmtname()       spool-file to remote-file name mapping
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Sat Mar 28 17:28:09 GMT+1:00 1987
/* LAST MODIFICATION
/*	Wed Apr  6 00:22:10 MET 1988
/* VERSION/RELEASE
/*	1.4
/*--*/

#include <ctype.h>
#include "defs.h"
#include "params.h"
#include "comm.h"
#include "work.h"
#include "path.h"
#include "dir.h"
#include "logs.h"

/*
* The present implementation assumes that work for the remote system 
* is in the form of pairs of spool files with names D<seqno> and X<seqno>. 
* The D files contain an electronic mail message, and the X files
* contain the destination. Both have the same <seqno> suffix which
* is just a five-digit sequence number.
* The task of scanwork() thus is trivial: just locate a file of which the
* name begins with a D or X and do some file name parsing.
* The major work is done by rmtname() and sendwork(): depending on the 
* type of file, generate an appropriate remote file name and send the 
* appropriate messages to the remote system.
*/

/* scanwork - search spool directory for work */

public work *scanwork()
{
    register int dd;
    register char *p;
    static work wrk;

    dd = opendir(maildir);
    while (p = readdir(dd)) {
	debug(5)("scanwork: file %s\n",p);
	if (index("dxDX",*p)) {
	    wrk.type = (islower(*p) ? toupper(*p) : *p);
	    wrk.tail = p+1;
	    sprintf(wrk.rqst,"S %c%s %s %s - %c%s 0660",
		wrk.type,wrk.tail,rmtname(wrk.type,wrk.tail),
	    "uucp",wrk.type,wrk.tail);
	    strcpy(wrk.path,fspool(p));
	    wrk.fp = fopen(wrk.path,"r");
	    break;
	}
    }
    closedir(dd);
    return(p ? &wrk : NULL);
}
