/*++
/* NAME
/*      protomsg 3
/* SUMMARY
/*      high-level protocol message exchange 
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      cico
/* SYNOPSIS
/*      int isok(str)
/*      char *str;
/*
/*      char *talk(str)
/*      char *str;
/*
/*      char *hear()
/* DESCRIPTION
/*      All routines in this module exchange messages via the line
/*	protocol agreed upon during communications startup.
/*
/*      All messages are sent including a null-byte terminator.
/*
/*      isok() send a request to the remote system and 
/*      returns YES or NO according to the Y or N response.
/*
/*      talk() send a message to the remote system and returns a 
/*	pointer to that message.
/*
/*      hear() reads the next message from the remote system and 
/*      returns a pointer to the result.
/* FUNCTIONS AND MACROS
/*      trap(), debug()
/* DIAGNOSTICS
/*      isok() and hear() return via longjmp(systrap,E_LOST) in case
/*	of timeout or protocol errors.
/* BUGS
/*      Message storage is in static buffers whose contents are overwritten
/*      with each call.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Thu Mar 26 16:14:57 GMT+1:00 1987
/* LAST MODIFICATION
/*	Wed Apr  6 00:21:41 MET 1988
/* VERSION/RELEASE
/*	1.4
/*--*/

#include "defs.h"
#include "params.h"
#include "comm.h"
#include "logs.h"
#include "status.h"

/* isok - send message and get yes/no response */

public int isok(msg)
char *msg;
{
    register char *s = talk(msg);
    register char *r = hear();

    if (s[0] == r[0]) {
	if (r[1] == 'Y')
	    return(YES);
	if (r[1] == 'N')
	    return(NO);
    }
    trap(E_LOST,"PROTOCOL ERROR (expected %cY or %cN, got %s)",s[0],s[0],r);
    /* NOTREACHED */
}

/* talk - send message to other side */

public char *talk(str)
char *str;
{
    debug(4)("sent \"%s\"\n",str);
    if (CALL(Write)(ttfd,str,strlen(str)+1) == -1)
	trap(E_LOST,"FAILED (link lost)");
    return(str);
}

/* listen - get message from other side */

public char *hear()
{
    register int nread;

    if ((nread = CALL(Read)(ttfd,msgin,MSGBUF)) < 0)
	trap(E_LOST,"FAILED (link lost)");
    msgin[nread] = '\0';
    debug(4)("got \"%s\"\n",msgin);
    return(msgin);
}
