/*++
/* NAME
/*	path
/* SUMMARY
/*	system-dependent file name definitions
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	general
/* SYNOPSIS
/*	#include "path.h"
/* DESCRIPTION
/*	File-system dependent definitions should be changed here.
/* .nf

/* /* the minmal number of open files we think we need */

#define	MINFILES	10

/* /*	system-dependent defaults */

#ifdef	unix
#define	THISDIR		"."		/* current directory */
#define	DEFSPOOL	"./spool"	/* default spool directory */
#define	DEFEDIT		"vi"		/* default editor */
#ifdef SIII
#define	DEFPRINT	"lp"		/* printer spooler */
#else
#define	DEFPRINT	"lpr"		/* printer spooler */
#endif
#define	MAILFILE	"mail.msg"	/* temporary message file */
#define	TMPALIAS	"tmp.alias"	/* temp alias file */
#define	NULLDEV		"/dev/null"	/* bit dump */
#endif

#ifdef	MSDOS
#define	THISDIR		"."		/* current directory */
#define	DEFSPOOL	"\\spool"	/* spool directory */
#define	DEFEDIT		"edlin"		/* default editor */
#define DEFPRINT	"PRN"		/* default printer */
#define	MAILFILE	"mail.msg"	/* temp message file */
#define	TMPALIAS	"alias.tmp"	/* temp alias file */
#define	NULLDEV		"NUL"		/* bit dump */
#endif

/* /* system-dependent function calls for file & printer access */

#ifdef unix
#define	propen()	popen(mailprn,"w")	/* open printe stream */
#define	prclose(p)	pclose(p)		/* close print stream */
#define	fspool(file)	strcons("%s/%s",maildir,file)
#endif

#ifdef MSDOS
#define	propen()	fopen(mailprn,"a")	/* open print stream */
#define	prclose(p)	(putc('\014',p),fclose(p)) /* close print stream */
#define	fspool(file)	strcons("%s\\%s",maildir,file)
#endif

/* /* system-independent file names */

#define	SMAIL	"smail"			/* queues a mail message */
#define	CICO	"cico"			/* file transfer program */
#define	RMAIL	"rmail"			/* extract originator address */

/* /*
* The spool directory is used for storage of all files manipulated
* by the mail programs. Message files should always have a meta file
* with information about the destination or origin of a message file.
*
* Message/meta file names are of the form <letter><sequence number>.
* Corresponding message/meta files have the same sequene number.
* The following definitions are for the <letter> part of spool files.
*/

#define	LOGFILE	"LOGFILE"		/* transaction logs */

#define	NEWPFX	"n"			/* received message */
#define	HDRPFX	"h"			/* originator of new mail */
#define	OLDPFX	"o"			/* originator of old mail */

#define	MSGPFX	"d"			/* message ready to be sent */
#define	XQTPFX	"x"			/* its destination */

#define	EDTPFX	"e"			/* message being worked on */
#define	COMPFX	"c"			/* its description */

#define	SETPFX	"s"			/* system parameter file */

#define	ALIPFX	"a"			/* alias data base */

#define	SPLFMT	"%s%05d"		/* spool-file name format */

/* /* 
* The following macros provide convenient access of spool files, so we
* don't have to remember the spool file name format and prefix stuff.
*/

#define	sendmail(file,to)	spoolfil(file,to,MSGPFX,XQTPFX)
#define	workon(fname,meta)	spoolfil(fname,meta,EDTPFX,COMPFX)

#define	parm_file()		fspool(strcons(SPLFMT,SETPFX,0))
#define	aliases()		fspool(strcons(SPLFMT,ALIPFX,0))
#define logfile()		fspool(LOGFILE)

#define meta_file(type,id)	fspool(strcons(SPLFMT,type,id))
#define mesg_file(type,id)	fspool(strcons(SPLFMT,type,id))

#define	work_meta(id)		fspool(strcons(SPLFMT,COMPFX,id))
#define	work_mesg(id)		fspool(strcons(SPLFMT,EDTPFX,id))

#define	in_mesg(id)		fspool(strcons(SPLFMT,NEWPFX,id))
#define	in_meta(id)		fspool(strcons(SPLFMT,OLDPFX,id))

#define	new_mesg(id)		fspool(strcons(SPLFMT,NEWPFX,id))
#define	new_meta(id)		fspool(strcons(SPLFMT,HDRPFX,id))

#define	out_mesg(id)		fspool(strcons(SPLFMT,MSGPFX,id))
#define out_meta(id)		fspool(strcons(SPLFMT,XQTPFX,id))

/* /* stuff taken from the environment */

extern char *editor;		/* path to editor */
extern char *maildir;		/* spool directory */
extern char *mailprn;		/* how to print */
extern char *mailcmd;		/* do this on exit */

extern int pathinit();		/* get path info from environment */
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Apr  5 13:23:45 GMT+1:00 1987
/* LAST MODIFICATION
/*	Wed Apr  6 00:21:29 MET 1988
/* VERSION/RELEASE
/*	1.4
/*--*/
