/*++
/* NAME
/*	params 3
/* SUMMARY
/*	communication parameter access
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	library
/* SYNOPSIS
/*	#include "params.h"
/*
/*	Info *getparams();
/* DESCRIPTION
/*	getparams() returns a pointer to a table with communications
/*	parameters. Usually communications parameters are set with the
/*	"setup" option in the main menu of the interactive mail program.
/*
/*	First getparams() attempts to read from the setup file.
/*	If that fails it creates an empty parameter table with
/*	null string pointers as parameter values.
/* FUNCTIONS AND MACROS
/*	myalloc()
/* BUGS
/*	getparams() silently ignores any information in the
/*	parameter file that it does not recognize.
/*	getparams() will read the parameter file upon each call, even
/*	if nothing has changed since the last read. Let us say that
/*	it anticipates on multi-user environments.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Apr  8 15:39:23 GMT+1:00 1987
/* LAST MODIFICATION
/*	Mon Apr  4 23:46:51 MET 1988
/* VERSION/RELEASE
/*	1.3
/*--*/

#include <ctype.h>
#include "defs.h"
#include "path.h"
#include "params.h"

/* Storage area for setup parameters */

hidden Info params[] = {
    /* name */	/* name length */	/* string value */
    PORT,	sizeof(PORT)-1,		0,
    BAUD,	sizeof(BAUD)-1,		0,
    HOST,	sizeof(HOST)-1,		0,
    LOGIN,	sizeof(LOGIN)-1,	0,
    DIAL,	sizeof(DIAL)-1,		0,
    DISC,	sizeof(DISC)-1,		0,
    0,		0,			0,
};

hidden char *hackstr();				/* forward declaration */

/* getparams - try to get info from file, else make empty table */

public Info *getparams()
{
    char line[BUFSIZ];
    register Info *ip;
    FILE *fp;

    /* for cleanliness, we first clear all table entries */

    for (ip = params; ip->ident; ip++) {
	if (ip->strval)
	    free(ip->strval);
	ip->strval = NULL;
    }

    /* then, try to copy parameter file info to the table */

    if (fp = fopen(parm_file(),"r")) {
	while (fgets(line,BUFSIZ,fp)) {
	    for(ip = params; ip->ident; ip++) {
		if (strncmp(ip->ident,line,ip->length) == 0) {
		    ip->strval = hackstr(line+ip->length);
		    break;
		}
	    }
	}
	fclose(fp);
    }
    return(params);
}

/* hackstr - cut away blanks around string and make copy */

hidden char *hackstr(s)
register char *s;
{
    register char *r;
    int len;

    while (*s && isspace(*s))				/* trim leading blks */
	s++;
    for (r = s+strlen(s); r > s && isspace(r[-1]); r--)	/* trim trailing blks */
	/* void */ ;

    /*
    * s is at the terminator or first non-blank char.
    * r is at the terminator or first blank after the last non-blank char.
    * Thus, the actual string length is r-s. We add one for the terminator.
    * We don't allocate memory if the string is empty.
    */

    if (len = r-s) {
	char *cp = strncpy(myalloc(len+1),s,len);
	cp[len] = '\0';
	return(cp);
    } else {
	return(NULL);
    }
}
