/*++
/* NAME
/*	pager	5
/* SUMMARY
/*	pager for display files, definitions
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	mailsh
/* SYNOPSIS
/*	#include "pager.h"
/* DESCRIPTION
/*	The display pager manipulates various lists of line structures.
/*	Each line is linked to its predecessor and to its successor.
/*
/*	Besides the familiar list ops for insert/delete the pager also 
/*	provides "read" and "write" operations on lines, and a 
/*	sort utility.
/* .nf

/* /* externally visible parts of the pager */

#define	FORW_SORT	1	/* sort in ascending order */
#define	BACK_SORT	2	/* sort in reverse order */

#define	PG_NOEND	1	/* suppress '-- end of display --' */

typedef struct File {
    struct Line *head;		/* ptr to first line in file */
    struct Line *last;		/* ditto to the last line */
    struct Line *top;		/* first one visible on screen */
    struct Line *curr;		/* where the cursor sits */
    int opts;			/* option flags */
} File;

typedef struct Line {
    struct Line *prev;		/* link to predecessor */
    struct Line *next;		/* link to successor */
    short lineno;		/* where it is on the screen */
    short llen;			/* nbr of lines on the screen */
    char line[1];		/* actually, a lot of characters */
} Line;

extern File *open_pager();	/* create a new display file */
extern void close_pager();	/* destroys an display file */
extern int scan_pager();	/* reads from current line */
extern void appd_pager();	/* appends after current line */
extern void del_pager();	/* delete current line */
extern void ins_pager();	/* inserts before current line */
extern void sort_pager();	/* sorts a file */
extern void set_pager();	/* select display file */
extern char *gets_pager();	/* returns current line */
extern void puts_pager();	/* replaces current line */

extern int cp_pager();		/* copy display file to disk */
extern int pr_pager();		/* copy display file to printer */
extern int rd_pager();		/* permanent file to display file */
extern int ds_pager();		/* current page of current file */
extern int up_pager();		/* handle cursor up request */
extern int dn_pager();		/* handle cursor down request */
extern int pu_pager();		/* handle page up request */
extern int pd_pager();		/* handle page down request */
extern void mesg_pager();	/* copy message array to display file */
/* SEE ALSO
/*	path(3), window(3), window(5)
/* BUGS
/*	It looks a lot like an editor, but it isn't.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Fri Apr  3 22:06:00 GMT+1:00 1987
/* LAST MODIFICATION
/*	Mon Apr  4 23:46:39 MET 1988
/* VERSION/RELEASE
/*	1.3
/*--*/
