/*++
/* NAME
/*      mbox 3
/* SUMMARY
/*      display incoming/outgoing mail messages
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      mailsh
/* SYNOPSIS
/*	#include "pager.h"
/*	#include "mbox.h"
/*
/*      int mbox(type,msgid)
/*	char *type;
/*	int msgid;
/* DESCRIPTION
/*      mbox() is invoked when the user has selected an incoming or
/*	outgoing mail message (not a message in preparation)
/*	from the main mail box menu. It instructs the pager to display 
/*	the selected mail message. The message type parameter is 
/*	a string with the type of message
/*	(see screen.h), msgid is the numerical message id. If the file is
/*	read for the first time (type == "New"), it will be marked as read.
/*
/*      The user has the usual options for manipulating the message
/*	being displayed.
/* FILES
/*      mail header files in the spool directory
/* SEE ALSO
/*      pager(3), pager(5), kbdinp(3)
/* DIAGNOSTICS
/*      If a selected mail message could not be found an error message
/*      is displayed instead.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Sun Apr  5 13:01:12 GMT+1:00 1987
/* LAST MODIFICATION
/*	Mon Apr  4 23:45:14 MET 1988
/* VERSION/RELEASE
/*	1.3
/*--*/

#include "defs.h"
#include "path.h"
#include "pager.h"
#include "screen.h"
#include "mailsh.h"

hidden File *letter = 0;			/* pager file */

/* show_letter - display selected mail message */

hidden int show_letter()
{
    set_pager(letter);				/* select message display */
    ds_pager();					/* put it on the screen */
    return(0);					/* say screen is ok */
}

/* mbox - user has selected a non-work mail message file */

public int mbox(type,id)
char *type;
int id;
{
    static Screen screen[] = {
	'C',	"Close",        0,      initscreen,
	'D',	"Delete",       delete,	delcurr,
	'M',	"Mail",		mailfile,"Mail a copy of this message",
	'P',	"Print",        print,	printcurr,
	'S',	"Save",         save,	"Save this message to ordinary file",
	'W',	"Work",		makework,"Save this message to work file",
	PGUP,	PgUp,		pu_pager,pageup,
	PGDN,	PgDn,		pd_pager,pagedn,
	UP,	"Up",           up_pager,csrup,
	DOWN,	"Down",         dn_pager,csrdn,
	0,	0,              show_letter,"(Reading a mail message)",
    };
    register char *seen;

    if (rd_pager(letter = open_pager(),message)) {
	mesg_pager(letter,m_msgread);		/* no file or read error */
    } else if (strcmp(type,"New")) {		/* !!ANONYMOUS CONSTANT!! */
	/* void */ ;				/* not a new message */
    } else if (rename(comment,seen = in_meta(id)) == 0) {
	strcpy(comment,seen);			/* mark message as read */
	junk_desk();				/* say desk-top outdated */
    }
    kbdinp(screen);				/* look at the screen */
    close_pager(letter),letter = 0;		/* destroy the display */
    return(S_REDRAW);				/* force screen redrawing */
}
