/*++
/* NAME
/*	cmail 1
/* SUMMARY
/*	report if there are unread messages
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	cmail
/* SYNOPSIS
/*	cmail [-p password]
/* DESCRIPTION
/*	cmail reports if there are unread mail messages in the
/*	pc-mail spool directory.
/*	
/*	If the -p option is present, cmail first invokes the cico
/*	program to contact the mail server host.
/*
/*	Typically cmail is run immediately after system startup,
/*	while you are getting your first cup of coffee.
/*
/*	The program returns a nonzero exit status if it could not 
/*	find any mail.
/* COMMANDS
/*	cico	file transfer program
/*	rmail	processes new mail
/* FILES
/*	Various files in the spool directory
/*
/*	LOGFILE system status messages
/*	n<seqno> mail messages
/*	h<seqno> header line of new mail
/*	o<seqno> header line of old mail
/* DIAGNOSTICS
/*	Error messages in case the environment is not properly set up.
/* BUGS
/*	Invites people to put their mail password into the autoexec file.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Sun Apr  3 19:34:57 MET 1988
/* LAST MODIFICATION
/*	Wed Apr  6 00:18:45 MET 1988
/* VERSION/RELEASE
/*	1.3
/*--*/

#include <signal.h>

#include "defs.h"
#include "dir.h"
#include "path.h"
#include "status.h"

hidden void parse_args();		/* forward declarations */
hidden void usage();
hidden void error();
hidden int newmail();

hidden char *password = 0;		/* set by the -p option */

main(argc,argv)
int argc;
char **argv;
{
    signal(SIGINT,SIG_IGN);		/* disable ctrl-c */
    parse_args(argc,argv);		/* parse command args */
    if (pathinit())			/* check path info */
	error("cmail: bad MAILDIR environment variable");
    if (password && *password && 
	invokelp(CICO,"-p",password,(char *)0) == E_NOPROG)
	error("cmail: cannot execute the CICO program");
    if (invokelp(RMAIL,(char *)0) == E_NOPROG)
	error("cmail: cannot execute the RMAIL program");
    exit(newmail() == 0);				/* look for new mail */
}

/* parse_args - process command-line arguments */

hidden void parse_args(argc,argv)
int argc;
char **argv;
{
    while (--argc && *++argv && **argv == '-') {	/* process options */
	switch (*++*argv) {
	case 'p':					/* call cico first */
	    if (--argc == 0)
		usage("missing password");
	    password = *++argv;
	    break;
	default:					/* unknown option */
	    usage(strcons("invalid option: -%s",*argv));
	    break;
	}
    }

    /* check for extraneous arguments */

    if (argc > 0)
	usage(strcons("unexpected argument: %s",*argv));
}

/* scan for new unread mail */

hidden int newmail()
{
    register int dd;
    int pfxlen = sizeof(HDRPFX)-1;
    char *f;
    FILE *fp;
    char from[BUFSIZ];
    register int msgcount = 0;

    /*
    * Scan the spool directory for unread messages and extract
    * the originator address from the corresponding meta file.
    */

    for (dd = opendir(maildir); f = readdir(dd); /* void */) {
	int seqno;
	if (strncmp(f,HDRPFX,pfxlen) == 0 && sscanf(f+pfxlen,"%d",&seqno)) {
	    if (fp = fopen(new_meta(seqno),"r")) {
		fgets(from,BUFSIZ,fp);
		printf("You have new mail from %s",from);
		msgcount++;
		fclose(fp);
	    }
	}
    }
    closedir(dd);
    return(msgcount);
}

hidden void error(str)
char *str;
{
    fprintf(stderr,"%s\n",str);
    exit(1);
}

hidden void usage(str)
char *str;
{
    fprintf(stderr,"%s\nusage: cmail [-p password]\n",str);
    exit(1);
}
