/*++
/* NAME
/*	alias
/* SUMMARY
/*	manipulate alias data base
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	mailsh
/* SYNOPSIS
/*	#include "alias.h"
/*
/*	int alias()
/* DESCRIPTION
/*	The alias data base is a text file. Each line is of the form
/*
/*		alias	replacement
/*
/*	where a replacement may consist of several words, which may
/*	be aliases themselves. Comma, blank and tab are separators.
/*	Leading or trailing blanks are ignored. If an alias is defined
/*	more than once, only the last definition will be effective.
/*
/*	alias() is invoked from the main menu and displays the contents
/*	of the alias data base. An editor is invoked if the user wants
/*	to make changes.
/* COMMANDS
/*	the program specified in the EDITOR environment variable,
/*	or a system-dependent default.
/* FILES
/*      temporary edit file in current directory
/*	alias data base file in spool directory
/* SEE ALSO
/*      pager(3), pager(5), kbdinp(3)
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Apr  6 20:21:35 MET 1988
/* LAST MODIFICATION
/*	Wed Apr  6 20:21:35 MET 1988
/* VERSION/RELEASE
/*	1.0
/*--*/

#include <errno.h>
#include "defs.h"
#include "path.h"
#include "pager.h"
#include "mailsh.h"
#include "screen.h"
#include "status.h"

/* forward declarations */

hidden int edit_alias();
hidden void junk_alias();
hidden int show_alias();

hidden File *afile = 0;			/* pager file */

/* alias - display alias data base */

public int alias()
{
    static Screen screen[] = {
	'C',	"Close",	0,	initscreen,
	'E',	"Edit",		edit_alias,"Edit alias data base",
	'P',	"Print",	print,	"Print alias data base",
	PGUP,	PgUp,		pu_pager,pageup,
	PGDN,	PgDn,		pd_pager,pagedn,
	UP,	"Up",           up_pager,csrup,
	DOWN,	"Down",         dn_pager,csrdn,
	0,	0,              show_alias,
	"(Reading alias database)",
    };

    kbdinp(screen);				/* ask disposition */
    junk_alias();				/* forget alias display */
    return(S_REDRAW);				/* say screen was changed */
}

/* show_alias - show alias data base or error message in middle window */

hidden int show_alias()
{
    static char *noalias[] = {			/* Ha ha ha ho ho hum */
	"",
	"The alias data base is empty. Normally it holds lines of the form",
	"",
	"	alias-name   one-or-more-mail-addresses",
	"",
	"You can create and change the alias data base with the E command.",
	0,
    };
    if (afile) {				/* check pager file exists */
	set_pager(afile);			/* select existing display */
    } else if (rd_pager(afile = open_pager(),aliases())) {
	mesg_pager(afile,noalias);		/* no alias database */
    }
    ds_pager();					/* (re)draw display */
    return(0);					/* screen is up-to-date */
}

/* junk_alias - destroy alias data base display */

hidden void junk_alias()
{
    if (afile) {				/* no-op if no display */
	close_pager(afile);			/* release memory */
	afile = 0;				/* say it is gone */
    }
}

/* edit_alias - edit or create alias data base */

hidden int edit_alias()
{
    register int stat;

    if (stat = edit(aliases(),TMPALIAS))
	errdisp(stat);				/* edit() had a problem */
    junk_alias();				/* force new display */
    return(S_REDRAW);				/* say screen has changed */
}
