// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "YtvAlarm.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame
extern DWORD g_uWM_YTV_ADJUST;
IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)
CArray<DWORD,DWORD> g_DialWatches; 
BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_MOVE()
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CMDIFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpFinder)
	ON_REGISTERED_MESSAGE(g_uWM_YTV_ADJUST,DialRegister)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	g_DialWatches.RemoveAll();
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
LRESULT CMainFrame::DialRegister(WPARAM wp,LPARAM lp)
{
	int i,size;
	DWORD lastprev;
    if(lp==-1)
	{
		size=g_DialWatches.GetSize();
		if(size==0)
		    g_DialWatches.Add(wp);
		else
        {
			lastprev=g_DialWatches.GetAt(size-1);
			if(lastprev!=wp)
                  g_DialWatches.Add(wp);
		}
    }
	if(lp==-2)
    {
		size=g_DialWatches.GetSize();
        for(i=0;i<size;i++)
			if(wp==g_DialWatches.GetAt(i))
			{
                  g_DialWatches.RemoveAt(i);
				  break;
            }   
          
    }
	return 1;
}
void CMainFrame::OnMove(int x, int y) 
{
	CMDIFrameWnd::OnMove(x, y);
	//SendMessageToDescendants(g_uWM_YTV_ADJUST, x, y, TRUE, TRUE);
	int i,size;
	HWND hw;
	size=g_DialWatches.GetSize();
	for(i=0;i<size;i++)
	{
		hw=(HWND)g_DialWatches.GetAt(i);
		::PostMessage(hw,g_uWM_YTV_ADJUST, x, y);
	}
	TRACE("Dial Size=%d\n",size);
	// TODO: Add your message handler code here
	
}
