/* --- The following code converts a file EBCDIC into ASCII
   --- Packed-Decimal COMP-3 format are also converted.
   --- cvebcdic v.1.5.  Author: Leonardo Volpi, Nov. 2000        */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* --- Function protype declaration */
int instr(int start, char *str, char *substr);
void substr(char *str1, char *str2, int start, int len);
void str(int n, char *str);
void chrchg(char *str, char a, char b, char start);
unsigned char CvEbcdicToAscii(unsigned char c);
unsigned char StartComp3(unsigned char c);
unsigned char EndComp3(unsigned char c);
void CvComp3ToAscii(unsigned char *pack, int LP ,  char *num);
int IsOddEven(int n);
void AddSuffixToStr(char *str, char *suffix);
void strleft(char *str1, char *str2, int len);
void strright(char *str1, char *str2, int len);


void Usage(char *programName)
{
	printf("\nusage: cvebcdic <FILENAME> <RECLEN>  /NULL\n");
	printf("where: FILENAME is the file EBCDIC to convert in ASCII\n");
	printf("where: RECLEN is the record length\n");
	printf("where: /NULL generate file with NULL value. Default for NULL is Blanck\n");
	printf("Example:   myfile.dat 155 \n");
	printf("--> This  will generate the file:  myfile_ascii.dat  \n");
	printf("\nThis program is freeware. Have fun!\n");
	printf("cvebcdic v.1.6.  Author: Leonardo Volpi, Dic. 2002\n");
	exit(1);
	/* Modify here to add your usage message when the program is
	 * called without arguments */
}

/* returns the index of the first argument that is not an option; i.e.
   does not start with a dash or a slash
*/
int HandleOptions(int argc,char *argv[])
{
	int i,firstnonoption=0;

	for (i=1; i< argc;i++) {
		if (argv[i][0] == '/' || argv[i][0] == '-') {
			switch (argv[i][1]) {
				/* An argument -? means help is requested */
				case '?':
					Usage(argv[0]);
					break;
				case 'h':
				case 'H':
					Usage(argv[0]);
					 break;
				/* add your option switches here */
				default:
					fprintf(stderr,"unknown option %s\n",argv[i]);
					break;
			}
		}
		else firstnonoption = i;
	}
	return firstnonoption;
}


int main(int argc,char *argv[])
{
	unsigned long byte_count, byte_max;
	int  file_count, LP, i;
	char filename[80], filedest[80];
	unsigned char a;
	unsigned char x;
	unsigned char CharNULL;
	unsigned char  pack[50], *num, COMP3;
	FILE *sorg, *dest;
	num="?????????????????????????????????????????????????";
	pack[0]=0x00;

	if(argc == 1) {
		/* If no arguments we call the Usage routine and exit */
		Usage(argv[0]);
		return 1;
	};
	/* handle the program options */
	/*opt=HandleOptions(argc,argv);*/

	if(argc == 2)
			byte_max=0;
	else
			byte_max=atoi(argv[2]);

	if(argc == 3)
			CharNULL=0x20;
	else
			CharNULL=0x00;

		/* The code of your application goes here */
	/* Extracts target file name */
	strcpy(filename,argv[1]);
	/*chrchg(filename,'.','_','R');*/
	if((sorg=fopen(argv[1],"rb"))==NULL) {
		printf("file %s not found\n",argv[1]);
		exit(1);
	}

	byte_count=0;
	file_count=1;

	strcpy(filedest,filename);
	AddSuffixToStr(filedest,"_ascii");

	if((dest=fopen(filedest,"wb"))==NULL) {
			printf("impossible to create file %s\n", filedest);
			exit(1);
		}

	COMP3='F';LP=0;
	a=getc(sorg);

	while(!feof(sorg)) {
		/* check COMP-3 format */
		if(StartComp3(a)=='T'&& COMP3=='F') COMP3='T';

		if(COMP3=='F'){
			x= CvEbcdicToAscii(a);
			if (x==0) x=CharNULL;
			putc(x,dest);
		}else{
			pack[LP]=a;	LP++;
			if(EndComp3(a)=='T'&& COMP3=='T') {
				COMP3='F';
				CvComp3ToAscii(pack, LP , num);
				i=0;LP=0;
				while(num[i]!='\0') {putc(num[i],dest);i++;}
			}
		}

		byte_count++;
		if (byte_max > 0){
			if (byte_count >= byte_max )
			{
				byte_count=0;
				a=10;
				putc(a,dest);
			}
		}
		a=getc(sorg);

	}
	fclose(sorg);
	fclose(dest);
	printf("created: %s\n",filedest) ;



	return 0;
}


int instr(int start, char *str, char *substr)
{	/* return the first character in str string that matches substr,
		 starting from the start character.
		 If start<0 or start >= len(str) or match not found, return -1
		Example:      8 <- InStr(0,"PIPPO E PLUTO","PL")

	*/
	register int t;
	char *p, *p2;
	if(start<0 || start>=strlen(str)) return -1;
		for(t=start;str[t];t++){
		p=&str[t];
		p2=substr;
		while(*p2 && *p2==*p){
			p++;
			p2++;
		}
		if(!*p2) return t;
	}
	return -1;
}

void substr(char *str1, char *str2, int start, int len)
{	/* copies, starting start, the substring of len character, from str1 to str2
		Note :  if 0 < start < len(str1)
		Example:   SubStr("ABCDEFGH",str2,2,3) --> str2="CDE"
	*/
	int i;
	char LF='\0';

	for(i=0; i<len && (start+i)<strlen(str1);i++) {
		str2[i]=str1[start+i];
	}
	str2[i]=LF;
}

void str(int n, char *str)
{	/* eliminates right-trailing blank fron str
		Example:   rtrim("ABCD  ") --> "ABCD"
	*/
	int d[3], r[3];
	char LF='\0';

	d[2]=n/100;
	r[2]=n-d[2]*100;
	d[1]=r[2]/10;
	r[1]=r[2]-d[1]*10;
	d[0]=r[1];
	r[0]=0;
	str[0]=d[2]+48;
	str[1]=d[1]+48;
	str[2]=d[0]+48;
	str[3]=LF;
}

void chrchg(char *str, char a, char b, char start)
/* substitutes all character 'a' with 'b' in string str if start="A"
	Example: chrchg("PIPPO","P","C") --> "CICCO"
    substitutes only the first character 'a' form right with 'b' if start="R"
	Example: chrchg("PIPPO","P","C") --> "PIPCO"
    substitutes only the first character 'a' form left with 'b' if start="L"
	Example: chrchg("PIPPO","P","C") --> "PIPCO"
*/
{
	int i;
	if(start=='A'){
		for(i=0; str[i];i++) {if(str[i]==a)	str[i]=b;}
	}
	if(start=='R'){
		for(i=strlen(str);i;i--) {
			if(str[i]==a){str[i]=b;	break;}
		}
	}
	if(start=='L'){
		for(i=0; str[i];i++) {
			if(str[i]==a){str[i]=b;break;}
		}
	}

}

unsigned char CvEbcdicToAscii(unsigned char c)
{
	unsigned char a[256];
a[0] = 0x0;
a[1] = 0x1;
a[2] = 0x2;
a[3] = 0x3;
a[4] = 0x4;
a[5] = 0x5;
a[6] = 0x6;
a[7] = 0x7;
a[8] = 0x8;
a[9] = 0x9;
a[10] = 0xA;
a[11] = 0xB;
a[12] = 0xC;
a[13] = 0xD;
a[14] = 0xE;
a[15] = 0xF;
a[16] = 0x10;
a[17] = 0x11;
a[18] = 0x12;
a[19] = 0x13;
a[20] = 0x14;
a[21] = 0x15;
a[22] = 0x16;
a[23] = 0x17;
a[24] = 0x18;
a[25] = 0x19;
a[26] = 0x1A;
a[27] = 0x1B;
a[28] = 0x1C;
a[29] = 0x1D;
a[30] = 0x1E;
a[31] = 0x1F;
a[32] = 0x20;
a[33] = 0x21;
a[34] = 0x22;
a[35] = 0x23;
a[36] = 0x24;
a[37] = 0x25;
a[38] = 0x26;
a[39] = 0x27;
a[40] = 0x28;
a[41] = 0x29;
a[42] = 0x2A;
a[43] = 0x2B;
a[44] = 0x2C;
a[45] = 0x2D;
a[46] = 0x2E;
a[47] = 0x2F;
a[48] = 0x2E;
a[49] = 0x2E;
a[50] = 0x32;
a[51] = 0x33;
a[52] = 0x34;
a[53] = 0x35;
a[54] = 0x36;
a[55] = 0x37;
a[56] = 0x38;
a[57] = 0x39;
a[58] = 0x3A;
a[59] = 0x3B;
a[60] = 0x3C;
a[61] = 0x3D;
a[62] = 0x2E;
a[63] = 0x3F;
a[64] = 0x20;
a[65] = 0x2E;
a[66] = 0x2E;
a[67] = 0x2E;
a[68] = 0x2E;
a[69] = 0x2E;
a[70] = 0x2E;
a[71] = 0x2E;
a[72] = 0x2E;
a[73] = 0x2E;
a[74] = 0x2E;
a[75] = 0x2E;
a[76] = 0x3C;
a[77] = 0x28;
a[78] = 0x2B;
a[79] = 0x7C;
a[80] = 0x26;
a[81] = 0x2E;
a[82] = 0x2E;
a[83] = 0x2E;
a[84] = 0x2E;
a[85] = 0x2E;
a[86] = 0x2E;
a[87] = 0x2E;
a[88] = 0x2E;
a[89] = 0x2E;
a[90] = 0x21;
a[91] = 0x24;
a[92] = 0x2A;
a[93] = 0x29;
a[94] = 0x3B;
a[95] = 0x5E;
a[96] = 0x2D;
a[97] = 0x2F;
a[98] = 0x2E;
a[99] = 0x2E;
a[100] = 0x2E;
a[101] = 0x2E;
a[102] = 0x2E;
a[103] = 0x2E;
a[104] = 0x2E;
a[105] = 0x2E;
a[106] = 0x7C;
a[107] = 0x2C;
a[108] = 0x25;
a[109] = 0x5F;
a[110] = 0x3E;
a[111] = 0x3F;
a[112] = 0x2E;
a[113] = 0x2E;
a[114] = 0x2E;
a[115] = 0x2E;
a[116] = 0x2E;
a[117] = 0x2E;
a[118] = 0x2E;
a[119] = 0x2E;
a[120] = 0x2E;
a[121] = 0x2E;
a[122] = 0x3A;
a[123] = 0x23;
a[124] = 0x40;
a[125] = 0x27;
a[126] = 0x3D;
a[127] = 0x22;
a[128] = 0x2E;
a[129] = 0x61;
a[130] = 0x62;
a[131] = 0x63;
a[132] = 0x64;
a[133] = 0x65;
a[134] = 0x66;
a[135] = 0x67;
a[136] = 0x68;
a[137] = 0x69;
a[138] = 0x2E;
a[139] = 0x2E;
a[140] = 0x2E;
a[141] = 0x2E;
a[142] = 0x2E;
a[143] = 0x2E;
a[144] = 0x2E;
a[145] = 0x6A;
a[146] = 0x6B;
a[147] = 0x6C;
a[148] = 0x6D;
a[149] = 0x6E;
a[150] = 0x6F;
a[151] = 0x70;
a[152] = 0x71;
a[153] = 0x72;
a[154] = 0x2E;
a[155] = 0x2E;
a[156] = 0x2E;
a[157] = 0x2E;
a[158] = 0x2E;
a[159] = 0x2E;
a[160] = 0x2E;
a[161] = 0x7E;
a[162] = 0x73;
a[163] = 0x74;
a[164] = 0x75;
a[165] = 0x76;
a[166] = 0x77;
a[167] = 0x78;
a[168] = 0x79;
a[169] = 0x7A;
a[170] = 0x2E;
a[171] = 0x2E;
a[172] = 0x2E;
a[173] = 0x5B;
a[174] = 0x2E;
a[175] = 0x2E;
a[176] = 0x2E;
a[177] = 0x2E;
a[178] = 0x2E;
a[179] = 0x2E;
a[180] = 0x2E;
a[181] = 0x2E;
a[182] = 0x2E;
a[183] = 0x2E;
a[184] = 0x2E;
a[185] = 0x2E;
a[186] = 0x2E;
a[187] = 0x2E;
a[188] = 0x2E;
a[189] = 0x5D;
a[190] = 0x2E;
a[191] = 0x2E;
a[192] = 0x7B;
a[193] = 0x41;
a[194] = 0x42;
a[195] = 0x43;
a[196] = 0x44;
a[197] = 0x45;
a[198] = 0x46;
a[199] = 0x47;
a[200] = 0x48;
a[201] = 0x49;
a[202] = 0x2E;
a[203] = 0x2E;
a[204] = 0x2E;
a[205] = 0x2E;
a[206] = 0x2E;
a[207] = 0x2E;
a[208] = 0x7D;
a[209] = 0x4A;
a[210] = 0x4B;
a[211] = 0x4C;
a[212] = 0x4D;
a[213] = 0x4E;
a[214] = 0x4F;
a[215] = 0x50;
a[216] = 0x51;
a[217] = 0x52;
a[218] = 0x2E;
a[219] = 0x2E;
a[220] = 0x2E;
a[221] = 0x2E;
a[222] = 0x2E;
a[223] = 0x2E;
a[224] = 0x5C;
a[225] = 0x2E;
a[226] = 0x53;
a[227] = 0x54;
a[228] = 0x55;
a[229] = 0x56;
a[230] = 0x57;
a[231] = 0x58;
a[232] = 0x59;
a[233] = 0x5A;
a[234] = 0x2E;
a[235] = 0x2E;
a[236] = 0x2E;
a[237] = 0x2E;
a[238] = 0x2E;
a[239] = 0x2E;
a[240] = 0x30;
a[241] = 0x31;
a[242] = 0x32;
a[243] = 0x33;
a[244] = 0x34;
a[245] = 0x35;
a[246] = 0x36;
a[247] = 0x37;
a[248] = 0x38;
a[249] = 0x39;
a[250] = 0x2E;
a[251] = 0x2E;
a[252] = 0x2E;
a[253] = 0x2E;
a[254] = 0x2E;
a[255] = 0x2E;

	return a[c];
}


unsigned char StartComp3(unsigned char c)
{
	/* return T (true) if c =0000XXXX, else return F (false)  */
	int y1,y0;
	unsigned char r;
	r='F';
	y1=c/16;
	y0=c - y1*16;
	if(y1==0) r='T';
	return r;
}

unsigned char EndComp3(unsigned char c)
{
	/* return T (true) if the H-nibble is 0-9 and L-nibble is A-F,
				else return F (false)  */
	int y1,y0;
	unsigned char r;
	r='F';
	y1=c/16;
	y0=c - y1*16;
	if((y1>=0 && y1<=9) && (y0>=10 && y1<=15))  r='T';
	return r;
}

void CvComp3ToAscii(unsigned char *pack, int LP ,  char *num)
{
	/*  Convert a Decimal-Packed COMP-3 in Decimal AsciString
		pack is a vector contains byte of Comp-3 format*/
	int y1,y0, c;
	int r,i,k;

	r=0;

	for(i=0;i<LP;i++){
		c=pack[i];
		y1=c/16;
		y0=c - y1*16;
		k=2*i+1;
		if(y1>=0 && y1<=9) num[k]=y1+48;
		if(y0>=0 && y0<=9) num[k+1]=y0+48;
	}
	if(y0==10 || y0==12 || y0==15) num[0]='+';  //bug AS400 thank to Valter Fusco 18.12.2002
	if(y0==11 || y0==13 || y0==14) num[0]='-';
	num[k+1]='\0';

}



int IsOddEven(int n)
{
	int  w;
	w=n-2*(n/2);
	return w;
}


void AddSuffixToStr(char *str, char *suffix)
{
	/*Example   prova.dat  --> prova_ascii.dat */
	char *s1, *s2;
	int p=0;

	s1="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
	s2="yyyyyyyyyyyyyyyyyyyyyyyyyyyyyy";
	p=instr(0,str, ".");
	if(p>0){
		strleft(s1, str, p);
		strright(s2, str, strlen(str)-p-1);
		strcpy(str,s1);
		strcat(str, suffix);
		strcat(str, ".");
		strcat(str,s2);
	} else{
		strcat(str,suffix);
	}
}



void strleft(char *str1, char *str2, int len)
{	/* copies, the left len character, from str2 to str1
	   Example:   strleft(str1, "ABCDEFGH",3) --> str1="ABC" */
	char LF='\0';
	strcpy(str1,str2);
	str1[len]=LF;
}

void strright(char *str1, char *str2, int len)
{	/* copies, the right len character, from str2 to str1
		Example:   strleft(str1, "ABCDEFGH",3) --> str1="FGH" */
	char LF='\0';
	strcpy(str1, str2+strlen(str2)-len);
	str1[len]=LF;
}
