/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.container.layout;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.base.Constraint;
import com.softaspects.framework.galileo.renderers.html.container.layout.TableLayoutRenderer;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.constraint.TableConstraint;
import com.softaspects.framework.galileo.support.components.container.layout.Bag;
import com.softaspects.framework.galileo.support.components.container.layout.Bounds;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerImpl;
import com.softaspects.framework.galileo.support.components.container.layout.RowColumnSupportedLayoutManager;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class TableLayoutManager
extends RowColumnSupportedLayoutManager {
    private ArrayList fBagList = new ArrayList();
    private int countRows = -1;
    private int countCols = -1;

    public TableLayoutManager() {
        this.setRenderer(new TableLayoutRenderer());
    }

    public Bag getBagOfComponents(int aCol, int aRow) {
        Bounds bounds = new Bounds(aCol, aRow, aCol, aRow);
        Iterator allBags = ((AbstractList)this.fBagList).iterator();
        while (allBags.hasNext()) {
            Bag bag = (Bag)allBags.next();
            if (!bag.isCrossBounds(bounds)) continue;
            return bag;
        }
        return null;
    }

    public int getCountRows(Container aContainer) {
        this.doLayout(aContainer);
        return this.countRows;
    }

    public int getCountColumns(Container aContainer) {
        this.doLayout(aContainer);
        return this.countCols;
    }

    public void addLayoutComponent(Component aComponent) {
        if (aComponent != null) {
            Iterator correspondingBags = this.getCorrespondingBags(aComponent);
            if (correspondingBags.hasNext()) {
                Bag bag = (Bag)correspondingBags.next();
                bag.addComponent(aComponent);
                while (correspondingBags.hasNext()) {
                    Bag nextBag = (Bag)correspondingBags.next();
                    bag.addBag(nextBag);
                    ((AbstractCollection)this.fBagList).remove(nextBag);
                }
            } else {
                Bag bag = new Bag();
                bag.addComponent(aComponent);
                this.fBagList.add(bag);
            }
        }
    }

    public void removeLayoutComponent(Component aComponent) {
        LayoutManagerImpl.validateComponent(aComponent);
        Iterator correspondingBags = this.getCorrespondingBags(aComponent);
        while (correspondingBags.hasNext()) {
            Bag bag = (Bag)correspondingBags.next();
            bag.removeComponent(aComponent);
            if (!bag.isBagEmpty()) continue;
            ((AbstractCollection)this.fBagList).remove(bag);
        }
    }

    public void removeAllLayoutComponents() {
        this.fBagList.clear();
    }

    public void doLayout(Container aContainer) {
        LayoutManagerImpl.validateContainer(aContainer);
        this.calculateCountColumnsAndRows();
    }

    private void calculateCountColumnsAndRows() {
        this.countRows = this.getRows();
        this.countCols = this.getColumns();
        Iterator bags = ((AbstractList)this.fBagList).iterator();
        while (bags.hasNext()) {
            Bag bag = (Bag)bags.next();
            if (bag.getEndRow() > this.countRows) {
                this.countRows = bag.getEndRow();
            }
            if (bag.getEndCol() <= this.countCols) continue;
            this.countCols = bag.getEndCol();
        }
        ++this.countCols;
        ++this.countRows;
    }

    private Iterator getCorrespondingBags(Component aComponent) {
        Bounds bounds = null;
        Constraint constraint = aComponent.getConstraint();
        if (constraint == null) {
            throw new IllegalStateException("TableLayoutManager: Constraint is null.");
        }
        if (!(constraint instanceof TableConstraint)) {
            throw new IllegalStateException("TableLayoutManager: Layout don't supported this constraint.");
        }
        TableConstraint tableConstraint = (TableConstraint)constraint;
        bounds = new Bounds(tableConstraint);
        ArrayList<Bag> correspondingBagsList = new ArrayList<Bag>();
        Iterator allBags = ((AbstractList)this.fBagList).iterator();
        while (allBags.hasNext()) {
            Bag bag = (Bag)allBags.next();
            if (!bag.isEmpty() && !bag.isCrossBounds(bounds) && (bounds != null || !bag.isBagForNonClassifiedComponents())) continue;
            correspondingBagsList.add(bag);
        }
        return ((AbstractList)correspondingBagsList).iterator();
    }
}

