/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.container.layout;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.base.Constraint;
import com.softaspects.framework.galileo.renderers.html.container.layout.GridLayoutRenderer;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.constraint.OrderConstraint;
import com.softaspects.framework.galileo.support.components.container.layout.DirectionSupportedLayoutManager;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerImpl;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerPolicy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;

public class OrderingFlowLayoutManager
extends DirectionSupportedLayoutManager {
    private TreeSet fComponentsSet = new TreeSet(new ComparatorByOrder());

    public OrderingFlowLayoutManager() {
        this.setRenderer(new GridLayoutRenderer());
        this.setDirection(this.fDirection);
    }

    public int getCountRows(Container aContainer) {
        this.doLayout(aContainer);
        int columns = this.getColumns();
        int rows = this.getRows();
        int count = aContainer.getComponentsCount();
        if (rows == -1) {
            if (columns == -1) {
                throw new IllegalStateException("LayoutManager: need assign a count of COLUMNS or ROWS.");
            }
            int remainder = count % columns == 0 ? 0 : 1;
            rows = count / columns + remainder;
        } else if (columns != -1 && rows * columns < count && LayoutManagerPolicy.generateExceptionIfCapacityOfConstainerLessCountOfComponents()) {
            throw new IllegalStateException("LayoutManager: The capacity of container less than count of components.");
        }
        return rows;
    }

    public int getCountColumns(Container aContainer) {
        this.doLayout(aContainer);
        int columns = this.getColumns();
        int rows = this.getRows();
        int count = aContainer.getComponentsCount();
        if (columns == -1) {
            if (rows == -1) {
                throw new IllegalStateException("LayoutManager: needo assign a count of COLUMNS or ROWS.");
            }
            int remainder = count % rows == 0 ? 0 : 1;
            columns = count / rows + remainder;
        } else if (rows != -1 && rows * columns < count && LayoutManagerPolicy.generateExceptionIfCapacityOfConstainerLessCountOfComponents()) {
            throw new IllegalStateException("LayoutManager: The capacity of container less than count of components.");
        }
        return columns;
    }

    public void addLayoutComponent(Component aComponent) {
        if (aComponent != null) {
            this.fComponentsSet.add(aComponent);
        }
    }

    public void removeLayoutComponent(Component aComponent) {
        this.fComponentsSet.remove(aComponent);
    }

    public void removeAllLayoutComponents() {
        this.fComponentsSet.clear();
    }

    public void doLayout(Container aContainer) {
        LayoutManagerImpl.validateContainer(aContainer);
        Object[] containerComponents = aContainer.getComponentsArray();
        if (!Arrays.equals(this.fComponentsSet.toArray(), containerComponents)) {
            this.removeAllLayoutComponents();
            int i = 0;
            while (i < containerComponents.length) {
                this.addLayoutComponent((Component)containerComponents[i]);
                ++i;
            }
            aContainer.getComponentsList().clear();
            aContainer.getComponentsList().addAll(this.fComponentsSet);
        }
    }

    class ComparatorByOrder
    implements Comparator {
        ComparatorByOrder() {
        }

        public int compare(Object aObject1, Object aObject2) {
            if (!(aObject1 instanceof Component) || !(aObject2 instanceof Component)) {
                throw new IllegalArgumentException("Comporator: Type of objects not supported.");
            }
            Constraint constraint1 = ((Component)aObject1).getConstraint();
            Constraint constraint2 = ((Component)aObject2).getConstraint();
            int value1 = Integer.MAX_VALUE;
            int value2 = Integer.MAX_VALUE;
            if ((constraint1 == null || constraint2 == null) && LayoutManagerPolicy.generateExceptionIfConstraintIsNull()) {
                throw new IllegalStateException("OrderingFlowLayoutManager: constraint is null.");
            }
            if ((constraint1 != null && !(constraint1 instanceof OrderConstraint) || constraint2 != null && !(constraint2 instanceof OrderConstraint)) && LayoutManagerPolicy.generateExceptionIfLayoutDontSupportedThisConstraint()) {
                throw new IllegalStateException("OrderingFlowLayoutManager: type of constraint is not supported.");
            }
            if (constraint1 != null && constraint1 instanceof OrderConstraint) {
                value1 = ((OrderConstraint)constraint1).getOrder();
            }
            if (constraint2 != null && constraint2 instanceof OrderConstraint) {
                value2 = ((OrderConstraint)constraint2).getOrder();
            }
            return value1 <= value2 ? -1 : 1;
        }

        public boolean equals(Object aObject) {
            return false;
        }
    }
}

