/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table.additions.string;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.InterfaceManager;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.AbstractCellRenderer;
import com.softaspects.framework.galileo.renderers.html.table.RendererUtils;
import com.softaspects.framework.galileo.support.components.listmodel.ListDataModel;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;
import java.text.Format;

public class StringFormatedStringTableCellRenderer
extends AbstractCellRenderer {
    public Object getValue() {
        int rowIndex = this.getRowIndex();
        int columnIndex = this.getColumnIndex();
        Object value = this.getTable().getValueAt(rowIndex, columnIndex);
        return value;
    }

    public String makeRender() throws RendererException {
        Object object;
        int columnIndex;
        Table table = this.getTable();
        InterfaceManager interfaceManager = table.getInterfaceManager();
        StringBuffer sBuffer = new StringBuffer();
        int rowIndex = this.getRowIndex();
        ListDataModel rendererData = interfaceManager.getRendererDataModel(rowIndex, columnIndex = this.getColumnIndex());
        if (rendererData == null) {
            this.rendererException("Can't render without renderer data model.");
        }
        if (!((object = rendererData.getValuetAt(0)) instanceof Format)) {
            this.rendererException("Can't recognize type of renderer data model.");
        }
        Format format = (Format)object;
        String text = format.format(this.getValue());
        try {
            String cellId = RendererUtils.getTableCellComponentId(table, rowIndex, columnIndex);
            sBuffer.append("<FONT");
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("ID", cellId));
            boolean selected = table.isCellSelected(rowIndex, columnIndex);
            boolean edited = false;
            boolean focused = false;
            int foreground = interfaceManager.getCellForeground(selected, focused, edited, rowIndex, columnIndex);
            if (foreground != 0) {
                String color = ColorFactory.convertColorFromIntToHtml(foreground);
                sBuffer.append(' ');
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("COLOR", color));
            }
            sBuffer.append('>');
            sBuffer.append(RendererFactory.indentString(2, text));
            sBuffer.append(RendererFactory.indentString(1, "</FONT>"));
        }
        catch (Exception e) {
            throw new RendererException(e.toString());
        }
        return sBuffer.toString();
    }

    protected void rendererException(String aText) throws RendererException {
        throw new RendererException("StringFormated Renderer: " + aText);
    }
}

