/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table.additions.number;

import com.softaspects.framework.galileo.renderers.html.table.additions.number.NumberDefaultTableCellRenderer;
import java.text.DecimalFormat;

public class NumberFileSizeTableRenderer
extends NumberDefaultTableCellRenderer {
    private static DecimalFormat BYTE_FORMAT = new DecimalFormat("#,##0.###");
    private static DecimalFormat KBYTE_FORMAT = new DecimalFormat("#,##0.###' Kb'");
    private static DecimalFormat MBYTE_FORMAT = new DecimalFormat("#,##0.###' Mb'");
    private static final long BOUNDARY_KB_VALUE = (long)Math.pow(2.0, 20.0);
    private static final long BOUNDARY_MB_VALUE = (long)Math.pow(2.0, 30.0);
    private static final long DIVIZOR_KB_VALUE = (long)Math.pow(2.0, 10.0);
    private static final long DIVIZOR_MB_VALUE = (long)Math.pow(2.0, 20.0);

    public Object getValue() {
        int rowIndex = this.getRowIndex();
        int columnIndex = this.getColumnIndex();
        Object value = this.getTable().getValueAt(rowIndex, columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return value;
        }
        return this.generateExceptionIfTypeNotCompartable(rowIndex, columnIndex, value);
    }

    protected String getTextValue() {
        Object object = this.getValue();
        if (object == null) {
            return "&nbsp;";
        }
        long value = ((Number)object).longValue();
        if (value >= BOUNDARY_MB_VALUE) {
            return MBYTE_FORMAT.format(value / DIVIZOR_MB_VALUE);
        }
        if (value >= BOUNDARY_KB_VALUE) {
            return KBYTE_FORMAT.format(value / DIVIZOR_KB_VALUE);
        }
        return BYTE_FORMAT.format(value);
    }
}

