/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.util.ReverseHashMap;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import javax.servlet.jsp.PageContext;

public class RendererUtils {
    private static ReverseHashMap fTableFrameMap = new ReverseHashMap();
    private static ReverseHashMap fTableEditMap = new ReverseHashMap();
    private static ReverseHashMap fTableCaptionAlignMap = new ReverseHashMap();
    private static ReverseHashMap fTableAltTypesMap = new ReverseHashMap();
    public static final String RULES_ALL_NAME = "ALL";
    public static final String RULES_COLS_NAME = "COLS";
    public static final String RULES_GROUPS_NAME = "GROUPS";
    public static final String RULES_NONE_NAME = "NONE";
    public static final String RULES_ROWS_NAME = "ROWS";
    public static final String FRAME_ABOVE_NAME = "ABOVE";
    public static final String FRAME_BELOW_NAME = "BELOW";
    public static final String FRAME_BOX_NAME = "BOX";
    public static final String FRAME_INSIDES_NAME = "INSIDES";
    public static final String FRAME_LHS_NAME = "LHS";
    public static final String FRAME_RHS_NAME = "RHS";
    public static final String FRAME_VOID_NAME = "VOID";
    public static final String FRAME_VSIDES_NAME = "VSIDES";
    public static final String EDITOR_MODE_JUST_NAME = "JUST";
    public static final String EDITOR_MODE_INPLACE_NAME = "INPLACE";
    public static final String ALT_CELL_HORIZONTAL_NAME = "HORIZONTAL";
    public static final String ALT_CELL_VERTICAL_NAME = "VERTICAL";
    public static final String ALT_CELL_CUSTOM_NAME = "CUSTOM";
    public static final String CAPTION_ALIGN_RIGHT_NAME = "RIGHT";
    public static final String CAPTION_ALIGN_LEFT_NAME = "LEFT";
    public static final String CAPTION_ALIGN_TOP_NAME = "TOP";
    public static final String CAPTION_ALIGN_BOTTOM_NAME = "BOTTOM";

    static {
        RendererUtils.initFrameMap();
        RendererUtils.initEditMap();
        RendererUtils.initAltTypesMap();
        RendererUtils.initCaptionAlignsMap();
    }

    private static void initFrameMap() {
        fTableFrameMap.put(new Integer(1), FRAME_ABOVE_NAME);
        fTableFrameMap.put(new Integer(2), FRAME_BELOW_NAME);
        fTableFrameMap.put(new Integer(3), FRAME_BOX_NAME);
        fTableFrameMap.put(new Integer(4), FRAME_INSIDES_NAME);
        fTableFrameMap.put(new Integer(5), FRAME_LHS_NAME);
        fTableFrameMap.put(new Integer(6), FRAME_RHS_NAME);
        fTableFrameMap.put(new Integer(8), FRAME_VSIDES_NAME);
        fTableFrameMap.put(new Integer(7), FRAME_VOID_NAME);
    }

    private static void initEditMap() {
        fTableEditMap.put(new Integer(0), EDITOR_MODE_JUST_NAME);
        fTableEditMap.put(new Integer(1), EDITOR_MODE_INPLACE_NAME);
    }

    private static void initAltTypesMap() {
        fTableAltTypesMap.put(new Integer(0), ALT_CELL_HORIZONTAL_NAME);
        fTableAltTypesMap.put(new Integer(1), ALT_CELL_VERTICAL_NAME);
        fTableAltTypesMap.put(new Integer(2), ALT_CELL_CUSTOM_NAME);
    }

    private static void initCaptionAlignsMap() {
        fTableCaptionAlignMap.put(new Integer(2), CAPTION_ALIGN_LEFT_NAME);
        fTableCaptionAlignMap.put(new Integer(1), CAPTION_ALIGN_RIGHT_NAME);
        fTableCaptionAlignMap.put(new Integer(3), CAPTION_ALIGN_TOP_NAME);
        fTableCaptionAlignMap.put(new Integer(4), CAPTION_ALIGN_BOTTOM_NAME);
    }

    public static String getFramesValue(int aFrame) {
        return aFrame < 0 ? null : (String)fTableFrameMap.getValue(new Integer(aFrame));
    }

    public static int getFrameCode(String aFrame) {
        RendererUtils.validateOnNull(aFrame, "Valign");
        Object result = fTableFrameMap.getKey(aFrame.trim().toUpperCase());
        if (result == null) {
            RendererUtils.sendMessageNotSupported(aFrame, "Frame");
        }
        return (Integer)result;
    }

    public static String getRulesValue(int aRules) {
        return TagFactory.getRulesValue(aRules);
    }

    public static int getRulesCode(String aRules) {
        return TagFactory.getRulesCode(aRules);
    }

    public static String getEditValue(int aEdit) {
        return aEdit < 0 ? null : (String)fTableEditMap.getValue(new Integer(aEdit));
    }

    public static int getEditCode(String aEdit) {
        RendererUtils.validateOnNull(aEdit, "Edit");
        Object result = fTableEditMap.getKey(aEdit.trim().toUpperCase());
        if (result == null) {
            RendererUtils.sendMessageNotSupported(aEdit, "Edit");
        }
        return (Integer)result;
    }

    public static String getAltTypeValue(int aAltType) {
        return aAltType < 0 ? null : (String)fTableAltTypesMap.getValue(new Integer(aAltType));
    }

    public static int getAltTypeCode(String aAltType) {
        RendererUtils.validateOnNull(aAltType, "Cell alternative type");
        Object result = fTableAltTypesMap.getKey(aAltType.trim().toUpperCase());
        if (result == null) {
            RendererUtils.sendMessageNotSupported(aAltType, "Cell alternative type");
        }
        return (Integer)result;
    }

    public static String getCaptionAlignValue(int aCaptionAlign) {
        return aCaptionAlign < 0 ? null : (String)fTableCaptionAlignMap.getValue(new Integer(aCaptionAlign));
    }

    public static int getCaptionAlignCode(String aCaptionAlign) {
        RendererUtils.validateOnNull(aCaptionAlign, "Caption align mode");
        Object result = fTableCaptionAlignMap.getKey(aCaptionAlign.trim().toUpperCase());
        if (result == null) {
            RendererUtils.sendMessageNotSupported(aCaptionAlign, "Caption align mode");
        }
        return (Integer)result;
    }

    public static String getTableHeaderId(Table aTable, int aColumnIndex) {
        RendererUtils.validateOnNull(aTable, "Table");
        StringBuffer sBuffer = new StringBuffer(aTable.getId());
        sBuffer.append('_');
        sBuffer.append(aColumnIndex);
        return sBuffer.toString();
    }

    public static String getTableHeaderComponentId(Table aTable, int aColumnIndex) {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(RendererUtils.getTableHeaderId(aTable, aColumnIndex));
        sBuffer.append('_');
        sBuffer.append('c');
        return sBuffer.toString();
    }

    public static String getTableCellId(Table aTable, int aRowIndex, int aColumnIndex) {
        RendererUtils.validateOnNull(aTable, "Table");
        StringBuffer sBuffer = new StringBuffer(aTable.getId());
        sBuffer.append('_');
        sBuffer.append(aRowIndex);
        sBuffer.append('_');
        sBuffer.append(aColumnIndex);
        return sBuffer.toString();
    }

    public static String getTableCellComponentId(Table aTable, int aRowIndex, int aColumnIndex) {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(RendererUtils.getTableCellId(aTable, aRowIndex, aColumnIndex));
        sBuffer.append('_');
        sBuffer.append('c');
        return sBuffer.toString();
    }

    public static String getTableCellEditorId(Table aTable, int aRowIndex, int aColumnIndex) {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(RendererUtils.getTableCellId(aTable, aRowIndex, aColumnIndex));
        sBuffer.append('_');
        sBuffer.append('e');
        return sBuffer.toString();
    }

    public static String getJSPPath(PageContext aPageContext) {
        return RendererFactory.getJSPPath(aPageContext);
    }

    public static String createHtmlEvent(int aEventType, String aFunction) {
        if (aFunction != null) {
            String event = RendererFactory.getPresentationEventName(aEventType);
            return RendererFactory.createHtmlStylePropertyString(event, aFunction);
        }
        return null;
    }

    private static void validateOnNull(Object aValue, String aName) {
        if (aValue == null) {
            throw new IllegalArgumentException("TableRendererUtls: " + aName + " can't be null.");
        }
    }

    private static void sendMessageNotSupported(String aValue, String aName) {
        throw new IllegalArgumentException("TableRendererUtils: " + aName + " value '" + aValue + "' not supported.");
    }
}

