/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptProviderBase;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptResource;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.AbstractTableRenderer;
import com.softaspects.framework.galileo.renderers.html.table.CellRenderer;
import com.softaspects.framework.galileo.renderers.html.table.RendererUtils;
import com.softaspects.framework.galileo.renderers.html.table.TableRenderer;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractCellRenderer
extends AbstractTableRenderer
implements CellRenderer {
    protected static final String TABLE_CELL_SCRIPT_WAS_LOADED = "TABLE_CELL_SCRIPT_WAS_LOADED";
    protected static final String TABLE_CELL_SCRIPT_FUNCTION = "TableCell";
    protected static final String TABLE_CELL_SCRIPT = "tablecell.js";
    protected static final String TABLE_CELL_SCRIPT_PREFIX = "Cell";
    private int fRowIndex = -1;
    protected int fColumnIndex = -1;

    public void setRowIndex(int aRowIndex) {
        AbstractCellRenderer.validateValue(aRowIndex, "Row index");
        this.fRowIndex = aRowIndex;
    }

    public int getRowIndex() {
        AbstractCellRenderer.validateState(this.fRowIndex, "Row index");
        return this.fRowIndex;
    }

    public void setColumnIndex(int aColumnIndex) {
        AbstractCellRenderer.validateValue(aColumnIndex, "Column index");
        this.fColumnIndex = aColumnIndex;
    }

    public int getColumnIndex() {
        AbstractCellRenderer.validateState(this.fColumnIndex, "Column index");
        return this.fColumnIndex;
    }

    public void addJScriptCommamd(String aJsCommand) {
        if (aJsCommand != null && aJsCommand.length() > 0) {
            ((TableRenderer)this.getTable().getRenderer()).addJScriptCommamd(aJsCommand);
        }
    }

    public String doRender() throws RendererException {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(this.loadJScript());
        sBuffer.append(this.makeRender());
        this.createJSVariable();
        String result = sBuffer.toString();
        return sBuffer.toString();
    }

    public String loadJScript() throws RendererException {
        Object flag = this.fPageContext.getAttribute(TABLE_CELL_SCRIPT_WAS_LOADED, 2);
        StringBuffer sBuffer = new StringBuffer();
        if (flag == null) {
            try {
                JavaScriptResource javaScriptResource = new JavaScriptProviderBase().getJavaScriptResource((HttpServletRequest)this.fPageContext.getRequest());
                this.fPageContext.getOut().println(RendererFactory.createJScriptBeginTag(javaScriptResource.getComponentJavaScriptSource("TABLE_CELL"), null));
                this.fPageContext.getOut().println(RendererFactory.createJScriptEndTag());
                this.fPageContext.setAttribute(TABLE_CELL_SCRIPT_WAS_LOADED, (Object)TABLE_CELL_SCRIPT_WAS_LOADED, 2);
            }
            catch (Exception e) {
                throw new RendererException(e.toString());
            }
        }
        return sBuffer.toString();
    }

    public abstract String makeRender() throws RendererException;

    public void createJSVariable() throws RendererException {
        int rowIndex = this.getRowIndex();
        int columnIndex = this.getColumnIndex();
        Table table = this.getTable();
        StringBuffer params = new StringBuffer();
        params.append(String.valueOf(table.isCellEditable(rowIndex, columnIndex)));
        params.append(',');
        Object value = this.getValue();
        if (value == null) {
            params.append("null");
        } else if (value instanceof Number || value instanceof Boolean) {
            params.append(String.valueOf(value));
        } else if (value instanceof Date) {
            params.append(((Date)value).getTime());
        } else {
            params.append(RendererFactory.bracketString(String.valueOf(value)));
        }
        String cellId = RendererUtils.getTableCellComponentId(table, rowIndex, columnIndex);
        this.addJScriptCommamd(AbstractTableRenderer.createJsCommand(TABLE_CELL_SCRIPT_PREFIX, cellId, TABLE_CELL_SCRIPT_FUNCTION, params.toString()));
    }

    protected static void validateValue(int aValue, String aName) {
        if (aValue < 0) {
            throw new IllegalArgumentException("TableCellRenderer: " + aName + " can't be negative.");
        }
    }

    protected static void validateState(int aValue, String aName) {
        if (aValue == -1) {
            throw new IllegalStateException("TableCellRenderer: " + aName + " must be initialized.");
        }
    }

    public abstract Object getValue();
}

