/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.label;

import com.softaspects.framework.galileo.components.base.PresentationEvent;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.ContextRendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.label.LabelImpl;
import com.softaspects.framework.galileo.support.components.label.model.AdvancedLabelModel;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.jsp.JspWriter;

public class LabelRenderer
extends ContextRendererImpl {
    public String doRender() throws RendererException {
        LabelImpl label = (LabelImpl)this.getComponent();
        AdvancedLabelModel labelModel = label.getAdvancedLabelModel();
        String labelId = label.getId();
        String textName = String.valueOf(labelId) + "_label_text";
        String leftImageName = String.valueOf(labelId) + "_label_left_image";
        String rightImageName = String.valueOf(labelId) + "_label_right_image";
        JspWriter out = this.fPageContext.getOut();
        StringBuffer generatedContent = new StringBuffer();
        try {
            generatedContent.append("<TABLE");
            generatedContent.append(' ');
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("ID", labelId));
            generatedContent.append(' ');
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("BORDER", 0));
            generatedContent.append(' ');
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("CELLPADDING", 0));
            generatedContent.append(' ');
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("CELLSPACING", 0));
            generatedContent.append(" \n");
            Iterator htmlProperties = RendererFactory.componentHtmlPropertiesIterator(label);
            while (htmlProperties.hasNext()) {
                HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
                generatedContent.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
                generatedContent.append(' ');
            }
            if (labelModel.getHintText() != null) {
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("TITLE", labelModel.getHintText()));
            }
            Iterator presentationEvents = label.getPresentationEvents();
            while (presentationEvents.hasNext()) {
                generatedContent.append(' ');
                PresentationEvent presentationEvent = (PresentationEvent)presentationEvents.next();
                String type = RendererFactory.getPresentationEventName(presentationEvent.getType());
                String value = presentationEvent.getValue();
                generatedContent.append(RendererFactory.createHtmlStylePropertyString(type, value));
            }
            generatedContent.append(">\n");
            generatedContent.append("<TR");
            generatedContent.append(' ');
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("ID", String.valueOf(labelId) + "_row"));
            generatedContent.append(">\n");
            int imgWidth = -1;
            int imgHeight = -1;
            String leftDefaultImageSrc = null;
            String leftHiliteImageSrc = null;
            String rightDefaultImageSrc = null;
            String rightHiliteImageSrc = null;
            if (label.getUseSmallImages()) {
                imgWidth = label.getSmallImageWidth();
                imgHeight = label.getSmallImageHeight();
                leftDefaultImageSrc = labelModel.getLeftSmallImage();
                leftHiliteImageSrc = labelModel.getHiliteLeftSmallImage();
                rightDefaultImageSrc = labelModel.getRightSmallImage();
                rightHiliteImageSrc = labelModel.getHiliteRightSmallImage();
            } else {
                imgWidth = label.getImageWidth();
                imgHeight = label.getImageHeight();
                leftDefaultImageSrc = labelModel.getLeftImage();
                leftHiliteImageSrc = labelModel.getHiliteLeftImage();
                rightDefaultImageSrc = labelModel.getRightImage();
                rightHiliteImageSrc = labelModel.getHiliteRightImage();
            }
            if (label.getLeftInactiveImage() != null) {
                generatedContent.append("<TD");
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("ID", String.valueOf(labelId) + "_left"));
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("NOWRAP", null));
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("ALIGN", "right"));
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("VALIGN", "bottom"));
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("WIDTH", imgWidth));
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("HEIGHT", imgHeight));
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("STYLE", "BACKGROUND-REPEAT:no-repeat;BACKGROUND-IMAGE:url" + RendererFactory.parenthesizeString(label.getLeftInactiveImage())));
                generatedContent.append(">\n&nbsp;\n");
                generatedContent.append("</TD>\n");
            }
            generatedContent.append("<TD");
            generatedContent.append(' ');
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("ID", String.valueOf(labelId) + "_center"));
            generatedContent.append(' ');
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("NOWRAP", null));
            generatedContent.append(' ');
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("ALIGN", "center"));
            generatedContent.append(' ');
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("HEIGHT", imgHeight));
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("VALIGN", "middle"));
            generatedContent.append(' ');
            generatedContent.append(">\n");
            StringBuffer baseStyle = new StringBuffer("STYLE=\"cursor:default;font-family:" + labelModel.getFontFamily() + ";font-weight:" + labelModel.getFontWeight() + ";font-style:" + labelModel.getFontStyle() + ";font-size:" + labelModel.getFontSize() + ";color:" + labelModel.getFontColor() + ";");
            String textStyle = null;
            StringBuffer centerStyle = new StringBuffer(baseStyle.toString());
            if (label.getCenterInactiveImage() != null) {
                centerStyle.append("BACKGROUND-REPEAT:repeat;BACKGROUND-IMAGE:url" + RendererFactory.parenthesizeString(label.getCenterInactiveImage()) + ";\"");
                textStyle = String.valueOf(baseStyle.toString()) + "\"";
            } else {
                centerStyle.append("background:" + label.getBackgroundColor() + ";\"");
                textStyle = centerStyle.toString();
            }
            generatedContent.append("<TABLE ");
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("ID", String.valueOf(labelId) + "_label"));
            generatedContent.append(' ');
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("CELLPADDING", 0));
            generatedContent.append(' ');
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("CELLSPACING", 0));
            generatedContent.append(" \n");
            generatedContent.append(RendererFactory.createHtmlStylePropertyString("WIDTH", "100%"));
            generatedContent.append(" \n" + centerStyle.toString() + ">\n");
            generatedContent.append("<TR ID=\"" + labelId + "_label_row\">\n");
            StringBuffer labelLeftImageTd = new StringBuffer("\n");
            StringBuffer labelRightImageTd = new StringBuffer("\n");
            String baseTextOnMouseOverHandler = "x0653090547866255818095811111('" + textName + "').style.color='" + labelModel.getFontColorHilite() + "';";
            String baseTextOnMouseOutHandler = "x0653090547866255818095811111('" + textName + "').style.color='" + labelModel.getFontColor() + "';";
            String textOnMouseOverHandler = baseTextOnMouseOverHandler;
            String textOnMouseOutHandler = baseTextOnMouseOutHandler;
            String leftImageTdString = "<TD ID=\"" + labelId + "_label_left_image_td\" NOWRAP " + "valign=\"middle\" width=" + imgWidth + " height=" + imgHeight + ">\n";
            String leftImageConstantString = "<IMG ID=\"" + leftImageName + "\" NAME=\"" + leftImageName + "\" " + " align=\"center\"";
            String rightImageTdString = "<TD ID=\"" + labelId + "_label_right_image_td\" NOWRAP " + "valign=\"middle\" width=" + imgWidth + " height=" + imgHeight + ">\n";
            String rightImageConstantString = "<IMG ID=\"" + rightImageName + "\" NAME=\"" + rightImageName + "\" " + " align=\"center\"";
            String leftDefaultImageVar = String.valueOf(labelId) + "_left_default_image";
            String leftHiliteImageVar = String.valueOf(labelId) + "_left_hilite_image";
            String rightDefaultImageVar = String.valueOf(labelId) + "_right_default_image";
            String rightHiliteImageVar = String.valueOf(labelId) + "_right_hilite_image";
            StringBuffer leftImageScript = new StringBuffer("");
            StringBuffer rightImageScript = new StringBuffer("");
            String leftImageOnMouseOverHandler = null;
            String leftImageOnMouseOutHandler = null;
            String rightImageOnMouseOverHandler = null;
            String rightImageOnMouseOutHandler = null;
            if (leftHiliteImageSrc != null) {
                leftImageScript.append("<script>\n");
                leftImageScript.append(String.valueOf(leftDefaultImageVar) + " = new Image();\n");
                leftImageScript.append(String.valueOf(leftDefaultImageVar) + ".src = '" + leftDefaultImageSrc + "';\n");
                leftImageScript.append(String.valueOf(leftHiliteImageVar) + " = new Image();\n");
                leftImageScript.append(String.valueOf(leftHiliteImageVar) + ".src = '" + leftHiliteImageSrc + "';\n");
                leftImageScript.append("</script>\n");
                leftImageOnMouseOverHandler = "x0653090547866255818095811111('" + leftImageName + "').src=" + leftHiliteImageVar + ".src;" + baseTextOnMouseOverHandler;
                leftImageOnMouseOutHandler = "x0653090547866255818095811111('" + leftImageName + "').src=" + leftDefaultImageVar + ".src;" + baseTextOnMouseOutHandler;
                textOnMouseOverHandler = String.valueOf(baseTextOnMouseOverHandler) + "x0653090547866255818095811111('" + leftImageName + "').src=" + leftHiliteImageVar + ".src;";
                textOnMouseOutHandler = String.valueOf(baseTextOnMouseOutHandler) + "x0653090547866255818095811111('" + leftImageName + "').src=" + leftDefaultImageVar + ".src;";
            } else {
                leftImageOnMouseOverHandler = "";
                leftImageOnMouseOutHandler = "";
            }
            if (rightHiliteImageSrc != null) {
                rightImageScript.append("<script>\n");
                rightImageScript.append(String.valueOf(rightDefaultImageVar) + " = new Image();\n");
                rightImageScript.append(String.valueOf(rightDefaultImageVar) + ".src = '" + rightDefaultImageSrc + "';\n");
                rightImageScript.append(String.valueOf(rightHiliteImageVar) + " = new Image();\n");
                rightImageScript.append(String.valueOf(rightHiliteImageVar) + ".src = '" + rightHiliteImageSrc + "';\n");
                rightImageScript.append("</script>\n");
                rightImageOnMouseOverHandler = "x0653090547866255818095811111('" + rightImageName + "').src=" + rightHiliteImageVar + ".src;" + baseTextOnMouseOverHandler;
                rightImageOnMouseOutHandler = "x0653090547866255818095811111('" + rightImageName + "').src=" + rightDefaultImageVar + ".src;" + baseTextOnMouseOutHandler;
                textOnMouseOverHandler = String.valueOf(textOnMouseOverHandler) + "x0653090547866255818095811111('" + rightImageName + "').src=" + rightHiliteImageVar + ".src;";
                textOnMouseOutHandler = String.valueOf(textOnMouseOutHandler) + "x0653090547866255818095811111('" + rightImageName + "').src=" + rightDefaultImageVar + ".src;";
            } else {
                rightImageOnMouseOverHandler = "";
                rightImageOnMouseOutHandler = "";
            }
            if (leftDefaultImageSrc != null) {
                labelLeftImageTd.append(leftImageTdString);
                labelLeftImageTd.append(leftImageScript.toString());
                labelLeftImageTd.append(String.valueOf(leftImageConstantString) + " src=\"" + leftDefaultImageSrc + "\" onmouseover=\"" + leftImageOnMouseOverHandler + "\" " + "onmouseout=\"" + leftImageOnMouseOutHandler + "\" >\n");
                labelLeftImageTd.append("</TD>\n");
            }
            generatedContent.append((Object)labelLeftImageTd);
            generatedContent.append("<TD  NOWRAP align=\"center\" height=" + imgHeight + " valign=\"middle\" >\n" + "<DIV ID=\"" + textName + "\" " + textStyle + " onmouseover=\"" + textOnMouseOverHandler + "\" onmouseout=\"" + textOnMouseOutHandler + "\" >\n");
            generatedContent.append(String.valueOf(labelModel.getText()) + "\n</DIV>\n</TD>\n");
            if (rightDefaultImageSrc != null) {
                labelRightImageTd.append(rightImageTdString);
                labelRightImageTd.append(rightImageScript.toString());
                labelRightImageTd.append(String.valueOf(rightImageConstantString) + " src=\"" + rightDefaultImageSrc + "\" onmouseover=\"" + rightImageOnMouseOverHandler + "\" " + "onmouseout=\"" + rightImageOnMouseOutHandler + "\" >\n");
                labelRightImageTd.append("</TD>\n");
            }
            generatedContent.append((Object)labelRightImageTd);
            generatedContent.append("</TR>\n</TABLE>\n");
            generatedContent.append("</TD>\n");
            if (label.getRightInactiveImage() != null) {
                generatedContent.append("<TD");
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("ID", String.valueOf(labelId) + "_right"));
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("NOWRAP", null));
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("ALIGN", "right"));
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("VALIGN", "bottom"));
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("WIDTH", imgWidth));
                generatedContent.append(' ');
                generatedContent.append(RendererFactory.createHtmlStylePropertyString("STYLE", "BACKGROUND-REPEAT:no-repeat;BACKGROUND-IMAGE:url" + RendererFactory.parenthesizeString(label.getRightInactiveImage())));
                generatedContent.append(">\n&nbsp;\n");
                generatedContent.append("</TD>\n");
            }
            generatedContent.append("</TR>\n</TABLE>\n");
            String result = generatedContent.toString();
            if (label.isPageContextRendering()) {
                out.println(generatedContent.toString());
            }
            return result;
        }
        catch (IOException e) {
            throw new RendererException(e.toString());
        }
    }
}

