/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.base;

import com.softaspects.framework.galileo.support.util.ReverseHashMap;

public class JavaScriptResourceUtils {
    private static ReverseHashMap fComponentTypeScriptMap = new ReverseHashMap();
    private static String EMPTY_SCRIPT = "";

    static {
        JavaScriptResourceUtils.addComponentScript("ANCHOR_COMPONENT", null);
        JavaScriptResourceUtils.addComponentScript("BASE_COMPONENT", "commons.js");
        JavaScriptResourceUtils.addComponentScript("BUTTON_SUBMIT", "button.js");
        JavaScriptResourceUtils.addComponentScript("BUTTON_RESET", "button.js");
        JavaScriptResourceUtils.addComponentScript("BUTTON_IMAGE", "button.js");
        JavaScriptResourceUtils.addComponentScript("BUTTON_CHECKBOX", "button.js");
        JavaScriptResourceUtils.addComponentScript("BUTTON_RADIO", "button.js");
        JavaScriptResourceUtils.addComponentScript("BUTTON_COMMON", "button.js");
        JavaScriptResourceUtils.addComponentScript("CONTENT_ENVELOP", null);
        JavaScriptResourceUtils.addComponentScript("HIDDEN_FORM", "form.js");
        JavaScriptResourceUtils.addComponentScript("FRAME_COMPONENT", null);
        JavaScriptResourceUtils.addComponentScript("FRAMESET_CONTAINER", null);
        JavaScriptResourceUtils.addComponentScript("IFRAME_COMPONENT", null);
        JavaScriptResourceUtils.addComponentScript("INCLUDE_COMPONENT", null);
        JavaScriptResourceUtils.addComponentScript("TOOLBAR", "toolbar.js");
        JavaScriptResourceUtils.addComponentScript("MENUBAR", "menu.js");
        JavaScriptResourceUtils.addComponentScript("TREEVIEW", "tree.js");
        JavaScriptResourceUtils.addComponentScript("LABEL", null);
        JavaScriptResourceUtils.addComponentScript("LISTBOX", "list.js");
        JavaScriptResourceUtils.addComponentScript("COMBOBOX", "list.js");
        JavaScriptResourceUtils.addComponentScript("RAW_DATA", null);
        JavaScriptResourceUtils.addComponentScript("REQUIRED_INDICATOR", null);
        JavaScriptResourceUtils.addComponentScript("TABLE_CELL_EDITOR", "tedit.js");
        JavaScriptResourceUtils.addComponentScript("TABLE_CELL", "tcell.js");
        JavaScriptResourceUtils.addComponentScript("TABLE_HEADER", "theader.js");
        JavaScriptResourceUtils.addComponentScript("TAB", "tab.js");
        JavaScriptResourceUtils.addComponentScript("TABSET", "tabbedpanel.js");
        JavaScriptResourceUtils.addComponentScript("TABLE_COMPONENT", "table.js");
    }

    private static void addComponentScript(String aComponentName, String aScript) {
        fComponentTypeScriptMap.put(aComponentName.toUpperCase(), aScript != null ? aScript : EMPTY_SCRIPT);
    }

    public static String getScriptName(String aComponentTypeName) {
        Object scriptName = null;
        if (aComponentTypeName != null) {
            String typeName = aComponentTypeName.toUpperCase();
            scriptName = fComponentTypeScriptMap.getValue(typeName);
        }
        if (scriptName == null) {
            throw new IllegalArgumentException("JavaScriptResourceUtils.getScriptName: unsupported component type name " + aComponentTypeName);
        }
        return (String)scriptName;
    }

    public static String getComponentTypeName(String aComponentScriptName) {
        Object typeName = null;
        if (aComponentScriptName != null) {
            String scriptName = aComponentScriptName.toLowerCase();
            typeName = fComponentTypeScriptMap.getKey(scriptName);
        }
        if (typeName == null) {
            throw new IllegalArgumentException("JavaScriptResourceUtils.getComponentTypeName: unsupported component script name " + aComponentScriptName);
        }
        return (String)typeName;
    }
}

