/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.table;

import com.softaspects.framework.galileo.components.base.Interval;
import com.softaspects.framework.galileo.components.table.Column;
import com.softaspects.framework.galileo.components.table.ColumnImpl;
import com.softaspects.framework.galileo.components.table.ColumnModel;
import com.softaspects.framework.galileo.components.table.ColumnModelImpl;
import com.softaspects.framework.galileo.components.table.Cursor;
import com.softaspects.framework.galileo.components.table.DataModel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class DataModelImpl
implements DataModel {
    protected Cursor fCursor = new Cursor();
    protected List fDataList = new ArrayList();
    protected List fColumnsIdefiersList = new ArrayList();
    protected List fEditList = new ArrayList();
    protected int rowCount = -1;
    protected int columnCount = -1;
    private static final boolean DEFAULT_EDITABLE = false;

    public DataModelImpl(List aDataList, List aColumnsIdeftifiersList) {
        if (aDataList != null) {
            int columnsCount = aColumnsIdeftifiersList != null ? aColumnsIdeftifiersList.size() : this.getDefaultColumnCount(aDataList);
            this.setData(aDataList, columnsCount);
        }
        if (aColumnsIdeftifiersList != null) {
            this.setColumnsID(aColumnsIdeftifiersList);
        }
    }

    public DataModelImpl(List aDataList) {
        this(aDataList, null);
    }

    public DataModelImpl(Object[][] aData, Object[] aColumnsIdeftifiers) {
        this(DataModelImpl.convertToList(aData), Arrays.asList(aColumnsIdeftifiers));
    }

    public DataModelImpl(Object[][] aData) {
        this(aData, null);
    }

    public DataModelImpl(int aRowCount, List aColumnsIdeftifiersList) {
        this(null, aColumnsIdeftifiersList);
        this.setRowCount(aRowCount);
    }

    public DataModelImpl() {
        this((List)null, (List)null);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int aNewSize) {
        DataModelImpl.validateValue(aNewSize, "Row count");
        if (aNewSize != this.getRowCount()) {
            if (aNewSize > this.getRowCount()) {
                int columnCount = this.getColumnCount();
                while (this.getRowCount() < aNewSize) {
                    ArrayList newRow = new ArrayList(columnCount);
                    this.getDataList().add(newRow);
                }
            }
            this.rowCount = aNewSize;
            this.getCursor().setRowsCount(aNewSize);
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int aColumnCount) {
        this.columnCount = aColumnCount;
        if (aColumnCount > this.fEditList.size()) {
            while (this.fEditList.size() < aColumnCount) {
                this.fEditList.add(DataModelImpl.createDefaultEditBitSet());
            }
        }
    }

    public void setSize(int aRowCount, int aColumnCount) {
        this.setColumnCount(aColumnCount);
        this.setRowCount(aRowCount);
    }

    public Object getValueAt(int aRowIndex, int aColumnIndex) {
        if (this.validateBounds(aRowIndex, aColumnIndex)) {
            List rowList = (List)this.getDataList().get(aRowIndex);
            return rowList.get(aColumnIndex);
        }
        return null;
    }

    public void setValueAt(Object aValue, int aRowIndex, int aColumnIndex) {
        if (this.validateBounds(aRowIndex, aColumnIndex) && this.isCellEditable(aRowIndex, aColumnIndex)) {
            List rowList = (List)this.getDataList().get(aRowIndex);
            rowList.set(aColumnIndex, aValue);
        }
    }

    public void addColumn(Object aColumnID, List aColumnDataList) {
        DataModelImpl.validateValue(aColumnID, "Column ID");
        this.getIdenfifiersList().add(aColumnID);
        this.fEditList.add(DataModelImpl.createDefaultEditBitSet());
        int index = 0;
        int size = aColumnDataList != null ? aColumnDataList.size() : -1;
        Iterator rows = this.getData();
        while (rows.hasNext()) {
            Object value = index < size ? (Object)aColumnDataList.get(index) : null;
            List row = (List)rows.next();
            row.add(value);
            ++index;
        }
        ++this.columnCount;
    }

    public void addColumn(Object aColumnID, Object[] aColumnData) {
        this.addColumn(aColumnID, Arrays.asList(aColumnData));
    }

    public void removeColumn(int aColumnIndex) {
        if (this.validateColumns(aColumnIndex)) {
            Iterator rows = this.getData();
            while (rows.hasNext()) {
                List row = (List)rows.next();
                row.remove(aColumnIndex);
            }
            --this.columnCount;
            this.getIdenfifiersList().remove(aColumnIndex);
        } else {
            DataModelImpl.generateExceptionOutOfBound("Column index");
        }
    }

    public void removeColumn(Object aColumnID) {
        DataModelImpl.validateValue(aColumnID, "Column ID");
        this.removeColumn(this.getColumnIndex(aColumnID));
    }

    public void setColumnID(int aColumnIndex, Object aColumnID) {
        DataModelImpl.validateValue(aColumnID, "ColumnID");
        if (this.validateColumns(aColumnIndex)) {
            this.getIdenfifiersList().set(aColumnIndex, aColumnID);
        } else {
            DataModelImpl.generateExceptionOutOfBound("Column index");
        }
    }

    public Object getColumnID(int aColumnIndex) {
        if (this.validateColumns(aColumnIndex)) {
            Object columnID = this.getIdenfifiersList().get(aColumnIndex);
            if (columnID == null) {
                columnID = this.getDefaultColumnID(aColumnIndex);
                this.setColumnID(aColumnIndex, columnID);
            }
            return columnID;
        }
        return null;
    }

    public int getColumnIndex(Object aColumnID) {
        DataModelImpl.validateValue(aColumnID, "Column ID");
        return this.getIdenfifiersList().indexOf(aColumnID);
    }

    public void setColumnsID(List aColumnsIDList) {
        int columnsCount = this.getColumnCount();
        List columnsIdefiersList = this.getIdenfifiersList();
        columnsIdefiersList.clear();
        if (aColumnsIDList != null) {
            columnsIdefiersList.addAll(aColumnsIDList);
        } else if (columnsCount != 0) {
            columnsIdefiersList.addAll(this.getDefaultColumnsIDList(columnsCount));
        }
    }

    public void setColumnsID(Object[] aColumnsID) {
        this.setColumnsID(Arrays.asList(aColumnsID));
    }

    public void addRow(List aRowData) {
        List newRow = aRowData != null ? aRowData : new ArrayList(this.getColumnCount());
        this.getDataList().add(newRow);
        ++this.rowCount;
        this.getCursor().setRowsCount(this.getRowCount());
    }

    public void addRow(Object[] aRowData) {
        this.addRow(Arrays.asList(aRowData));
    }

    public void insertRow(int aRowIndex, List aRowData) {
        this.validateRows(aRowIndex);
        List newRow = aRowData != null ? aRowData : new ArrayList(this.getColumnCount());
        this.getDataList().add(aRowIndex, newRow);
        ++this.rowCount;
        this.getCursor().setRowsCount(this.getRowCount());
    }

    public void insertRow(int aRowIndex, Object[] aRowData) {
        this.insertRow(aRowIndex, Arrays.asList(aRowData));
    }

    public void removeRow(int aRowIndex) {
        if (this.validateRows(aRowIndex)) {
            this.getDataList().remove(aRowIndex);
            --this.rowCount;
            this.getCursor().setRowsCount(this.getRowCount());
        } else {
            DataModelImpl.generateExceptionOutOfBound("Row index");
        }
    }

    public void moveRow(int aCurrentIndex, int aToIndex) {
        if (this.validateRows(aCurrentIndex) && this.validateRows(aToIndex)) {
            if (aCurrentIndex != aToIndex) {
                List dataList = this.getDataList();
                Object row = dataList.get(aCurrentIndex);
                dataList.remove(aCurrentIndex);
                dataList.add(aToIndex, row);
            }
        } else {
            DataModelImpl.generateExceptionOutOfBound("Row index");
        }
    }

    public List getRow(int aRowIndex) {
        return (List)this.getDataList().get(aRowIndex);
    }

    public Iterator getData() {
        return this.getDataList().iterator();
    }

    public List getDataList() {
        return this.fDataList;
    }

    public void setData(List aNewData, int aColumnsCount) {
        this.getDataList().clear();
        if (aNewData != null) {
            this.getDataList().addAll(aNewData);
            this.rowCount = this.getDataList().size();
        }
        this.setColumnCount(aColumnsCount);
        this.getCursor().setRowsCount(this.getRowCount());
    }

    public void setData(Object[][] aNewData, int aColumnsCount) {
        this.setData(DataModelImpl.convertToList(aNewData), aColumnsCount);
    }

    public void setData(List aNewData, List aColumnsIDsList) {
        this.setData(aNewData, aColumnsIDsList.size());
        this.setColumnsID(aColumnsIDsList);
    }

    public void setData(Object[][] aNewData, Object[] aColumnColumnsIDs) {
        this.setData(DataModelImpl.convertToList(aNewData), Arrays.asList(aColumnColumnsIDs));
    }

    public void clearData() {
        this.setData((List)null, this.getColumnCount());
    }

    public boolean isCellEditable(int aRowIndex, int aColumnIndex) {
        if (this.validateBounds(aRowIndex, aColumnIndex)) {
            BitSet column = (BitSet)this.fEditList.get(aColumnIndex);
            return column.get(aRowIndex);
        }
        return false;
    }

    public void setCellEditable(int aRowIndex, int aColumnIndex, boolean aEditable) {
        if (this.validateBounds(aRowIndex, aColumnIndex)) {
            BitSet column = (BitSet)this.fEditList.get(aColumnIndex);
            if (aEditable) {
                column.set(aRowIndex);
            } else {
                column.clear(aRowIndex);
            }
        }
    }

    public Column createDefaultColumn(int aColumnIndex) {
        if (!this.validateColumns(aColumnIndex)) {
            DataModelImpl.generateExceptionOutOfBound("Column index");
        }
        Object ID = this.getColumnID(aColumnIndex);
        return new ColumnImpl(ID, ID, aColumnIndex);
    }

    public ColumnModel createDefaultColumnModel() {
        ColumnModelImpl tableColumnModel = new ColumnModelImpl();
        int i = 0;
        while (i < this.getColumnCount()) {
            tableColumnModel.addColumn(this.createDefaultColumn(i));
            ++i;
        }
        return tableColumnModel;
    }

    public Cursor getCursor() {
        return this.fCursor;
    }

    public Iterator getDataByCursor() {
        ArrayList<List> result = new ArrayList<List>();
        Interval interval = this.getCursor().getCurrentInterval();
        int i = interval.getTop();
        while (i <= interval.getBottom()) {
            List row = this.getRow(i);
            if (row != null) {
                result.add(row);
            }
            ++i;
        }
        return ((AbstractList)result).iterator();
    }

    public void setCursorPageSize(int aPageSize) {
        this.getCursor().setPageSize(aPageSize);
    }

    public int getCursorPageSize() {
        return this.getCursor().getPageSize();
    }

    public int getCursorPagesCount() {
        return this.getCursor().getCountSteps();
    }

    public int getCursorCurrentPage() {
        return this.getCursor().getCurrentStep();
    }

    public void cursorToStart() {
        this.getCursor().goToStart();
    }

    public void cursorToEnd() {
        this.getCursor().goToEnd();
    }

    public void cursorStepForward() {
        this.getCursor().stepForward();
    }

    public void cursorStepBackward() {
        this.getCursor().stepBackward();
    }

    public boolean isCursorFirstPage() {
        return this.getCursor().isFirstStep();
    }

    public boolean isCursorLastPage() {
        return this.getCursor().isLastStep();
    }

    public int getRowCountByCursor() {
        return this.getCursor().getCurrentIntervalLength();
    }

    public int getFirstRowIndexByCursor() {
        return this.getCursor().getCurrentIntervalFirstIndex();
    }

    public int getLastRowIndexByCursor() {
        return this.getCursor().getCurrentIntervalLastIndex();
    }

    public Comparator getRowComparator(Comparator aColumnComparator, int aIndex, boolean aAsc) {
        return new RowComparator(aColumnComparator, aIndex, aAsc);
    }

    protected List getIdenfifiersList() {
        return this.fColumnsIdefiersList;
    }

    protected int getDefaultColumnCount(List aDataList) {
        int result = 0;
        if (aDataList != null) {
            Iterator rows = aDataList.iterator();
            while (rows.hasNext()) {
                List row = (List)rows.next();
                if (row.size() <= result) continue;
                result = row.size();
            }
        }
        return result;
    }

    protected List getDefaultColumnsIDList(int aColumnsCount) {
        if (aColumnsCount > 0) {
            ArrayList<String> idList = new ArrayList<String>(aColumnsCount);
            int i = 0;
            while (i < aColumnsCount) {
                idList.add(this.getDefaultColumnID(i));
                ++i;
            }
            return idList;
        }
        return null;
    }

    protected String getDefaultColumnID(int aColumnIndex) {
        StringBuffer result = new StringBuffer();
        while (aColumnIndex >= 0) {
            result.append((char)((char)(aColumnIndex % 26) + 65));
            aColumnIndex = aColumnIndex / 26 - 1;
        }
        return result.toString();
    }

    protected static List convertToList(Object[][] aData) {
        if (aData != null) {
            ArrayList<List<Object>> result = new ArrayList<List<Object>>(aData.length);
            int i = 0;
            while (i < aData.length) {
                result.add(Arrays.asList(aData[i]));
                ++i;
            }
            return result;
        }
        return null;
    }

    protected boolean validateBounds(int aRowIndex, int aColumnIndex) {
        return this.validateRows(aRowIndex) && this.validateColumns(aColumnIndex);
    }

    protected boolean validateColumns(int aColumnIndex) {
        return aColumnIndex >= 0 && aColumnIndex < this.getColumnCount();
    }

    protected boolean validateRows(int aRowIndex) {
        return aRowIndex >= 0 && aRowIndex < this.getRowCount();
    }

    protected static void validateValue(int aValue, String aName) {
        if (aValue < 0) {
            throw new IllegalArgumentException("TableDataModel: " + aName + " can't be negative.");
        }
    }

    protected static void validateValue(Object aValue, String aName) {
        if (aValue == null) {
            throw new IllegalArgumentException("TableDataModel: " + aName + " can't be null.");
        }
    }

    protected static BitSet createDefaultEditBitSet() {
        BitSet column = new BitSet(32);
        return column;
    }

    protected static void generateExceptionOutOfBound(String aName) {
        throw new IllegalArgumentException("TableDataModel: index " + aName + " out of bounds.");
    }

    protected static class RowComparator
    implements Comparator {
        private Comparator fColumnComparator;
        private int fDataModelColumnIndex;
        private boolean fAscMode;

        public RowComparator(Comparator aColumnComparator, int aIndex, boolean aAsc) {
            this.fColumnComparator = aColumnComparator;
            this.fAscMode = aAsc;
            this.fDataModelColumnIndex = aIndex;
        }

        public int compare(Object aRow1, Object aRow2) {
            Object data1 = ((List)aRow1).get(this.fDataModelColumnIndex);
            Object data2 = ((List)aRow2).get(this.fDataModelColumnIndex);
            int result = this.fColumnComparator.compare(data1, data2);
            return this.fAscMode ? result : -result;
        }
    }
}

