
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{              Page options                }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_pgopt;

interface

{$I fr.inc}

uses
  SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, QComCtrls, fr_ctrls, QButtons;

type
  TfrPgoptForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    GroupBox2: TGroupBox;
    imgLandScape: TImage;
    imgPortrait: TImage;
    RB1: TRadioButton;
    RB2: TRadioButton;
    GroupBox1: TGroupBox;
    CB1: TCheckBox;
    GroupBox3: TGroupBox;
    ComB1: TComboBox;
    GroupBox4: TGroupBox;
    CB5: TCheckBox;
    E3: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    E4: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    E5: TEdit;
    E6: TEdit;
    GroupBox5: TGroupBox;
    Label7: TLabel;
    E7: TEdit;
    Label8: TLabel;
    Edit1: TEdit;
    Panel8: TPanel;
    SB1: TfrSpeedButton;
    SB2: TfrSpeedButton;
    CB2: TCheckBox;
    procedure RB1Click(Sender: TObject);
    procedure RB2Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SB1Click(Sender: TObject);
    procedure SB2Click(Sender: TObject);
  private
    { Private declarations }
    procedure Localize;
  public
    { Public declarations }
  end;


implementation

{$R *.xfm}

uses fr_prntr, fr_class, fr_const, fr_utils;

procedure TfrPgoptForm.RB1Click(Sender: TObject);
begin
  ImgPortrait.Show;
  ImgLandscape.Hide;
end;

procedure TfrPgoptForm.RB2Click(Sender: TObject);
begin
  ImgLandscape.Show;
  ImgPortrait.Hide;
end;

procedure TfrPgoptForm.FormActivate(Sender: TObject);
begin
  if RB1.Checked then RB1Click(nil) else RB2Click(nil);
end;

procedure TfrPgoptForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S53390;
  TabSheet1.Caption := S53391;
  GroupBox2.Caption := S53392;
  RB1.Caption := S53393;
  RB2.Caption := S53394;
  GroupBox3.Caption := S53395;
  TabSheet2.Caption := S53398;
  GroupBox4.Caption := S53399;
  Label3.Caption := S53400;
  Label4.Caption := S53401;
  Label5.Caption := S53402;
  Label6.Caption := S53403;
  CB5.Caption := S53404;
  TabSheet3.Caption := S53405;
  GroupBox1.Caption := S53406;
  CB1.Caption := S53407;
  CB2.Caption := S53413;
  GroupBox5.Caption := S53408;
  Label7.Caption := S53409;
  Label8.Caption := S53410;
  Button1.Caption := SOk;
  Button2.Caption := SCancel;
end;

procedure TfrPgoptForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

procedure TfrPgoptForm.SB1Click(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(Edit1.Text);
  Inc(i);
  Edit1.Text := IntToStr(i);
end;

procedure TfrPgoptForm.SB2Click(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(Edit1.Text);
  Dec(i);
  if i < 0 then i := 0;
  Edit1.Text := IntToStr(i);
end;

end.

