
{******************************************}
{                                          }
{   FastReport CLX v2.4 - DB components    }
{               SQL editor                 }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_dbsqledit;

interface

{$I fr.inc}


uses
  Types, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, fr_ctrls, DB
{$IFDEF MWEDIT}
, mwHighlighter, wmSQLSyn, mwCustomEdit, QButtons
{$ENDIF};

type
  TfrDBSQLEditorForm = class(TForm)
    MemoPanel: TPanel;
    Bevel2: TBevel;
    Panel2: TPanel;
    Panel1: TPanel;
    OkBtn: TfrSpeedButton;
    CancelBtn: TfrSpeedButton;
    OpenBtn: TfrSpeedButton;
    SaveBtn: TfrSpeedButton;
    Bevel1: TBevel;
    CutBtn: TfrSpeedButton;
    CopyBtn: TfrSpeedButton;
    PasteBtn: TfrSpeedButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SQLBtn: TfrSpeedButton;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure M1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
    procedure CutBtnClick(Sender: TObject);
    procedure CopyBtnClick(Sender: TObject);
    procedure PasteBtnClick(Sender: TObject);
    procedure OpenBtnClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
  private
    { Private declarations }
    procedure Localize;
  public
    { Public declarations }
{$IFDEF MWEDIT}
    M1: TmwCustomEdit;
{$ELSE}
    M1: TMemo;
{$ENDIF}
    Query: TDataSet;
  end;


implementation

uses fr_class, fr_const, fr_utils, Qt;

{$R *.xfm}


procedure TfrDBSQLEditorForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = key_Return) and (ssCtrl in Shift) then
  begin
    ModalResult := mrOk;
    Key := 0;
  end;
end;

procedure TfrDBSQLEditorForm.M1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = key_Escape then ModalResult := mrCancel;
end;

procedure TfrDBSQLEditorForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S57010;
  OpenBtn.Hint := S56099;
  SaveBtn.Hint := S56100;
  CutBtn.Hint := S53091;
  CopyBtn.Hint := S53092;
  PasteBtn.Hint := S53093;
  SQLBtn.Hint := S56101;
  OkBtn.Hint := (SOk);
  CancelBtn.Hint := (SCancel);
end;

procedure TfrDBSQLEditorForm.FormCreate(Sender: TObject);
{$IFDEF MWEDIT}
var
  SynParser: TwmSQLSyn;
{$ENDIF}
begin
  Localize;
{$IFDEF MWEDIT}
  M1 := TmwCustomEdit.Create(Self);
  SynParser := TwmSQLSyn.Create(Self);
  {$I *.inc}
{$ELSE}
  M1 := TMemo.Create(Self);
  M1.WordWrap := False;
{$ENDIF}
  M1.Parent := MemoPanel;
  M1.Align := alClient;
  M1.HelpContext := 20;
  M1.ScrollBars := ssNone;
  M1.Font.Name := 'Courier New';
  M1.Font.Size := 10;
  M1.OnKeyDOwn := M1KeyDown;
{$IFDEF MWEDIT}
  M1.Highlighter := SynParser;
  M1.Gutter.Visible := False;
{$ENDIF}

{$IFNDEF QBUILDER}
  SQLBtn.Visible := False;
{$ENDIF}
end;

procedure TfrDBSQLEditorForm.CancelBtnClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TfrDBSQLEditorForm.OkBtnClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TfrDBSQLEditorForm.CutBtnClick(Sender: TObject);
begin
  M1.CutToClipboard;
end;

procedure TfrDBSQLEditorForm.CopyBtnClick(Sender: TObject);
begin
  M1.CopyToClipboard;
end;

procedure TfrDBSQLEditorForm.PasteBtnClick(Sender: TObject);
begin
  M1.PasteFromClipboard;
end;

procedure TfrDBSQLEditorForm.OpenBtnClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
    M1.Lines.LoadFromFile(OpenDialog1.FileName);
end;

procedure TfrDBSQLEditorForm.SaveBtnClick(Sender: TObject);
begin
  if SaveDialog1.Execute then
    M1.Lines.SaveToFile(SaveDialog1.FileName);
end;

end.
