
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{               Tag editor                 }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_attre;

interface

{$I fr.inc}

uses
  SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, fr_class, fr_ctrls, fr_const;

type
  TfrAttrEditorForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    GB1: TGroupBox;
    Edit1: TfrComboEdit;
    procedure frSpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure Localize;
  public
    { Public declarations }
    procedure ShowEditor(t: TfrView);
  end;


implementation

{$R *.xfm}

uses fr_expr, fr_utils;


procedure TfrAttrEditorForm.ShowEditor(t: TfrView);
begin
  Edit1.Text := t.Tag;
  if ShowModal = mrOk then
  begin
    frDesigner.BeforeChange;
    t.Tag := Edit1.Text;
  end;
end;

procedure TfrAttrEditorForm.frSpeedButton1Click(Sender: TObject);
begin
  with TfrExprForm.Create(nil) do
  begin
    if ShowModal = mrOk then
      Edit1.SelText := ExprMemo.Text;
    Free;
  end;
end;

procedure TfrAttrEditorForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S53740;
  Edit1.ButtonHint := S53575;
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrAttrEditorForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

end.

