Attribute VB_Name = "modFunctions"
Option Explicit

Private Declare Function GetOpenFileName Lib "comdlg32.dll" Alias _
  "GetOpenFileNameA" (pOpenfilename As OPENFILENAME) As Long

Private Type OPENFILENAME
  lStructSize As Long
  hwndOwner As Long
  hInstance As Long
  lpstrFilter As String
  lpstrCustomFilter As String
  nMaxCustFilter As Long
  nFilterIndex As Long
  lpstrFile As String
  nMaxFile As Long
  lpstrFileTitle As String
  nMaxFileTitle As Long
  lpstrInitialDir As String
  lpstrTitle As String
  flags As Long
  nFileOffset As Integer
  nFileExtension As Integer
  lpstrDefExt As String
  lCustData As Long
  lpfnHook As Long
  lpTemplateName As String
End Type
       
Declare Function GetWindowsDirectory Lib "kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Global oReg As clsINIRegistry

Private Sub Command1_Click()
''''MSDN Example
        Dim OpenFile As OPENFILENAME
        Dim lReturn As Long
        Dim sFilter As String
        OpenFile.lStructSize = Len(OpenFile)
        'OpenFile.hwndOwner = Form1.hWnd
        OpenFile.hInstance = App.hInstance
        sFilter = "Batch Files (*.bat)" & Chr(0) & "*.BAT" & Chr(0)
        OpenFile.lpstrFilter = sFilter
        OpenFile.nFilterIndex = 1
        OpenFile.lpstrFile = String(257, 0)
        OpenFile.nMaxFile = Len(OpenFile.lpstrFile) - 1
        OpenFile.lpstrFileTitle = OpenFile.lpstrFile
        OpenFile.nMaxFileTitle = OpenFile.nMaxFile
        OpenFile.lpstrInitialDir = "C:\"
        OpenFile.lpstrTitle = "Use the Comdlg API not the OCX"
        OpenFile.flags = 0
        lReturn = GetOpenFileName(OpenFile)
        If lReturn = 0 Then
           MsgBox "The User pressed the Cancel Button"
        Else
           MsgBox "The user Chose " & Trim(OpenFile.lpstrFile)
        End If
End Sub

Public Function CommonOpenDialog(Optional Caption As String, _
                                Optional Filter As String, _
                                Optional InitialDirectory As String, _
                                Optional InitialFileName As String, _
                                Optional hWnd As Long _
                                ) As String
On Error GoTo ET:
    Dim OpenFile As OPENFILENAME
    Dim lReturn As Long
    Dim sFilter As String
    OpenFile.lStructSize = Len(OpenFile)
    If hWnd = 0 Then OpenFile.hwndOwner = Screen.ActiveForm.hWnd Else OpenFile.hwndOwner = hWnd
    OpenFile.hInstance = App.hInstance
    If Filter = "" Then sFilter = "All Files (*.*)" & vbNullChar & "*.*" & vbNullChar Else sFilter = Filter 'sFilter = "Batch Files (*.bat)" & Chr(0) & "*.BAT" & Chr(0)
    OpenFile.lpstrFilter = sFilter
    OpenFile.nFilterIndex = 1
    OpenFile.lpstrFile = String(257, 0)
    OpenFile.nMaxFile = Len(OpenFile.lpstrFile) - 1
    If InitialFileName <> "" Then Mid(OpenFile.lpstrFile, 1, Len(InitialFileName)) = InitialFileName
    OpenFile.lpstrFileTitle = OpenFile.lpstrFile
    OpenFile.nMaxFileTitle = OpenFile.nMaxFile
    If InitialDirectory = "" Then OpenFile.lpstrInitialDir = CurDir Else OpenFile.lpstrInitialDir = InitialDirectory
    If Caption = "" Then OpenFile.lpstrTitle = "Select File To Open" Else OpenFile.lpstrTitle = Caption
    OpenFile.flags = 0
    lReturn = GetOpenFileName(OpenFile)
    If lReturn = 0 Then 'The User pressed the Cancel Button
       CommonOpenDialog = ""
    Else
       CommonOpenDialog = sTrimNull(OpenFile.lpstrFile)
    End If
    Exit Function
ET:
    MsgBox "CommonOpenDialog:" & Err.Number & " - " & Err.Description, vbCritical
    Resume Next
End Function

Public Sub SetGlobalValues()
On Error GoTo ET
    Set oReg = New clsINIRegistry
    'If Dir(App.Path & "\aquabot.ini") = "" Then Err.Raise 3000, "Function: SetGlobalValues", App.Path & "\aquabot.ini not found"
    'oReg.FileName = App.Path & "\AquaBot.ini"
    'oReg.LoadINI
    Exit Sub
ET:
    MsgBox Err.Number & " - " & Err.Description
    End
    Exit Sub
End Sub

Public Function WinDir() As String
    Dim sRet As String '* 255
    sRet = String(255, vbNullChar)
    GetWindowsDirectory sRet, 255
    sRet = sTrimNull(sRet)
    WinDir = sFixPath(sRet)
End Function

Public Function sFixPath(ByVal sThePath As String) As String
   sThePath = Trim(sThePath)
   If (Right(sThePath, 1) = "\") Then
      sFixPath = sThePath
   Else
      sFixPath = sThePath & "\"
   End If
End Function

Public Function sTrimNull(ByVal InString As String) As String
Dim I As Integer, Tmp As String, Char As String
    For I = 1 To Len(InString)
        Char = Mid$(InString, I, 1)
        'If Asc(Char) <> 0 Then Tmp = Tmp & Char
        If Char <> vbNullChar Then Tmp = Tmp & Char
    Next I
    If Len(Tmp) > 0 Then sTrimNull = Tmp Else sTrimNull = InString
End Function

Public Function sTrim(ByVal sText, sChar)
Dim I As Integer, Tmp As String, Char As String
    For I = 1 To Len(sText)
        Char = Mid$(sText, I, 1)
        If Char <> sChar Then Tmp = Tmp & Char
    Next I
    If Len(Tmp) > 0 Then sTrim = Tmp
End Function

Public Sub WriteToFile(FileName As String, sLineBuffer As String)
Dim FileNumber
On Error GoTo err_Handler
    'If bLogActivated Then
        'If Dir(FileName) = "" Then 'Create new file and field names header
        '    FileNumber = FreeFile
        '    Open sLogFilePathName For Append Shared As #FileNumber
        '        Print #FileNumber, "Function|CalcID|TimeStamp|CalcType|System|InputAmount|InterestRate|BalloonAmt|NumberOfRepayments|LoanTermMonths|FinancialProduct|State|ReturnValue"
        '    Close #FileNumber
        'End If
        FileNumber = FreeFile
        Open FileName For Append Shared As #FileNumber
            Print #FileNumber, sLineBuffer
        Close #FileNumber
        Exit Sub
    'End If
    Exit Sub
err_Handler:
    'Err.Raise Err.Number, "Method: WriteToFile", Err.Description
    MsgBox Err.Description, vbCritical
    Exit Sub
End Sub

Public Function lFindLast(ByVal sSearch As String, ByVal sFor As String) As Long
On Error GoTo errHandler
    Dim lPtr As Long
    lPtr = InStr(sSearch, sFor)
    If lPtr Then lFindLast = lPtr + lFindLast(Mid(sSearch, lPtr + 1), sFor)
    Exit Function
errHandler:
    'Err.Raise 3000, "FindLast", Err.Description
    MsgBox Err.Description
End Function

Private Function Nz(ByVal Var As Variant, Optional ValueIfNull As Variant) As Variant
On Error GoTo errHandler
    If IsNull(Var) Then
        If IsMissing(ValueIfNull) Then
            Nz = 0
        Else
            Nz = ValueIfNull
        End If
    ElseIf Len(Trim$(Var)) = 0 Then
        If IsMissing(ValueIfNull) Then
            Nz = 0
        Else
            Nz = ValueIfNull
        End If
    Else
        If IsMissing(ValueIfNull) Then
            Nz = 0
        Else
            Nz = Var
        End If
    End If
    Exit Function
errHandler:
    'Err.Raise 3000, "NullToZero", Err.Description
    MsgBox Err.Description
End Function
