<?php
# vim: set expandtab tabstop=4 shiftwidth=4 nowrap: 
# ---------------------------------------------------------------------------
# ConPresso 3.x - Content Management
# ---------------------------------------------------------------------------
#       Datei/File:  /_user/edit.php
#    Beschr./Desc.:  Edit new user
#    Firma/Company:  Bartels Schoene GmbH & Co. KG
#                    Corrensstr. 80, 48149 Muenster, Germany
#              URL:  www.conpresso.de | www.bartels-schoene.de 
#     Autor/Author:  Tobias Musholt - musholt@bartels-schoene.de
#        Co-Author:  Thomas 'Balu' Walter - walter@bartels-schoene.de 
#                    Stefan Heitmann - heitmann@bartels-schoene.de
#                    Steffen Schoene - schoene@bartels-schoene.de
#                    Ralf Margott - margott@bartels-schoene.de (grafic)
#   Lizenz/Licence:  LICENCE.txt
#  Erstellt/Create:  21-02-2002 - Tobias Musholt
# Aenderung/Change:  25-02-2002 - Tobias Musholt: insert this programhead
#
# ---------------------------------------------------------------------------
# Copyright (c) 2001 - Bartels Schoene GmbH & Co. KG - All rights reserved.
# ---------------------------------------------------------------------------

if (file_exists("../_cfg/const.php")) require("../_cfg/const.php");
else require("../_cfg/const.php.dist");

    require("../_include/check.php");
    require("../_include/header.php");
    require("../_include/category.inc.php");

    echo "<div align=\"left\" class=\"header\">";
    echo "<b>".$LP_UserManagement."</b><br>";
    echo "</div><br>";
    echo $LP_UserEditText."<br>";
    echo "<br><br>";

    $user_text     = $LP_User.":";
    $email_text    = $LP_UserEMail.":";
    $name_text     = $LP_UserName.":";
    $passwd_1_text = $LP_UserPW1.":";
    $passwd_2_text = $LP_UserPW2.":";
    
    if ( !isset($enter) ) 
    {
        // Ausgabe der Userdaten
        $wert          = fkt_read_db($id);
        $user          = $wert[0];
        $edit_email    = $wert[1];
        $edit_initial  = $wert[2];
        $name          = $wert[3];
        $admin         = $wert[4];
        $passwd        = $wert[5];
        $user_language = $wert[6];

        require("_include/form_user_edit.php");
    } else {
        $query = "SELECT user FROM cpo_user WHERE user = '".$user."'";
        DEBUG(1, $query, __FILE__, __LINE__);
        $db = new db;
        $db->query($query);

        if ($db->num_rows()>0)
        {
            $user_text = "<font class=\"error\"><b>".$LP_User.":</b>";
            $error     = "<b>".$LP_User.":</b> ".$LP_UserExist."!<br>";
            $message   = $message.$error;
            $user      = '';
            $fehler    = '1';
        } else { 
            if ( $user == '' ) 
            {
                $user_text = "<font class=\"error\"><b>".$LP_User.":</b>";
                $error     = "<b>".$LP_User.":</b> ".$LP_UserMissing."!<br>";
                $message   = $message.$error;
                $fehler    = '1';
            } else {
                $user_text = $LP_User.":";
            }
        }

        if ( $edit_email != '' && is_email_valid($edit_email) != 1 ) 
        {
            $email_text = "<font class=\"error\"><b>".$LP_UserEMail.":</b>";
            $error      = "<b>".$LP_UserEMail.":</b> ".$LP_UserError."!<br>";
            $message    = $message.$error;
            $fehler     = '1';
            $edit_email      = '';
        } else {
            $email_text = $LP_UserEMail.":";
        }

        if ( $name == '' ) {
            $name_text = "<font class=\"error\"><b>".$LP_UserName.":</b>";
            $error     = "<b>".$LP_UserName.":</b> ".$LP_UserMissing."!<br>";
            $message   = $message.$error;
            $fehler    = '1';
        } else {
            $name_text = $LP_UserName.":";
        }

        if ( $passwd == '' || $passwd != $passwd2 ) 
        {
            $passwd_1_text = "<font class=\"error\"><b>".$LP_UserPW1.":</b>";
            $passwd_2_text = "<font class=\"error\"><b>".$LP_UserPW2.":</b>";
            $error         = "<b>".$LP_UserPW.":</b> ".$LP_UserError."!<br>";
            $message       = $message.$error;
            $fehler        = '1';
        } else {
            $passwd_1_text = $LP_UserPW1.":";
            $passwd_2_text = $LP_UserPW2.":";
        }

        if ( $fehler == '1' ) {

            require("../_include/message.php");
            
            require("_include/form_user_edit.php");

        } else {

            $c_datum = date ("Y-m-d H:m:i" ,time());
            $t_datum = date ("YmdHmi" ,time());

            $passwd_md5 = md5 ($passwd);
            
            // User anlegen!

            # echo "ADMIN: ".$admin."<br>";

            $query = "INSERT INTO cpo_user (id, user, name, initial, email, language, admin, passwd, timestamp, c_time, changer) values (\"".$id."\", \"".ucfirst($user)."\", \"".$name."\", \"".$edit_initial."\", \"".$edit_email."\", \"".$user_language."\", \"".$admin."\", \"".$passwd_md5."\", \"".$t_datum."\", \"".$c_datum."\", \"".$SID_login."\")";
            DEBUG(1, $query, __FILE__, __LINE__);
            $db = new DB;
            $db->query($query); 

            $query = "SELECT id FROM cpo_user WHERE id = LAST_INSERT_ID() "; 
            DEBUG(2, $query, __FILE__, __LINE__);   
            $db = new DB;
            $db->query($query); 
            if ($db->num_rows()>0)
            { 
                while($db->next_record()):
                    if ( $db->v("id") != '' )
                    {
                        $id =  $db->v("id");
                        // echo "ID: ".$id."<br>";
                    }
                endwhile;
            } else { 
                echo "<b><font class=\"error\">UPS: Dieser Fehler [user/edit.php] h&auml;tte nicht Auftauchen d&uuml;rfen!</font></b><br>\n";
            }

            $error = "<br>".$LP_UserDB_OK."<br><br>\n";
            $message = $message.$error;

            $error = "<img src=\"../_images/db_ani.gif\" height=\"20\" width=\"15\" alt=\"".$LP_UserDB_OK."\" border=\"0\"><br><br>\n";
            $message = $message.$error;

            $xtitel = substr($xtitel, 0, 20);
            $xuntertitel = substr($xuntertitel, 0, 20);
            $zeile1 = ucfirst($user)." | ".$name." \n";

            fkt_log($SID_login, $LOG_UserEnter2, $zeile1);

            // Ausgabe der Userdaten
            $wert          = fkt_read_db($id);
            $user          = $wert[0];
            $edit_email    = $wert[1];
            $edit_initial  = $wert[2];
            $name          = $wert[3];
            $admin         = $wert[4];
            $passwd        = $wert[5];
    
            if ( $SID_level >= 3 && $admin != 0 ) 
            {
                $release = "<br>".$LP_UserRightsNew." <a href='permission.php?id=".$id."&user=".$user."' target='_self'><b>".$LP_UserRights."</b></a> ".$LP_UserRightsNew2."\n";
            } 

            $message = "\n".$LP_MessageSuccess."<br>".$release;
            require("../_include/message.php");        
            
            require("_include/form_user.php");

        }
    }
    
    require("../_include/footer.php");
    
?>
