<?php
# vim: set expandtab tabstop=4 shiftwidth=4 nowrap: 
# ---------------------------------------------------------------------------
# ConPresso 3.x - Content Management
# ---------------------------------------------------------------------------
#       Datei/File:  /_include/system_const.php
#    Beschr./Desc.:  
#    Firma/Company:  Bartels Schoene GmbH & Co. KG
#                    Corrensstr. 80, 48149 Muenster, Germany
#              URL:  www.conpresso.de | www.bartels-schoene.de 
#     Autor/Author:  Tobias Musholt - musholt@bartels-schoene.de
#        Co-Author:  Thomas 'Balu' Walter - walter@bartels-schoene.de 
#                    Stefan Heitmann - heitmann@bartels-schoene.de
#                    Steffen Schoene - schoene@bartels-schoene.de
#                    Ralf Margott - margott@bartels-schoene.de (grafic)
#   Lizenz/Licence:  LICENCE.txt
#  Erstellt/Create:  01-03-2002 - Tobias Musholt
# Aenderung/Change:  
#
# ---------------------------------------------------------------------------
# Copyright (c) 2001 - Bartels Schoene GmbH & Co. KG - All rights reserved.
# ---------------------------------------------------------------------------

    ini_set("magic_quotes_gpc", "1");

    $query = "SELECT * FROM cpo_option WHERE id != ''";
    DEBUG(2, $query, __FILE__, __LINE__);   
    $db = new DB;
    $db->query($query);

    if ($db->num_rows()>0)
    { 
        while($db->next_record()):
        
            $System_project         = $db->v("project");
            $System_release         = $db->v("release");
            $System_release_email   = $db->v("release_email");
            $System_system_email    = $db->v("system_email");
            $System_admin_email     = $db->v("admin_email");
            $System_timeout         = $db->v("timeout");
            $System_max_image       = $db->v("max_image");
            $System_max_file        = $db->v("max_file");
            $System_article_width   = $db->v("article_width");
            $lang                   = $db->v("language");
            $System_base_url        = $db->v("base_url");
            $System_send_pw         = $db->v("send_pw");
            $System_Help            = $db->v("help");
            $System_Startnews       = $db->v("startnews");
            $System_lkey            = $db->v("lkey");
            $System_owner           = $db->v("owner");
            $System_target          = $db->v("target");

        endwhile;
    } else {
        $System_project         = 'ConPresso';
        $System_release         = 0;
        $System_release_email   = 0;
        $System_system_email    = 'MAILER@example.com';
        $System_admin_email     = 'ADMIN@example.com';
        $System_timeout         = '1440';
        $System_max_image       = '150000';
        $System_max_file        = '2000000';
        $System_article_width   = '100%';
        $lang                   = 'deutsch';
        $System_base_url        = 'NO_BASE-URL';
        $System_send_pw         = 0;
        $System_Help            = 1;
        $System_Startnews       = 1;
        $System_lkey            = '';
        $System_owner           = '';
        $System_target          = '';
    }
    
    if ( $SID_language != '' && $logout == '' ) {
        require("../_include/lang/".$SID_language.".php");
    } else {
        require("../_include/lang/".$lang.".php");
    }

    require("../_include/log_language.php");

    $conpresso          = $LP_ConPresso;
    $title              = "$LP_ConPresso  Content Management by Bartels.Sch&ouml;ne";
    $titlename          = "Con<i>Presso</i>";
    $titlenameVersion   = "Con<i>Presso</i> 3.3";
    $copyright          = "Copyright &copy; 2000-2002";
    $webpubishing       = "Bartels.Sch&ouml;ne";
    $WIDTH              = "760";

    $freigabe_email     = 1;

    // Conpresso
    $ns_text            = "#444444";        # (#444444)
    $ns_link            = "#750077";        # (#750077)
    $ns_alink           = "#007500";        # (#007500)
    $ns_vlink           = "#AA0000";        # (#AA0000)
    $ns_background      = "#ffffff";        # (#ffffff)
    $ns_frame           = "#B6C3EE";        # (#B6C3EE)

    $ns_margin_top      = 0;
    $ns_margin_left     = 0;

    // Farben
    $color_data_dunkel  = "#00264F";        # (#00264F) Datenhintergrund: sehr dunkel-blau
    $color_dunkel_blue  = "#BAC8D6";        # (#BAC8D6) Tabellenhintergrund: dunkel-blau 
    $color_tbg_dunkel   = "#D2DBE4";        # (#D2DBE4) Tabellenhintergrund: dunkel-blau
    $color_tbg_hell     = "#EAEEF3";        # (#EAEEF3) Tabellenhintergrund: hell-blau
    $color_data_hell    = "#F4F7F9";        # (#F4F7F9) Datenhintergrund: sehr hell-blau
    $color_white        = "#FFFFFF";        # (#FFFFFF) weiss
    $color_orange       = "#E6A236";        # (#E6A236) orange
    $color_green2       = "#83B647";        # (#83B647) gruen

    $color_red          = "#F8E4C4";        # (#F8E4C4) Tabellenhintergrund: hell-rot
    $color_green        = "#DFEDCF";        # (#DFEDCF) Tabellenhintergrund: hell-gruen
    $color_grey         = "#DDDDDD";        # (#DDDDDD) Tabellenhintergrund: hell-grau
    $color_grey2        = "#F4F4F4";        # (#F4F4F4) Tabellenhintergrund: sehr hell-grau

    // Farben
    $color_black        = "#000000";        # (#000000) Tabellenhintergrund: black

?>