<?php
# vim: set expandtab tabstop=4 shiftwidth=4 nowrap: 
# ---------------------------------------------------------------------------
# ConPresso 3.x - Content Management
# ---------------------------------------------------------------------------
#       Datei/File:  /_include/function.php
#    Beschr./Desc.:  
#    Firma/Company:  Bartels Schoene GmbH & Co. KG
#                    Corrensstr. 80, 48149 Muenster, Germany
#              URL:  www.conpresso.de | www.bartels-schoene.de 
#     Autor/Author:  Tobias Musholt - musholt@bartels-schoene.de
#        Co-Author:  Thomas 'Balu' Walter - walter@bartels-schoene.de 
#                    Stefan Heitmann - heitmann@bartels-schoene.de
#                    Steffen Schoene - schoene@bartels-schoene.de
#                    Ralf Margott - margott@bartels-schoene.de (grafic)
#   Lizenz/Licence:  LICENCE.txt
#  Erstellt/Create:  21-02-2002 - Tobias Musholt
# Aenderung/Change:  25-02-2002 - Tobias Musholt: insert this programhead
#                    15-10-2002 - Tobias Musholt: magic_quotes_gpc
#
# ---------------------------------------------------------------------------
# Copyright (c) 2001 - Bartels Schoene GmbH & Co. KG - All rights reserved.
# ---------------------------------------------------------------------------


    # tree_del()
    function tree_del($id) 
    {
        global $LP_ST_del;
    
        $query = "SELECT * FROM cpo_tree WHERE parent = ".$id." ";
        DEBUG(2, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);

        if ($db->num_rows()>0)
        { 
            # echo " ";
        } else {
            echo "&nbsp;| <A HREF=\"tree.php?id=".$id."&del=1\">".$LP_ST_del."</A>";
        }
    }

    # tree()
    function tree($parent,$lev) 
    {
        global $LP_ST_add;
        
        $query = "SELECT * FROM cpo_tree WHERE parent = ".$parent." ORDER BY description";
        DEBUG(2, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);

        $lev++;
        $pre_blank = '';

        if ( $lev > 0 ) {
            for ($i = 1; $i <= ($lev); $i++) {
                $pre_blank .= " &nbsp; &nbsp; &nbsp;";
            }
            $pre_blank .= " ";
        }
        
        if ($db->num_rows()>0)
        { 
            while($db->next_record()):

                $id             = $db->v("id");
                $description    = $db->v("description");
                $parent         = $db->v("parent");

                echo "<tr><td align=\"left\" valign=\"middle\" class=\"text\"><b>".$pre_blank."</b><A HREF=\"tree_change.php?id=".$id."&description=".$description."\">".$description."</A> &nbsp; </td>";
                echo "<td align=\"left\" valign=\"middle\" class=\"text\"><A HREF=\"tree.php?id=".$id."&new=1\">".$LP_ST_add."</A></td>";
                echo "<td align=\"left\" valign=\"middle\" class=\"text\">";
                tree_del($id);
                echo "</td>";
                echo "</tr>";

                tree($id,$lev);
            endwhile;

        } else {
            # echo "Keine Strukturteil vorhanden!<br>";
        }
    }

    # tree()
    function tree_preference($parent,$lev,$name,$zuordnung_alt) 
    {
        global $LP_ST_add;
        
        $query = "SELECT * FROM cpo_tree WHERE parent = ".$parent." ORDER BY description";
        DEBUG(2, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);

        $lev++;
        $pre_blank = '';

        if ( $lev > 0 ) {
            for ($i = 1; $i <= ($lev); $i++) {
                $pre_blank .= " ";
            }
            $pre_blank .= " ";
        }
        
        if ($db->num_rows()>0)
        { 
            while($db->next_record()):

                $id             = $db->v("id");
                $description    = $db->v("description");
                $parent         = $db->v("parent");

                if ( $id == $zuordnung_alt ) {
                    echo "<option value=\"".$id."\" selected>".$name.$description." (".$id.")</option>\n";
                } else {
                    echo "<option value=\"".$id."\">".$name.$description." (".$id.")</option>\n";
                }
                $name2 = $name.$description."/";
                tree_preference($id,$lev,$name2,$zuordnung_alt);
            endwhile;

        } else {
            # echo "Keine Strukturteil vorhanden!<br>";
        }
    }

    # tree_select()
    function tree_select($parent,$lev,$this_id) 
    {
        global $color_tbg_dunkel;
        $query = "SELECT * FROM cpo_tree WHERE parent = ".$parent." ORDER BY description";
        DEBUG(2, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);

        $lev++;
        $pre_blank = '';

        if ( $lev > 0 ) {
            for ($i = 1; $i <= ($lev); $i++) {
                $pre_blank .= "<img src=\"../_images/transparent.gif\" width=\"8\" height=\"10\" alt=\"\" border=\"0\">";
            }
        }
        
        if ($db->num_rows()>0)
        { 
            while($db->next_record()):

                $id             = $db->v("id");
                $description    = $db->v("description");
                $parent         = $db->v("parent");
                
                tree_free($id);

                if ( tree_check($id) == 0 || tree_check_user($id) == 0 ) { 
                    if ( tree_free($id) == 1 ) {
                        echo "<tr><td align=\"left\" valign=\"middle\" class=\"textgrey\"><b>".$pre_blank." ".$description."</b> &nbsp; </td></tr>\n";
                    }
                } else {
                    # echo "id: ".$id."<br>";
                    # echo "this_id: ".$this_id."<br>";
                    if ( $id == $this_id ) {
                        echo "<tr><td bgcolor=\"".$color_tbg_dunkel."\" align=\"left\" valign=\"middle\" class=\"text\"><nobr><b>".$pre_blank."</b><A HREF=\"".$PHP_SELF."?id=".$id."\"> ".$description."</A> &nbsp; </nobr></td></tr>\n";
                    } else {
                        echo "<tr><td align=\"left\" valign=\"middle\" class=\"text\"><nobr><b>".$pre_blank."</b><A HREF=\"".$PHP_SELF."?id=".$id."\"> ".$description."</A> &nbsp; </nobr></td></tr>\n";
                    }
                }

                tree_select($id,$lev,$this_id);

            endwhile;

        } else {
            # echo "Keine Strukturteil vorhanden!<br>";
        }
    }


    # tree_free()
    function tree_free($parent) 
    {
        $query = "SELECT * FROM cpo_tree WHERE parent = ".$parent." ORDER BY description";
        DEBUG(2, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);

        if ($db->num_rows()>0)
        { 
            while($db->next_record()):
                $id = $db->v("id");
                tree_free($id);

                if ( tree_check_user($id) == 1 ) {
                    return 1;
                    # echo "<b>Zweig belegt!</b><br>";
                } 
                
            endwhile;

        } else {
            # echo "Keine weitere Strukturteil vorhanden!<br>";
        }
    }


    # tree_check()
    function tree_check($id) 
    {
        $query = "SELECT * FROM cpo_rubric WHERE zuordnung = ".$id;
        DEBUG(2, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);

        if ($db->num_rows()>0)
        { 
            return 1;
        } else {
            return 0;
        }
    }


    # tree_check_user()
    function tree_check_user($id) 
    {
        global $SID_user_id;
        
        $query = "SELECT * FROM cpo_permission WHERE zuordnung = ".$id." && user_id = ".$SID_user_id;
        DEBUG(2, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);

        if ($db->num_rows()>0)
        { 
            return 1;
        } else {
            return 0;
        }
    }


    # DEBUG()
    function DEBUG($buglevel,$query,$file,$line) 
    {
        global $varDEBUG;
        
        if ( $varDEBUG != 0 && ( $buglevel <= $varDEBUG || $varDEBUG > 4 ) ) { 
            $string = "<div align='left' class='debug'>\n"; 
            $string.= "<b><u>DEBUG in ".$file." at line ".$line.":</u></b><br>\n"; 
            $string.= $query."<br>\n"; 
            $string.= "</div><br>\n"; 
            echo $string;
        }
        return 0;
    }

    # autor_name()
    function autor_name($autor) 
    {
        $query = "SELECT * FROM cpo_user WHERE user = '".$autor."'";
        DEBUG(2, $query, __FILE__, __LINE__);   
        $db2 = new DB;
        $db2->query($query);

        if ($db2->num_rows()>0)
        {
            while($db2->next_record()):
                $name = $db2->v("name");
            endwhile;
        } else {
            $name = $autor;
        }
        return $name;
    }


    # autor_name()
    function check_artikel_show($output_text) 
    {
        $output_text_1 = strip_tags($output_text_1);
        $output_text_1 = substr($output_text_1, 0, 195);
        $output_text_1 = ereg_replace ( "<ta", "<!--<ta", $output_text_1);
        $output_text_1 = ereg_replace ( "<TA", "<!--<TA", $output_text_1);
        $output_text_1 = ereg_replace ( "<Ta", "<!--<Ta", $output_text_1);

        $text_1_len = strlen($output_text_1);

        if ( strlen($output_text_1) >= 195 )  
        {
            if ( $text_1_len == strlen($output_text_1) )
            {
                $output_text_1 = $output_text_1."...<br>";
            } else {
                $output_text_1 = $output_text_1."-->...<br>";
            }
        }

        return $output_text;
    }

    
    # check_string()
    function check_string($string) 
    {
        global $System_base_url;
        # $string = ereg_replace ( SID, "", $string);
        if ( $string == "<P>&nbsp;</P>" ) {
            $string = '';
        }
        $string = stripslashes($string); 
        $string = ereg_replace ( "'", "\\'", $string);
        $string = ereg_replace ( "\"", "\\\"", $string);
        
        $string = ereg_replace("\"".$System_base_url, "\"../", $string);

        return $string;
    }


    # check_string_strip()
    function check_string_strip($string) 
    {
        global $System_base_url;
        $string = strip_tags($string);
        # $string = ereg_replace ( SID, "", $string);
        $string = stripslashes($string); 
        $string = ereg_replace ( "'", "\\'", $string);
        $string = ereg_replace ( "\"", "\\\"", $string);

        $string = ereg_replace("\"".$System_base_url, "\"../", $string);

        return $string;
    }


    # check_string_template()
    function check_string_template($string) 
    {
        $string = ereg_replace ( "</PRE><PRE>", "\015\012", $string);
        $string = ereg_replace ( "<P>", "", $string);
        $string = ereg_replace ( "</P>", "\015\012\015\012", $string);
        $string = ereg_replace ( "<PRE>", "", $string);
        $string = ereg_replace ( "</PRE>", "", $string);
        $string = ereg_replace ( "&nbsp;", " ", $string);
        $string = ereg_replace ( "<BR>", "\015\012", $string);
        $string = ereg_replace ( "<FONT color=#ff0000>", "", $string);
        $string = ereg_replace ( "</FONT>", "", $string);

        $string = strip_tags($string);

        $string = ereg_replace ( "&gt;", ">", $string);
        $string = ereg_replace ( "&lt;", "<", $string);
        $string = ereg_replace ( "&amp;", "&", $string);
        # $string = ereg_replace ( '"', '\"', $string);
        return $string;
    }


    # check_string_snippet()
    function check_string_snippet($string) 
    {
        $string = ereg_replace ( "</PRE><PRE>", "\015\012", $string);
        $string = ereg_replace ( "<P>", "", $string);
        $string = ereg_replace ( "</P>", "\015\012\015\012", $string);
        $string = ereg_replace ( "<PRE>", "", $string);
        $string = ereg_replace ( "</PRE>", "", $string);
        $string = ereg_replace ( "&nbsp;", " ", $string);
        $string = ereg_replace ( "<BR>", "\015\012", $string);
        $string = ereg_replace ( "<FONT color=#ff0000>", "", $string);
        $string = ereg_replace ( "</FONT>", "", $string);

        $string = strip_tags($string);

        $string = ereg_replace ( "&gt;", ">", $string);
        $string = ereg_replace ( "&lt;", "<", $string);
        $string = ereg_replace ( "&amp;", "&", $string);
        # $string = ereg_replace ( '"', '\"', $string);
        return $string;
    }


    # help()
    function help($id) 
    {
        global $LP_Help;
        global $SID_language;
        global $lang;
        global $System_Help;
        if ( $SID_language != '' ) {
            $lang = $SID_language;
        }
        if ( $System_Help == 1 ) 
        {
            echo "<img src=\"../_images/transparent.gif\" align=\"absmiddle\" alt=\"\" width=\"3\" height=\"1\" border=\"0\"><A href=\"javascript:void(0);\" onFocus=\"if (this.blur) this.blur()\" onclick=\"window.open('../_content/help.php?id=".$id."&language=".$lang."','".$id."','width=400,height=300,scrollbars=1');\"><img src=\"../_images/help.gif\" align=\"absmiddle\" alt=\"".$LP_Help."\" border=\"0\"></A>";
        }
    }


    # fkt_search(Column, String)
    function fkt_search($sqlColumn,$search) 
    {
        $searchExploded = explode(" ", $search);
        for ($i=0; $i<count($searchExploded); $i++) {
    
            # empty word? e.g. two spaces or "just one letter" (esp. "+" or "-" ;)
            # -> ignore that
            if (strlen($searchExploded[$i]) <= 1) {
                continue;
            }
    
            # check for "-"=not and "+"=and (default is or)
            if (substr($searchExploded[$i], 0, 1) == '-') {
                $sqltmp = " AND ".$sqlColumn." NOT LIKE ";
                $searchExploded[$i] = substr($searchExploded[$i], 1);
    
            } elseif (substr($searchExploded[$i], 0, 1) == '+') {
                $sqltmp = " AND ".$sqlColumn." LIKE ";
                $searchExploded[$i] = substr($searchExploded[$i], 1);
    
            } else {
                # default could be or, but that makes the search display everything
                # the "word" is included in (even if one should NOT ("-") be displayed)
                # -> changed to AND
                $sqltmp = " AND ".$sqlColumn." LIKE "; 
            }
    
            # replace special chars:
            if (!get_magic_quotes_gpc()) $searchExploded[$i] = addslashes($searchExploded[$i]);
            $searchExploded[$i] = str_replace("%", "\%", $searchExploded[$i]);
            # might not be complete!    
        
            $sqlWhere = $sqlWhere.$sqltmp."'%".$searchExploded[$i]."%'";
        }
    
        # remove first AND or OR
        if (substr($sqlWhere, 0, 3) == " OR")
            $sqlWhere = substr($sqlWhere, 3);
        if (substr($sqlWhere, 0, 4) == " AND")
            $sqlWhere = substr($sqlWhere, 4);
    
        # echo "SELECT * FROM news WHERE ".$sqlWhere.";\n";
        return $sqlWhere;    
    }


    # fkt_browser_check(User, Aktion, Bemerkung)
    function fkt_browser_check($HTTP_USER_AGENT) 
    {
        if (strpos($HTTP_USER_AGENT, "MSIE"))
        {
            $ar = explode("MSIE ", $HTTP_USER_AGENT);
            $ar = explode(" ", $ar[1]);
            $ar = explode(";", $ar[0]);
            if ($ar[0] >= 5)
            {
                $agent = "MSIE younger than version 5";
                return 1;
            } else {
                $agent = "MSIE older than version 5";
                return 0;
            }
        } elseif (strpos("a" . $HTTP_USER_AGENT, "Mozilla")) {
            # weil 0 und falsch gleich sind
            $ar = explode("Mozilla/", $HTTP_USER_AGENT);
            $ar = explode(" ", $ar[1]);
            if ($ar[0] < 6)
            {
                $agent = "netscape younger than version 6";
                return 0;
            } else {
                $agent = "netscape older than version 6";
                return 0;
            }
        }
    }


    # Eintrag in die Log-Tabelle
    # fkt_log(User, Aktion, Bemerkung)
    function fkt_log($arg_1, $arg_2, $arg_3) 
    {
        $jetzt = date(time());

        $c_datum = date ( "Y-m-d H:m:i" ,time() );
        $t_datum = date ( "YmdHmi" ,time() );

        $arg_1 = ereg_replace ( "\"", "\\\"", $arg_1);
        $arg_1 = ereg_replace ( "'", "\\'", $arg_1);

        $arg_2 = ereg_replace ( "\"", "\\\"", $arg_2);
        $arg_2 = ereg_replace ( "'", "\\'", $arg_2);

        $arg_3 = ereg_replace ( "\"", "\\\"", $arg_3);
        $arg_3 = ereg_replace ( "'", "\\'", $arg_3);

        $query = "insert into cpo_log (id, user, datum, aktion, bemerkung, timestamp, c_time, changer) values (\"".$id."\", \"".$arg_1."\", \"".$jetzt."\", \"".$arg_2."\", \"".$arg_3."\", \"".$t_datum."\", \"".$c_datum."\", \"".$SID_login."\")";
        # DEBUG(2, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query); 

    }


    # fkt_read_db(ID)
    function fkt_read_db($arg_1) 
    {
        $query = "SELECT * FROM cpo_user WHERE id = '".$arg_1."' ORDER BY user";
        DEBUG(2, $query, __FILE__, __LINE__);   
        $db = new db;
        $db->query($query);

        if ($db->num_rows()>0)
        {
            while($db->next_record()):

                if ( $db->v("user") != '' ) {
                    $user = $db->v("user");
                }

                if ( $db->v("email") != '' ) {
                    $email = $db->v("email");
                }

                if ( $db->v("initial") != '' ) {
                    $initial = $db->v("initial");
                }

                if ( $db->v("name") != '' ) {
                    $name = $db->v("name");
                }
                
                if ( $db->v("admin") != '' ) {
                    $admin = $db->v("admin");
                }
                
                if ( $db->v("passwd") != '' ) {
                    $passwd = $db->v("passwd");
                }

                if ( $db->v("language") != '' ) {
                    $user_language = $db->v("language");
                }
                
            endwhile;
            return array ($user, $email, $initial, $name, $admin, $passwd, $user_language);
        } else { 
            echo $LP_NoUser;
        }
        return 0;
    }

    # is_email_valid(eMail)
    function is_email_valid($email) 
    {
        if(eregi("^[a-z0-9\._-]+@+[a-z0-9\._-]+\.+[a-z]{2,3}$", $email)) return TRUE; 
        else return FALSE; 
    }

?>
