<?php
# vim: set expandtab tabstop=4 shiftwidth=4 nowrap: 
# ---------------------------------------------------------------------------
# ConPresso 3.x - Content Management
# ---------------------------------------------------------------------------
#       Datei/File:  /_include/check_edit.php
#    Beschr./Desc.:  
#    Firma/Company:  Bartels Schoene GmbH & Co. KG
#                    Corrensstr. 80, 48149 Muenster, Germany
#              URL:  www.conpresso.de | www.bartels-schoene.de 
#     Autor/Author:  Tobias Musholt - musholt@bartels-schoene.de
#        Co-Author:  Thomas 'Balu' Walter - walter@bartels-schoene.de 
#                    Stefan Heitmann - heitmann@bartels-schoene.de
#                    Steffen Schoene - schoene@bartels-schoene.de
#                    Ralf Margott - margott@bartels-schoene.de (grafic)
#   Lizenz/Licence:  LICENCE.txt
#  Erstellt/Create:  21-02-2002 - Tobias Musholt
# Aenderung/Change:  25-02-2002 - Tobias Musholt: insert this programhead
#                    28-02-2002 - Tobias Musholt: Titel/Untertile-Check entfernt
#
# ---------------------------------------------------------------------------
# Copyright (c) 2001 - Bartels Schoene GmbH & Co. KG - All rights reserved.
# ---------------------------------------------------------------------------

    $pub_text = $LPR_Publication.":";
    $verfall_text = $LPR_PurgeDate.":";
    
    $datum = time();
    $jetzt = date( "d.m.Y H:i:s", $datum );
    
    if ( $verfall_tag == '' && $verfall_monat == '' && $verfall_jahr == '' && $verfall_stunde == '' && $verfall_minute == '' && $verfall == '' )
    {
        $verfall = 12000;
    }
    
    if ( $kategorie == '' )
    {
        $kategorie_text = "<font class=\"error\"><b>".$LPR_Rubric.":</b></font>";
        $error = "[".$LPR_Rubric.":] ".$LP_Missing."!<br>";
        $message = $message.$error;
        $fehler = 1;
    } else {
        $kategorie_text = $LPR_Rubric.":";
    }
    
    if ( $autor == '' )
    {
        $autor_text = "<font class=\"error\"><b>".$LPR_Author.":</b></font>";
        $error = "<b>".$LPR_Author.":</b> ".$LP_Missing."!<br>";
        $message = $message.$error;
        $fehler = 1;
    } else {
        $autor_text = $LPR_Author.":";
    }

    if ( $template == '' )
    {
        $template_text = "<font class=\"error\"><b>".$LPR_Template.":</b></font>";
        $error = "<b>".$LPR_Template.":</b> ".$LP_Missing."!<br>";
        $message = $message.$error;
        $fehler = 1;
    } else {
        $template_text = $LPR_Template.":";
    }
    
# Toby: 2002-02-28
#    if ( $titel == '' && $untertitel == '' )
#    {
#        $titel_text = "<font class=\"error\"><b>".$LPR_Title.":</b></font>";
#        $untertitel_text = "<font class=\"error\"><b>".$LPR_Subtitle.":</b></font>";
#        $error = "<b>".$LPR_Title." oder ".$LPR_Subtitle.":</b> ".$LP_Missing."!<br>";
#        $message = $message.$error;
#        $fehler = 1;
#    } else {
#        $titel_text = $LPR_Title.":";
#        $untertitel_text = $LPR_Subtitle.":";
#    }
    
    $check_verfall = checkdate($verfall_monat, $verfall_tag, $verfall_jahr);
    
    if ( $verfall_jahr >= 2036 || $verfall_jahr < 1970 )
    {
        $error = "<b>".$LPR_PurgeDate.":</b> ".$LP_FailureYear."!<br>";
        $message = $message.$error;
        $check_verfall = '';
    }
    
    if ( $verfall_stunde >= 24 || $verfall_stunde < 0 )
    {
        $error = "<b>".$LPR_PurgeDate.":</b> ".$LP_FailureHour."!<br>";
        $message = $message.$error;
        $check_verfall = '';
    }
    
    if ( $verfall_minute >= 60 || $verfall_minute < 0 )
    {
        $error = "<b>".$LPR_PurgeDate.":</b> ".$LP_FailureMin."!<br>";
        $message = $message.$error;
        $check_verfall = '';
    }
    
    $check_pub = checkdate($pub_datum_monat, $pub_datum_tag, $pub_datum_jahr);
    
    if ( $pub_datum_jahr >= 2036 || $pub_datum_jahr < 1970 ) 
    {
        $error = "<b>".$LPR_Publication.":</b> ".$LP_FailureYear."!<br>";
        $message = $message.$error;
        $check_pub = '';
    }
    
    if ( $pub_datum_stunde >= 24 || $pub_datum_stunde < 0 ) 
    {
        $error = "<b>".$LPR_Publication.":</b> ".$LP_FailureHour."!<br><br>";
        $message = $message.$error;
        $check_pub = '';
    }
    
    if ( $verfall_minute >= 60 || $verfall_minute < 0 ) {
        $error = "<b>".$LPR_Publication.":</b> ".$LP_FailureMin."!<br>";
        $message = $message.$error;
        $check_pub = '';
    }
    
    if ( $pub == '') 
    {
        if ($check_pub == '1')
        {
            $pub_datum = mktime ($pub_datum_stunde, $pub_datum_minute,0,$pub_datum_monat, $pub_datum_tag, $pub_datum_jahr);
            $pub = date( "d.m.Y H:i", $pub_datum);
    
            // if ( $datum >= $pub_datum+3600 )
            // {
            //     $error = "<b>".$LPR_Publication.":</b> ".$LP_FailurePubDate."!<br>";
            //     $message = $message.$error;
            //     $pub_datum = $datum;
            //     $fehler = 1;
            //     $pub_text = "<font class=\"error\"><b>".$LPR_Publication.":</b></font>";
            // }
            
        } else {
            $error = "<b>".$LPR_Publication.":</b> ".$LP_FailureDate."!<br>";
            $message = $message.$error;
            $pub_datum = $datum;
            $fehler = 1;
            $pub_text = "<font class=\"error\"><b>".$LPR_Publication.":</b></font>";
        }
    } else {
        if ( $pub == 'now' )
        {
            // $pub_datum = mktime ( date('H'), date('i'),0,date('m'), date('d')+$pub, date('Y'));
            $pub_datum = mktime ( date('H'), date('i'),0 ,date('m'), date('d'), date('Y'));
            $pub = date( "d.m.Y H:i", $pub_datum);
        } else {
            // $pub_datum = mktime ( date('H'), date('i'),0,date('m'), date('d')+$pub, date('Y'));
            $pub_datum = mktime ( 0,1,0,date('m'), date('d')+$pub, date('Y'));
            $pub = date( "d.m.Y H:i", $pub_datum);
        }
    }
    
    if ( $verfall == '')
    {
        if ($check_verfall == '1')
        {
            $verfallsdatum = mktime ($verfall_stunde, $verfall_minute,0,$verfall_monat, $verfall_tag, $verfall_jahr);
            $verfall = date( "d.m.Y H:i", $verfallsdatum);
    
            if ( $pub_datum > $verfallsdatum )
            {
                $error = "<b>".$LPR_PurgeDate.": </b>".$LP_FailurePurDate."!<br>";
                $message = $message.$error;
                $verfallsdatum = $pub_datum+2592000;
                $fehler = 1;
                $verfall_text = "<font class=\"error\"><b".$LPR_PurgeDate.":</b></font>";
            }
        } else {
            $error = "<b>".$LPR_PurgeDate.": </b>".$LP_FailureDate."!<br>";
            $message = $message.$error;
            $verfallsdatum = $datum+2592000;
            $fehler = 1;
            $verfall_text = "<font class=\"error\"><b>".$LPR_PurgeDate.":</b></font>";
        }
    } else {
        if ( $verfall == 'nie' )
        {
            $verfallsdatum = mktime (23,59,0,12,31,2036);
        } else {
            if ( $verfall == 'now' )
            {
                $verfallsdatum = mktime (date('H'), date('i'),0,date('m'), date('d')+$verfall, date('Y'));
            } else {
                $verfallsdatum = mktime (23,59,0,date('m'), date('d')+$verfall, date('Y'));
            }
        }
    
        if ( $verfallsdatum >= $pub_datum )
        {
            $verfall = date( "d.m.Y H:i", $verfallsdatum);
        } else {
            $error = "<b>".$LPR_PurgeDate.": </b>".$LP_FailurePurDate."!<br>";
            $message = $message.$error;
            $verfallsdatum = $datum+2592000;
            $fehler = 1;
            $verfall_text = "<font class=\"error\"><b>".$LPR_PurgeDate.":</b></font>";
        }
    }
    
?>
    

