/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.LanguageStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Step;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.WelcomeStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.WizardInterface;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.BlueScreen;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.ImagePanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.Panel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class Wizard
extends JDialog
implements WizardInterface,
ActionListener {
    private static Wizard UNIQUE_WIZARD = null;
    private static BlueScreen blueScreen_;
    JButton btNext_;
    JButton btBack_;
    JButton btCancel_;
    Panel panel_;
    JPanel pnNav_;
    ImageIcon daffodilsm_;

    protected Wizard() {
        this.init();
    }

    protected void init() {
        super.setTitle(Globals.i18n("UI_Title"));
        super.setDefaultCloseOperation(1);
        this.setModal(true);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.setBackground(Color.red);
        this.pnNav_ = new JPanel();
        this.pnNav_.setLayout(new FlowLayout(2));
        this.pnNav_.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.btNext_ = new JButton(Globals.i18n("UI_Next"));
        this.btBack_ = new JButton(Globals.i18n("UI_Back"));
        this.btCancel_ = new JButton(Globals.i18n("UI_Cancel"));
        this.pnNav_.add(this.btCancel_);
        this.pnNav_.add(this.btBack_);
        this.pnNav_.add(this.btNext_);
        this.btNext_.addActionListener(this);
        this.btBack_.addActionListener(this);
        this.btCancel_.addActionListener(this);
        this.panel_ = new Panel();
        Dimension d = ImagePanel.IMAGE_PANEL.getPreferredSize();
        this.panel_.setPreferredSize(new Dimension(d.width + 400, d.height));
        cp.add("Center", this.panel_);
        cp.add("South", this.pnNav_);
        this.pack();
        this.setResizable(false);
        this.daffodilsm_ = Globals.getIcon(Globals.ICONFILE);
        Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimScreen.width - this.getSize().width) / 2, (dimScreen.height - this.getSize().height) / 2);
    }

    public static WizardInterface createWizard() {
        if (UNIQUE_WIZARD == null) {
            UNIQUE_WIZARD = new Wizard();
        } else {
            UNIQUE_WIZARD.init();
        }
        return UNIQUE_WIZARD;
    }

    public void setStep(Step step) {
        this.panel_ = (Panel)step;
        Container pnContent = this.getContentPane();
        pnContent.removeAll();
        this.panel_.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 5, 5, 5))));
        pnContent.add("Center", this.panel_);
        if (step instanceof WelcomeStep || step instanceof LanguageStep) {
            this.btNext_.setText(Globals.i18n("UI_Next"));
            this.btBack_.setText(Globals.i18n("UI_Back"));
            this.btCancel_.setText(Globals.i18n("UI_Cancel"));
            this.doLayout();
            this.validate();
        }
        pnContent.add("South", this.pnNav_);
        pnContent.doLayout();
        this.invalidate();
        pnContent.validate();
        Dimension dimension = this.getSize();
    }

    public Panel getPanel() {
        return this.panel_;
    }

    public void setActionEnabled(int actions) {
        this.btCancel_.setEnabled((actions & 1) == 1);
        this.btBack_.setEnabled((actions & 2) == 2);
        this.btNext_.setEnabled((actions & 4) == 4 || (actions & 8) == 8);
        if ((actions & 8) == 8) {
            this.btNext_.setText(Globals.i18n("UI_Finish"));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.btCancel_) {
            this.dispose(true);
        } else if (src == this.btBack_) {
            this.panel_.backAction();
        } else if (src == this.btNext_) {
            this.panel_.nextAction();
        }
    }

    public void hide(boolean question) {
        if (question) {
            int res = JOptionPane.showConfirmDialog(this, Globals.i18n("UI_AbortQuestion"), Globals.i18n("UI_Finish"), 0, 3, Globals.getIcon(Globals.CANCEL));
            if (res == 0) {
                this.panel_.cancelAction();
            }
        } else {
            super.hide();
        }
    }

    public void dispose() {
        this.hide(true);
    }

    public void dispose(boolean confirm) {
        this.hide(confirm);
    }

    public void show() {
        super.show();
    }

    public void hide() {
        this.hide(true);
    }

    public static void setBlueScreen(BlueScreen blueScreen) {
        blueScreen_ = blueScreen;
    }

    public static Wizard getWizard() {
        return UNIQUE_WIZARD;
    }
}

