/*
 * Decompiled with CFR 0.152.
 */
package se.bysoft.sureshot.products.webeffects.effect;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;
import se.bysoft.sureshot.products.webeffects.effect.EffectComponent;

public class ImageScrollComponent
extends JComponent
implements ActionListener,
EffectComponent {
    private final int _pixels;
    private final boolean _horizontalScroll;
    private final Image[] _images;
    private final Timer _timer;
    private final int _delay;
    private final Dimension _preferredSize;
    private final int _width;
    private final int _height;
    private final int _offscreenImageSize;
    private final int _firstImageSize;
    private Image _offscreenImage = null;
    private int _scrollOffset;

    public ImageScrollComponent(int n, int n2, boolean bl, int n3, int n4, Image[] imageArray) {
        this._pixels = n;
        this._delay = n2;
        this._horizontalScroll = bl;
        this._width = n3;
        this._height = n4;
        this._images = imageArray;
        this._firstImageSize = bl ? imageArray[0].getWidth(null) : imageArray[0].getHeight(null);
        this._preferredSize = new Dimension(n3, n4);
        this._offscreenImageSize = ImageScrollComponent._calculateOffscreenSize(imageArray, bl);
        this._timer = new Timer(n2, this);
    }

    private static int _calculateOffscreenSize(Image[] imageArray, boolean bl) {
        int n = bl ? imageArray[0].getWidth(null) : imageArray[0].getHeight(null);
        int n2 = 0;
        while (n2 < imageArray.length) {
            n += bl ? imageArray[n2].getWidth(null) : imageArray[n2].getHeight(null);
            ++n2;
        }
        return n;
    }

    public void startEffect() {
        this._timer.start();
    }

    public void stopEffect() {
        this._timer.stop();
    }

    public Dimension getPreferredSize() {
        return this._preferredSize;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this._scrollOffset += this._pixels;
        if (this._scrollOffset > this._offscreenImageSize - this._firstImageSize) {
            this._scrollOffset = 0;
        }
        this._createOffscreenImage();
        this.repaint();
    }

    private void _createOffscreenImage() {
        if (this._offscreenImage == null) {
            int n = this._horizontalScroll ? this._offscreenImageSize : this._width;
            int n2 = this._horizontalScroll ? this._height : this._offscreenImageSize;
            this._offscreenImage = this.createImage(n, n2);
            Graphics graphics = this._offscreenImage.getGraphics();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this._images.length) {
                int n6 = this._images[n5].getWidth(null);
                int n7 = this._images[n5].getHeight(null);
                graphics.drawImage(this._images[n5], n3, n4, null);
                n3 += this._horizontalScroll ? n6 : 0;
                n4 += this._horizontalScroll ? 0 : n7;
                ++n5;
            }
            graphics.drawImage(this._images[0], n3, n4, null);
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (this._offscreenImage != null) {
            graphics.drawImage(this._offscreenImage, -(0 + (this._horizontalScroll ? this._scrollOffset : 0)), -(0 + (this._horizontalScroll ? 0 : this._scrollOffset)), null);
        }
        super.paintComponent(graphics);
    }
}

