/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class XMLElement
implements Serializable {
    static final long serialVersionUID = -2383376380548624920L;
    public static final int NO_LINE = -1;
    private Properties attributes = new Properties();
    private Vector children = new Vector(8);
    private String name;
    private String content;
    private String systemID;
    private int lineNr;

    public XMLElement() {
        this(null, null, -1);
    }

    public XMLElement(String string) {
        this(string, null, -1);
    }

    public XMLElement(String string, String string2, int n) {
        this.name = string;
        this.content = null;
        this.lineNr = n;
        this.systemID = string2;
    }

    protected void finalize() throws Throwable {
        this.attributes = null;
        this.children = null;
        this.name = null;
        this.content = null;
        this.systemID = null;
        super.finalize();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = string;
    }

    public void addChild(XMLElement xMLElement) {
        XMLElement xMLElement2;
        if (xMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (xMLElement.getName() == null && !this.children.isEmpty() && (xMLElement2 = (XMLElement)this.children.lastElement()).getName() == null) {
            xMLElement2.setContent(xMLElement2.getContent() + xMLElement.getContent());
            return;
        }
        this.children.addElement(xMLElement);
    }

    public void removeChild(XMLElement xMLElement) {
        if (xMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        this.children.removeElement(xMLElement);
    }

    public void removeChildAtIndex(int n) {
        this.children.removeElementAt(n);
    }

    public Enumeration enumerateChildren() {
        return this.children.elements();
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public Vector getChildren() {
        return this.children;
    }

    public XMLElement getChildAtIndex(int n) throws ArrayIndexOutOfBoundsException {
        return (XMLElement)this.children.elementAt(n);
    }

    public XMLElement getFirstChildNamed(String string) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement = (XMLElement)enumeration.nextElement();
            String string2 = xMLElement.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return xMLElement;
        }
        return null;
    }

    public Vector getChildrenNamed(String string) {
        Vector<XMLElement> vector = new Vector<XMLElement>(this.children.size());
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement = (XMLElement)enumeration.nextElement();
            String string2 = xMLElement.getName();
            if (string2 == null || !string2.equals(string)) continue;
            vector.addElement(xMLElement);
        }
        return vector;
    }

    public String getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    public String getAttribute(String string, String string2) {
        return this.attributes.getProperty(string, string2);
    }

    public void setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public Enumeration enumerateAttributeNames() {
        return this.attributes.keys();
    }

    public boolean hasAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }
}

