/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

public class CompileResult {
    public static final int SUCCESS = 42;
    public static final int FAILED = 23;
    public static final int ACTION_ABORT = 27;
    public static final int ACTION_CONTINUE = 39;
    public static final int ACTION_RECONFIGURE = 31;
    private int status = 42;
    private int action = 27;
    private String message = null;
    private String[] cmdline = null;
    private String stdout = null;
    private String stderr = null;

    public CompileResult() {
        this.status = 42;
        this.action = 39;
    }

    public CompileResult(String string, String[] stringArray, String string2, String string3) {
        this.message = string;
        this.status = 23;
        this.cmdline = stringArray;
        this.stdout = string2;
        this.stderr = string3;
    }

    public void setStatus(int n) {
        if (n == 42 || n == 23) {
            this.status = n;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setAction(int n) {
        if (n == 27 || n == 39 || n == 31) {
            this.action = n;
        }
    }

    public int getAction() {
        return this.action;
    }

    public boolean isSuccess() {
        return this.status == 42;
    }

    public boolean isAbort() {
        return this.status == 23 && this.action == 27;
    }

    public boolean isContinue() {
        return this.status == 42 || this.action == 39;
    }

    public boolean isReconfigure() {
        return this.status == 23 && this.action == 31;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCmdline() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.cmdline.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.cmdline[i]);
        }
        return stringBuffer.toString();
    }

    public String[] getCmdlineArray() {
        return this.cmdline;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }
}

