/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.List;

public class PackFile
implements Serializable {
    public static final int OVERRIDE_FALSE = 0;
    public static final int OVERRIDE_TRUE = 1;
    public static final int OVERRIDE_ASK_FALSE = 2;
    public static final int OVERRIDE_ASK_TRUE = 3;
    public static final int OVERRIDE_UPDATE = 4;
    private String targetPath = null;
    private List osConstraints = null;
    private long length = 0L;
    private long mtime = -1L;
    private boolean isDirectory = false;
    private int override = 0;
    public int previousPackNumber = -1;
    public long offsetInPreviousPack = -1L;

    public PackFile(File file, String string, List list, int n) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("No such file: " + file);
        }
        if ('/' != File.separatorChar) {
            string = string.replace(File.separatorChar, '/');
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.targetPath = string;
        this.osConstraints = list;
        this.override = n;
        this.length = file.length();
        this.mtime = file.lastModified();
        this.isDirectory = file.isDirectory();
    }

    public void setPreviousPackFileRef(int n, long l) {
        this.previousPackNumber = n;
        this.offsetInPreviousPack = l;
    }

    public final List osConstraints() {
        return this.osConstraints;
    }

    public final long length() {
        return this.length;
    }

    public final long lastModified() {
        return this.mtime;
    }

    public final int override() {
        return this.override;
    }

    public final boolean isDirectory() {
        return this.isDirectory;
    }

    public final boolean isBackReference() {
        return this.previousPackNumber >= 0;
    }

    public final String getTargetPath() {
        return this.targetPath;
    }
}

