/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class Selector {
    public static final int iFWidth = 850;
    public static final int iFHeight = 750;
    static final int bThickness = 3;
    static byte[] IObuffer;
    static Thread loadThread;
    static ImageReader currentReader;

    public static void main(String[] stringArray) {
        IObuffer = new byte[512];
        Vignette[] vignetteArray = new Vignette[9];
        JFrame jFrame = new JFrame("Pictures selector");
        GridLayout gridLayout = new GridLayout(3, 3);
        JPanel jPanel = new JPanel(gridLayout);
        for (int i = 0; i < 9; ++i) {
            vignetteArray[i] = new Vignette(3);
            jPanel.add(vignetteArray[i]);
        }
        vignetteArray[4].setBorder(new LineBorder(Color.red, 3));
        jFrame.getContentPane().add(jPanel);
        jFrame.getContentPane().add("South", new SelectorControls(vignetteArray, jFrame));
        jFrame.setSize(850, 750);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    public static boolean moveFile(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            try {
                int n = fileInputStream.read(IObuffer);
                while (n != -1) {
                    fileOutputStream.write(IObuffer);
                    n = fileInputStream.read(IObuffer);
                }
                fileOutputStream.close();
                fileInputStream.close();
                new File(string).delete();
                return true;
            }
            catch (IOException iOException) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                new File(string2).delete();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static void start(Thread thread) {
        loadThread = thread;
        thread.start();
    }

    public static boolean isLoading() {
        if (loadThread == null) {
            return false;
        }
        return loadThread.isAlive();
    }

    public static BufferedImage read(String string) throws IOException {
        Iterator<ImageReader> iterator;
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(new File(string));
        if (imageInputStream == null) {
            throw new IOException();
        }
        if (currentReader == null) {
            iterator = ImageIO.getImageReaders(imageInputStream);
            if (iterator.hasNext()) {
                currentReader = iterator.next();
            } else {
                return null;
            }
        }
        currentReader.setInput(imageInputStream);
        try {
            imageInputStream.mark();
            iterator = currentReader.read(0);
        }
        catch (Throwable throwable) {
            currentReader.dispose();
            imageInputStream.reset();
            Iterator<ImageReader> iterator2 = ImageIO.getImageReaders(imageInputStream);
            if (!iterator2.hasNext()) {
                currentReader = null;
                return null;
            }
            currentReader = iterator2.next();
            currentReader.setInput(imageInputStream);
            try {
                iterator = currentReader.read(0);
            }
            catch (Throwable throwable2) {
                iterator = null;
            }
        }
        currentReader.setInput(null);
        return iterator;
    }
}

